/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.expressions;

import java.time.LocalDateTime;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.expressions.ApiExpressionUtils;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.planner.expressions.utils.MapTypeTestBase;
import org.apache.flink.table.planner.utils.DateTimeTestUtil$;
import org.apache.flink.table.types.DataType;
import org.junit.Test;
import scala.Predef$;
import scala.Symbol;
import scala.Symbol$;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001i2A!\u0001\u0002\u0001\u001f\tYQ*\u00199UsB,G+Z:u\u0015\t\u0019A!A\u0006fqB\u0014Xm]:j_:\u001c(BA\u0003\u0007\u0003\u001d\u0001H.\u00198oKJT!a\u0002\u0005\u0002\u000bQ\f'\r\\3\u000b\u0005%Q\u0011!\u00024mS:\\'BA\u0006\r\u0003\u0019\t\u0007/Y2iK*\tQ\"A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001!A\u0011\u0011\u0003F\u0007\u0002%)\u00111CA\u0001\u0006kRLGn]\u0005\u0003+I\u0011q\"T1q)f\u0004X\rV3ti\n\u000b7/\u001a\u0005\u0006/\u0001!\t\u0001G\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003e\u0001\"A\u0007\u0001\u000e\u0003\tAQ\u0001\b\u0001\u0005\u0002u\t1\u0004^3ti&s\u0007/\u001e;UsB,w)\u001a8fe\u0006d\u0017N_1uS>tG#\u0001\u0010\u0011\u0005}\u0011S\"\u0001\u0011\u000b\u0003\u0005\nQa]2bY\u0006L!a\t\u0011\u0003\tUs\u0017\u000e\u001e\u0015\u00037\u0015\u0002\"AJ\u0015\u000e\u0003\u001dR!\u0001\u000b\u0007\u0002\u000b),h.\u001b;\n\u0005):#\u0001\u0002+fgRDQ\u0001\f\u0001\u0005\u0002u\t\u0001\u0002^3ti&#X-\u001c\u0015\u0003W\u0015BQa\f\u0001\u0005\u0002u\ta\u0002^3ti6\u000b\u0007\u000fT5uKJ\fG\u000e\u000b\u0002/K!)!\u0007\u0001C\u0001;\u0005aA/Z:u\u001b\u0006\u0004h)[3mI\"\u0012\u0011'\n\u0005\u0006k\u0001!\t!H\u0001\u0012i\u0016\u001cH/T1q\u001fB,'/\u0019;j_:\u001c\bF\u0001\u001b&\u0011\u0015A\u0004\u0001\"\u0001\u001e\u0003I!Xm\u001d;NCB$\u0016\u0010]3DCN$\u0018N\\4)\u0005]*\u0003")
public class MapTypeTest
extends MapTypeTestBase {
    private static Symbol symbol$1 = Symbol$.MODULE$.apply("f4");
    private static Symbol symbol$2 = Symbol$.MODULE$.apply("f5");
    private static Symbol symbol$3 = Symbol$.MODULE$.apply("f1");
    private static Symbol symbol$4 = Symbol$.MODULE$.apply("f2");
    private static Symbol symbol$5 = Symbol$.MODULE$.apply("f3");
    private static Symbol symbol$6 = Symbol$.MODULE$.apply("f7");
    private static Symbol symbol$7 = Symbol$.MODULE$.apply("f8");
    private static Symbol symbol$8 = Symbol$.MODULE$.apply("f9");
    private static Symbol symbol$9 = Symbol$.MODULE$.apply("f10");
    private static Symbol symbol$10 = Symbol$.MODULE$.apply("f11");
    private static Symbol symbol$11 = Symbol$.MODULE$.apply("f0");

    @Test
    public void testInputTypeGeneralization() {
        this.testAllApis(package$.MODULE$.map(package$.MODULE$.int2Literal(1), package$.MODULE$.string2Literal("ABC"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.double2Literal(2.0), package$.MODULE$.string2Literal("D")})), "map(1, 'ABC', 2.0, 'D')", "MAP[1, 'ABC', cast(2.0 AS DOUBLE), 'D']", "{1.0=ABC, 2.0=D}");
    }

    @Test
    public void testItem() {
        this.testSqlApi("f0['map is null']", "null");
        this.testSqlApi("f1['map is empty']", "null");
        this.testSqlApi("f2['b']", "13");
        this.testSqlApi("f3[1]", "null");
        this.testSqlApi("f3[12]", "a");
        this.testSqlApi("f2[f3[12]]", "12");
    }

    @Test
    public void testMapLiteral() {
        this.testAllApis(package$.MODULE$.map(package$.MODULE$.int2Literal(1), package$.MODULE$.int2Literal(1), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[0])), "map(1, 1)", "MAP[1, 1]", "{1=1}");
        this.testAllApis(package$.MODULE$.map(package$.MODULE$.boolean2Literal(true), package$.MODULE$.boolean2Literal(true), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[0])), "map(true, true)", "map[TRUE, TRUE]", "{true=true}");
        this.testTableApi(package$.MODULE$.map(package$.MODULE$.scalaDec2Literal(scala.package$.MODULE$.BigDecimal().apply(1)), package$.MODULE$.scalaDec2Literal(scala.package$.MODULE$.BigDecimal().apply(1)), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[0])), "map(1p, 1p)", "{1=1}");
        this.testAllApis(package$.MODULE$.map(package$.MODULE$.map(package$.MODULE$.int2Literal(1), package$.MODULE$.int2Literal(2), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[0])), package$.MODULE$.map(package$.MODULE$.int2Literal(3), package$.MODULE$.int2Literal(4), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[0])), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[0])), "map(map(1, 2), map(3, 4))", "MAP[MAP[1, 2], MAP[3, 4]]", "{{1=2}={3=4}}");
        this.testAllApis(package$.MODULE$.map(package$.MODULE$.int2Literal(3), package$.MODULE$.int2Literal(9), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.int2Literal(-3), package$.MODULE$.int2Literal(2)})), "map(1 + 2, 3 * 3, 3 - 6, 4 - 2)", "map[1 + 2, 3 * 3, 3 - 6, 4 - 2]", "{3=9, -3=2}");
        this.testAllApis(package$.MODULE$.map(package$.MODULE$.int2Literal(1), package$.MODULE$.nullOf(DataTypes.INT()), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[0])), "map(1, Null(INT))", "map[1, NULLIF(1,1)]", "{1=null}");
        this.testAllApis(package$.MODULE$.map(package$.MODULE$.int2Literal(1), package$.MODULE$.long2Literal(2L), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.int2Literal(3), package$.MODULE$.long2Literal(4L)})), "map(1, 2L, 3, 4L)", "MAP[1, CAST(2 AS BIGINT), 3, CAST(4 AS BIGINT)]", "{1=2, 3=4}");
        this.testAllApis(package$.MODULE$.map((Expression)ApiExpressionUtils.valueLiteral((Object)DateTimeTestUtil$.MODULE$.localDate("1985-04-11")), (Expression)ApiExpressionUtils.valueLiteral((Object)DateTimeTestUtil$.MODULE$.localTime("14:15:16")), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{ApiExpressionUtils.valueLiteral((Object)DateTimeTestUtil$.MODULE$.localDate("2018-07-26")), ApiExpressionUtils.valueLiteral((Object)DateTimeTestUtil$.MODULE$.localTime("17:18:19"))})), "map('1985-04-11'.toDate, '14:15:16'.toTime, '2018-07-26'.toDate, '17:18:19'.toTime)", "MAP[DATE '1985-04-11', TIME '14:15:16', DATE '2018-07-26', TIME '17:18:19']", "{1985-04-11=14:15:16, 2018-07-26=17:18:19}");
        this.testTableApi(package$.MODULE$.map((Expression)ApiExpressionUtils.valueLiteral((Object)DateTimeTestUtil$.MODULE$.localTime("14:15:16")), (Expression)ApiExpressionUtils.valueLiteral((Object)DateTimeTestUtil$.MODULE$.localDateTime("1985-04-11 14:15:16")), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{ApiExpressionUtils.valueLiteral((Object)DateTimeTestUtil$.MODULE$.localTime("17:18:19")), ApiExpressionUtils.valueLiteral((Object)DateTimeTestUtil$.MODULE$.localDateTime("2018-07-26 17:18:19"))})), "{14:15:16=1985-04-11 14:15:16, 17:18:19=2018-07-26 17:18:19}");
        this.testSqlApi("MAP[TIME '14:15:16', TIMESTAMP '1985-04-11 14:15:16', TIME '17:18:19', TIMESTAMP '2018-07-26 17:18:19']", "{14:15:16=1985-04-11 14:15:16, 17:18:19=2018-07-26 17:18:19}");
        this.testAllApis(package$.MODULE$.map((Expression)ApiExpressionUtils.valueLiteral((Object)DateTimeTestUtil$.MODULE$.localTime("14:15:16")), (Expression)ApiExpressionUtils.valueLiteral((Object)DateTimeTestUtil$.MODULE$.localDateTime("1985-04-11 14:15:16.123")), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{ApiExpressionUtils.valueLiteral((Object)DateTimeTestUtil$.MODULE$.localTime("17:18:19")), ApiExpressionUtils.valueLiteral((Object)DateTimeTestUtil$.MODULE$.localDateTime("2018-07-26 17:18:19.123"))})), "map('14:15:16'.toTime, '1985-04-11 14:15:16.123'.toTimestamp, '17:18:19'.toTime, '2018-07-26 17:18:19.123'.toTimestamp)", "MAP[TIME '14:15:16', TIMESTAMP '1985-04-11 14:15:16.123', TIME '17:18:19', TIMESTAMP '2018-07-26 17:18:19.123']", "{14:15:16=1985-04-11 14:15:16.123, 17:18:19=2018-07-26 17:18:19.123}");
        this.testTableApi(package$.MODULE$.map((Expression)ApiExpressionUtils.valueLiteral((Object)DateTimeTestUtil$.MODULE$.localTime("14:15:16")), (Expression)ApiExpressionUtils.valueLiteral((Object)LocalDateTime.of(1985, 4, 11, 14, 15, 16, 123456000)), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{ApiExpressionUtils.valueLiteral((Object)DateTimeTestUtil$.MODULE$.localTime("17:18:19")), ApiExpressionUtils.valueLiteral((Object)LocalDateTime.of(2018, 7, 26, 17, 18, 19, 123456000))})), "{14:15:16=1985-04-11 14:15:16.123456, 17:18:19=2018-07-26 17:18:19.123456}");
        this.testSqlApi("MAP[TIME '14:15:16', TIMESTAMP '1985-04-11 14:15:16.123456', TIME '17:18:19', TIMESTAMP '2018-07-26 17:18:19.123456']", "{14:15:16=1985-04-11 14:15:16.123456, 17:18:19=2018-07-26 17:18:19.123456}");
        this.testAllApis(package$.MODULE$.map(package$.MODULE$.scalaDec2Literal(scala.package$.MODULE$.BigDecimal().apply(2.0002)), package$.MODULE$.scalaDec2Literal(scala.package$.MODULE$.BigDecimal().apply(2.0003)), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[0])), "map(2.0002p, 2.0003p)", "MAP[CAST(2.0002 AS DECIMAL(5, 4)), CAST(2.0003 AS DECIMAL(5, 4))]", "{2.0002=2.0003}");
        this.testSqlApi("MAP['k1', CAST(1 AS DOUBLE), 'k2', CAST(2 AS FLOAT)]", "{k1=1.0, k2=2.0}");
    }

    @Test
    public void testMapField() {
        this.testAllApis(package$.MODULE$.map(package$.MODULE$.symbol2FieldExpression(symbol$1), package$.MODULE$.symbol2FieldExpression(symbol$2), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[0])), "map(f4, f5)", "MAP[f4, f5]", "{foo=12}");
        this.testAllApis(package$.MODULE$.map(package$.MODULE$.symbol2FieldExpression(symbol$1), package$.MODULE$.symbol2FieldExpression(symbol$3), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[0])), "map(f4, f1)", "MAP[f4, f1]", "{foo={}}");
        this.testAllApis(package$.MODULE$.map(package$.MODULE$.symbol2FieldExpression(symbol$4), package$.MODULE$.symbol2FieldExpression(symbol$5), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[0])), "map(f2, f3)", "MAP[f2, f3]", "{{a=12, b=13}={12=a, 13=b}}");
        this.testAllApis(package$.MODULE$.map((Expression)package$.MODULE$.UnresolvedFieldExpression(symbol$3).at((Object)package$.MODULE$.string2Literal("a")), package$.MODULE$.symbol2FieldExpression(symbol$2), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[0])), "map(f1.at('a'), f5)", "MAP[f1['a'], f5]", "{null=12}");
        this.testAllApis(package$.MODULE$.symbol2FieldExpression(symbol$3), "f1", "f1", "{}");
        this.testAllApis(package$.MODULE$.symbol2FieldExpression(symbol$4), "f2", "f2", "{a=12, b=13}");
        this.testAllApis((Expression)package$.MODULE$.UnresolvedFieldExpression(symbol$4).at((Object)package$.MODULE$.string2Literal("a")), "f2.at('a')", "f2['a']", "12");
        this.testAllApis((Expression)package$.MODULE$.UnresolvedFieldExpression(symbol$5).at((Object)package$.MODULE$.int2Literal(12)), "f3.at(12)", "f3[12]", "a");
        this.testAllApis((Expression)package$.MODULE$.WithOperations((Expression)package$.MODULE$.WithOperations(package$.MODULE$.map(package$.MODULE$.symbol2FieldExpression(symbol$1), package$.MODULE$.symbol2FieldExpression(symbol$5), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[0]))).at((Object)package$.MODULE$.string2Literal("foo"))).at((Object)package$.MODULE$.int2Literal(13)), "map(f4, f3).at('foo').at(13)", "MAP[f4, f3]['foo'][13]", "b");
    }

    @Test
    public void testMapOperations() {
        this.testAllApis(package$.MODULE$.UnresolvedFieldExpression(symbol$3).$eq$eq$eq(package$.MODULE$.symbol2FieldExpression(symbol$4)), "f1 === f2", "f1 = f2", "false");
        this.testAllApis(package$.MODULE$.UnresolvedFieldExpression(symbol$5).$eq$eq$eq(package$.MODULE$.symbol2FieldExpression(symbol$6)), "f3 === f7", "f3 = f7", "true");
        this.testAllApis(package$.MODULE$.UnresolvedFieldExpression(symbol$2).$eq$eq$eq((Expression)package$.MODULE$.UnresolvedFieldExpression(symbol$4).at((Object)package$.MODULE$.string2Literal("a"))), "f5 === f2.at('a')", "f5 = f2['a']", "true");
        this.testAllApis(package$.MODULE$.UnresolvedFieldExpression(symbol$7).$eq$eq$eq(package$.MODULE$.symbol2FieldExpression(symbol$8)), "f8 === f9", "f8 = f9", "true");
        this.testAllApis(package$.MODULE$.UnresolvedFieldExpression(symbol$9).$eq$eq$eq(package$.MODULE$.symbol2FieldExpression(symbol$10)), "f10 === f11", "f10 = f11", "true");
        this.testAllApis(package$.MODULE$.UnresolvedFieldExpression(symbol$7).$bang$eq$eq(package$.MODULE$.symbol2FieldExpression(symbol$8)), "f8 !== f9", "f8 <> f9", "false");
        this.testAllApis(package$.MODULE$.UnresolvedFieldExpression(symbol$9).$bang$eq$eq(package$.MODULE$.symbol2FieldExpression(symbol$10)), "f10 !== f11", "f10 <> f11", "false");
        this.testAllApis((Expression)package$.MODULE$.UnresolvedFieldExpression(symbol$11).at((Object)package$.MODULE$.string2Literal("map is null")), "f0.at('map is null')", "f0['map is null']", "null");
        this.testAllApis((Expression)package$.MODULE$.UnresolvedFieldExpression(symbol$3).at((Object)package$.MODULE$.string2Literal("map is empty")), "f1.at('map is empty')", "f1['map is empty']", "null");
        this.testAllApis((Expression)package$.MODULE$.UnresolvedFieldExpression(symbol$4).at((Object)package$.MODULE$.string2Literal("b")), "f2.at('b')", "f2['b']", "13");
        this.testAllApis((Expression)package$.MODULE$.UnresolvedFieldExpression(symbol$5).at((Object)package$.MODULE$.int2Literal(1)), "f3.at(1)", "f3[1]", "null");
        this.testAllApis((Expression)package$.MODULE$.UnresolvedFieldExpression(symbol$5).at((Object)package$.MODULE$.int2Literal(12)), "f3.at(12)", "f3[12]", "a");
        this.testAllApis((Expression)package$.MODULE$.UnresolvedFieldExpression(symbol$5).cardinality(), "f3.cardinality()", "CARDINALITY(f3)", "2");
        this.testAllApis((Expression)package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression(symbol$4).at((Object)package$.MODULE$.string2Literal("a"))).isNotNull(), "f2.at('a').isNotNull", "f2['a'] IS NOT NULL", "true");
        this.testAllApis((Expression)package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression(symbol$4).at((Object)package$.MODULE$.string2Literal("a"))).isNull(), "f2.at('a').isNull", "f2['a'] IS NULL", "false");
        this.testAllApis((Expression)package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression(symbol$4).at((Object)package$.MODULE$.string2Literal("c"))).isNotNull(), "f2.at('c').isNotNull", "f2['c'] IS NOT NULL", "false");
        this.testAllApis((Expression)package$.MODULE$.WithOperations((Expression)package$.MODULE$.UnresolvedFieldExpression(symbol$4).at((Object)package$.MODULE$.string2Literal("c"))).isNull(), "f2.at('c').isNull", "f2['c'] IS NULL", "true");
    }

    @Test
    public void testMapTypeCasting() {
        this.testTableApi((Expression)package$.MODULE$.UnresolvedFieldExpression(symbol$4).cast(DataTypes.MAP((DataType)DataTypes.STRING(), (DataType)DataTypes.INT())), "f2.cast(MAP(STRING, INT))", "{a=12, b=13}");
    }
}

