/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.expressions;

import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.functions.ScalarFunction;
import org.apache.flink.table.planner.expressions.utils.ExpressionTestBase;
import org.apache.flink.table.planner.expressions.utils.Func3$;
import org.apache.flink.types.Row;
import org.junit.Test;
import scala.Predef;
import scala.Predef$;
import scala.StringContext;
import scala.Symbol;
import scala.Symbol$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001q3A!\u0001\u0002\u0001\u001f\tYA*\u001b;fe\u0006dG+Z:u\u0015\t\u0019A!A\u0006fqB\u0014Xm]:j_:\u001c(BA\u0003\u0007\u0003\u001d\u0001H.\u00198oKJT!a\u0002\u0005\u0002\u000bQ\f'\r\\3\u000b\u0005%Q\u0011!\u00024mS:\\'BA\u0006\r\u0003\u0019\t\u0007/Y2iK*\tQ\"A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001!A\u0011\u0011\u0003F\u0007\u0002%)\u00111CA\u0001\u0006kRLGn]\u0005\u0003+I\u0011!#\u0012=qe\u0016\u001c8/[8o)\u0016\u001cHOQ1tK\")q\u0003\u0001C\u00011\u00051A(\u001b8jiz\"\u0012!\u0007\t\u00035\u0001i\u0011A\u0001\u0005\u00069\u0001!\t!H\u0001\u001bi\u0016\u001cHOR5fY\u0012<\u0016\u000e\u001e5C_>dW-\u00198Qe\u00164\u0017\u000e\u001f\u000b\u0002=A\u0011qDI\u0007\u0002A)\t\u0011%A\u0003tG\u0006d\u0017-\u0003\u0002$A\t!QK\\5uQ\tYR\u0005\u0005\u0002'S5\tqE\u0003\u0002)\u0019\u0005)!.\u001e8ji&\u0011!f\n\u0002\u0005)\u0016\u001cH\u000fC\u0003-\u0001\u0011\u0005Q$A\nuKN$hj\u001c8Bg\u000eL\u0017\u000eT5uKJ\fG\u000e\u000b\u0002,K!)q\u0006\u0001C\u0001;\u0005yA/Z:u\t>,(\r\\3Rk>$X\r\u000b\u0002/K!)!\u0007\u0001C\u0001;\u0005\u0011B/Z:u'R\u0014\u0018N\\4MSR,'/\u00197tQ\t\tT\u0005C\u00036\u0001\u0011\u0005c'A\u0005gk:\u001cG/[8ogV\tq\u0007\u0005\u00039wy\neBA\u0010:\u0013\tQ\u0004%\u0001\u0004Qe\u0016$WMZ\u0005\u0003yu\u00121!T1q\u0015\tQ\u0004\u0005\u0005\u00029\u007f%\u0011\u0001)\u0010\u0002\u0007'R\u0014\u0018N\\4\u0011\u0005\t#U\"A\"\u000b\u0005U2\u0011BA#D\u00059\u00196-\u00197be\u001a+hn\u0019;j_:DQa\u0012\u0001\u0005B!\u000b\u0001\u0002^3ti\u0012\u000bG/Y\u000b\u0002\u0013B\u0011!*T\u0007\u0002\u0017*\u0011A\nC\u0001\u0006if\u0004Xm]\u0005\u0003\u001d.\u00131AU8x\u0011\u0015\u0001\u0006\u0001\"\u0011R\u0003!!\u0018\u0010]3J]\u001a|W#\u0001*\u0011\u0005MSV\"\u0001+\u000b\u0005U3\u0016!\u0003;za\u0016,H/\u001b7t\u0015\t9\u0006,\u0001\u0003kCZ\f'BA-\t\u0003\r\t\u0007/[\u0005\u00037R\u00131BU8x)f\u0004X-\u00138g_\u0002")
public class LiteralTest
extends ExpressionTestBase {
    private static Symbol symbol$1 = Symbol$.MODULE$.apply("trUeX");
    private static Symbol symbol$2 = Symbol$.MODULE$.apply("FALSE_A");
    private static Symbol symbol$3 = Symbol$.MODULE$.apply("FALSE_AB");
    private static Symbol symbol$4 = Symbol$.MODULE$.apply("f4");

    @Test
    public void testFieldWithBooleanPrefix() {
        this.testAllApis(package$.MODULE$.symbol2FieldExpression(symbol$1), "trUeX", "trUeX", "trUeX_value");
        this.testAllApis(package$.MODULE$.symbol2FieldExpression(symbol$2), "FALSE_A", "FALSE_A", "FALSE_A_value");
        this.testAllApis(package$.MODULE$.symbol2FieldExpression(symbol$3), "FALSE_AB", "FALSE_AB", "FALSE_AB_value");
        this.testAllApis(package$.MODULE$.boolean2Literal(true), "trUe", "trUe", "true");
        this.testAllApis(package$.MODULE$.boolean2Literal(false), "FALSE", "FALSE", "false");
    }

    @Test
    public void testNonAsciiLiteral() {
        this.testAllApis((Expression)package$.MODULE$.UnresolvedFieldExpression(symbol$4).like((Object)package$.MODULE$.string2Literal("%\u6d4b\u8bd5%")), "f4.like('%\u6d4b\u8bd5%')", "f4 LIKE '%\u6d4b\u8bd5%'", "true");
        this.testAllApis(package$.MODULE$.string2Literal("\u0410\u0431\u0432\u0433\u0434\u0435\u8c22\u8c22"), "'\u0410\u0431\u0432\u0433\u0434\u0435' + '\u8c22\u8c22'", "'\u0410\u0431\u0432\u0433\u0434\u0435' || '\u8c22\u8c22'", "\u0410\u0431\u0432\u0433\u0434\u0435\u8c22\u8c22");
    }

    @Test
    public void testDoubleQuote() {
        String hello = "\"<hello>\"";
        this.testAllApis(package$.MODULE$.ScalarFunctionCall((ScalarFunction)Func3$.MODULE$).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.int2Literal(42), package$.MODULE$.string2Literal(hello)})), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Func3(42, '", "')"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{hello})), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Func3(42, '", "')"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{hello})), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"42 and ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{hello})));
    }

    @Test
    public void testStringLiterals() {
        this.testAllApis(package$.MODULE$.string2Literal(">\n<"), "'>\n<'", "'>\n<'", ">\n<");
        this.testAllApis(package$.MODULE$.string2Literal(">\u263a<"), "'>\u263a<'", "'>\u263a<'", ">\u263a<");
        this.testAllApis(package$.MODULE$.string2Literal(">\\<"), "'>\\<'", "'>\\<'", ">\\<");
        this.testAllApis(package$.MODULE$.string2Literal(">'<"), "'>''<'", "'>''<'", ">'<");
        this.testAllApis(package$.MODULE$.string2Literal(" "), "' '", "' '", " ");
        this.testAllApis(package$.MODULE$.string2Literal(""), "''", "''", "");
        this.testAllApis(package$.MODULE$.string2Literal(">foo([\\w]+)<"), "'>foo([\\w]+)<'", "'>foo([\\w]+)<'", ">foo([\\w]+)<");
        this.testAllApis(package$.MODULE$.string2Literal(">\\'\n<"), "\">\\'\n<\"", "'>\\''\n<'", ">\\'\n<");
        this.testAllApis(package$.MODULE$.string2Literal("It's me."), "'It''s me.'", "'It''s me.'", "It's me.");
        this.testSqlApi("U&'>\\263A<'", ">\u263a<");
        this.testSqlApi("U&'>#263A<' UESCAPE '#'", ">\u263a<");
        this.testSqlApi("'>\\\\<'", ">\\\\<");
    }

    @Override
    public Map<String, ScalarFunction> functions() {
        return (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Func3"), (Object)Func3$.MODULE$)}));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Row testData() {
        void var1_1;
        Row testData = new Row(4);
        testData.setField(0, (Object)"trUeX_value");
        testData.setField(1, (Object)"FALSE_A_value");
        testData.setField(2, (Object)"FALSE_AB_value");
        testData.setField(3, (Object)"\u8fd9\u662f\u4e2a\u6d4b\u8bd5\u5b57\u7b26\u4e32");
        return var1_1;
    }

    @Override
    public RowTypeInfo typeInfo() {
        return new RowTypeInfo((TypeInformation[])((Object[])new TypeInformation[]{Types.STRING, Types.STRING, Types.STRING, Types.STRING}), (String[])((Object[])new String[]{"trUeX", "FALSE_A", "FALSE_AB", "f4"}));
    }
}

