/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.delegation;

import java.util.Collections;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.connector.source.Boundedness;
import org.apache.flink.api.dag.Pipeline;
import org.apache.flink.streaming.api.environment.LocalStreamEnvironment;
import org.apache.flink.streaming.api.functions.source.SourceFunction;
import org.apache.flink.streaming.api.graph.StreamGraph;
import org.apache.flink.streaming.api.operators.StreamSource;
import org.apache.flink.streaming.api.transformations.LegacySourceTransformation;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.planner.delegation.BatchExecutor;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.Test;

public class BatchExecutorTest
extends TestLogger {
    private final BatchExecutor batchExecutor = new BatchExecutor(LocalStreamEnvironment.getExecutionEnvironment());
    private final StreamGraph streamGraph;

    public BatchExecutorTest() {
        LegacySourceTransformation testTransform = new LegacySourceTransformation("MockTransform", new StreamSource((SourceFunction)new SourceFunction<String>(){

            public void run(SourceFunction.SourceContext<String> ctx) {
            }

            public void cancel() {
            }
        }), (TypeInformation)BasicTypeInfo.STRING_TYPE_INFO, 1, Boundedness.BOUNDED);
        Pipeline pipeline = this.batchExecutor.createPipeline(Collections.singletonList(testTransform), new TableConfig(), "Test Job");
        this.streamGraph = (StreamGraph)pipeline;
    }

    @Test
    public void testAllVerticesInSameSlotSharingGroupByDefaultIsDisabled() {
        Assert.assertFalse((boolean)this.streamGraph.isAllVerticesInSameSlotSharingGroupByDefault());
    }
}

