/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.catalog;

import java.math.BigDecimal;
import java.sql.Date;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import org.apache.calcite.avatica.util.DateTimeUtils;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.EnvironmentSettings;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.api.internal.TableEnvironmentImpl;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.CatalogBaseTable;
import org.apache.flink.table.catalog.CatalogPartition;
import org.apache.flink.table.catalog.CatalogPartitionImpl;
import org.apache.flink.table.catalog.CatalogPartitionSpec;
import org.apache.flink.table.catalog.CatalogTableImpl;
import org.apache.flink.table.catalog.ConnectorCatalogTable;
import org.apache.flink.table.catalog.ObjectPath;
import org.apache.flink.table.catalog.exceptions.TableNotExistException;
import org.apache.flink.table.catalog.exceptions.TablePartitionedException;
import org.apache.flink.table.catalog.stats.CatalogColumnStatistics;
import org.apache.flink.table.catalog.stats.CatalogColumnStatisticsDataBoolean;
import org.apache.flink.table.catalog.stats.CatalogColumnStatisticsDataDate;
import org.apache.flink.table.catalog.stats.CatalogColumnStatisticsDataDouble;
import org.apache.flink.table.catalog.stats.CatalogColumnStatisticsDataLong;
import org.apache.flink.table.catalog.stats.CatalogColumnStatisticsDataString;
import org.apache.flink.table.catalog.stats.CatalogTableStatistics;
import org.apache.flink.table.plan.stats.TableStats;
import org.apache.flink.table.planner.delegation.PlannerBase;
import org.apache.flink.table.planner.plan.metadata.FlinkRelMetadataQuery;
import org.apache.flink.table.planner.plan.stats.ValueInterval$;
import org.apache.flink.table.planner.utils.TableTestUtil;
import org.apache.flink.table.planner.utils.TestPartitionableSourceFactory;
import org.apache.flink.table.planner.utils.TestTableSource;
import org.apache.flink.table.sources.TableSource;
import org.apache.flink.table.types.DataType;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CatalogStatisticsTest {
    private String databaseName = "default_database";
    private TableSchema tableSchema = TableSchema.builder().fields(new String[]{"b1", "l2", "s3", "d4", "dd5"}, new DataType[]{DataTypes.BOOLEAN(), DataTypes.BIGINT(), DataTypes.STRING(), DataTypes.DATE(), DataTypes.DOUBLE()}).build();
    private TableEnvironment tEnv;
    private Catalog catalog;

    @Before
    public void setup() {
        EnvironmentSettings settings = EnvironmentSettings.newInstance().inBatchMode().build();
        this.tEnv = TableEnvironment.create((EnvironmentSettings)settings);
        this.catalog = this.tEnv.getCatalog(this.tEnv.getCurrentCatalog()).orElse(null);
        Assert.assertNotNull((Object)this.catalog);
    }

    @Test
    public void testGetStatsFromCatalogForConnectorCatalogTable() throws Exception {
        this.catalog.createTable(new ObjectPath(this.databaseName, "T1"), (CatalogBaseTable)ConnectorCatalogTable.source((TableSource)new TestTableSource(true, this.tableSchema), (boolean)true), false);
        this.catalog.createTable(new ObjectPath(this.databaseName, "T2"), (CatalogBaseTable)ConnectorCatalogTable.source((TableSource)new TestTableSource(true, this.tableSchema), (boolean)true), false);
        this.alterTableStatistics(this.catalog, "T1");
        this.assertStatistics(this.tEnv, "T1");
        this.alterTableStatisticsWithUnknownRowCount(this.catalog, "T2");
        this.assertTableStatisticsWithUnknownRowCount(this.tEnv, "T2");
    }

    @Test
    public void testGetStatsFromCatalogForCatalogTableImpl() throws Exception {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("connector.type", "filesystem");
        properties.put("connector.property-version", "1");
        properties.put("connector.path", "/path/to/csv");
        properties.put("format.type", "csv");
        properties.put("format.property-version", "1");
        properties.put("format.field-delimiter", ";");
        this.catalog.createTable(new ObjectPath(this.databaseName, "T1"), (CatalogBaseTable)new CatalogTableImpl(this.tableSchema, properties, ""), false);
        this.catalog.createTable(new ObjectPath(this.databaseName, "T2"), (CatalogBaseTable)new CatalogTableImpl(this.tableSchema, properties, ""), false);
        this.alterTableStatistics(this.catalog, "T1");
        this.assertStatistics(this.tEnv, "T1");
        this.alterTableStatisticsWithUnknownRowCount(this.catalog, "T2");
        this.assertTableStatisticsWithUnknownRowCount(this.tEnv, "T2");
    }

    private void alterTableStatistics(Catalog catalog, String tableName) throws TableNotExistException, TablePartitionedException {
        catalog.alterTableStatistics(new ObjectPath(this.databaseName, tableName), new CatalogTableStatistics(100L, 10, 1000L, 2000L), true);
        catalog.alterTableColumnStatistics(new ObjectPath(this.databaseName, tableName), this.createColumnStats(), true);
    }

    @Test
    public void testGetPartitionStatsFromCatalog() throws Exception {
        TestPartitionableSourceFactory.createTemporaryTable(this.tEnv, "PartT", true);
        this.createPartitionStats("A", 1);
        this.createPartitionColumnStats("A", 1);
        this.createPartitionStats("A", 2);
        this.createPartitionColumnStats("A", 2);
        RelNode t1 = ((PlannerBase)((TableEnvironmentImpl)this.tEnv).getPlanner()).optimize(TableTestUtil.toRelNode(this.tEnv.sqlQuery("select id, name from PartT where part1 = 'A'")));
        FlinkRelMetadataQuery mq = FlinkRelMetadataQuery.reuseOrCreate((RelMetadataQuery)t1.getCluster().getMetadataQuery());
        Assert.assertEquals((double)200.0, (double)mq.getRowCount(t1), (double)0.0);
        Assert.assertEquals(Arrays.asList(8.0, 43.5), (Object)mq.getAverageColumnSizes(t1));
        Assert.assertEquals((double)46.0, (double)mq.getDistinctRowCount(t1, ImmutableBitSet.of((int[])new int[]{0}), null), (double)0.0);
        Assert.assertEquals((double)154.0, (double)mq.getColumnNullCount(t1, 0), (double)0.0);
        Assert.assertEquals((Object)ValueInterval$.MODULE$.apply((Object)BigDecimal.valueOf(-123L), (Object)BigDecimal.valueOf(763322L), true, true), (Object)mq.getColumnInterval(t1, 0));
        Assert.assertEquals((double)40.0, (double)mq.getDistinctRowCount(t1, ImmutableBitSet.of((int[])new int[]{1}), null), (double)0.0);
        Assert.assertEquals((double)0.0, (double)mq.getColumnNullCount(t1, 1), (double)0.0);
        Assert.assertNull((Object)mq.getColumnInterval(t1, 1));
    }

    @Test
    public void testGetPartitionStatsWithUnknownRowCount() throws Exception {
        TestPartitionableSourceFactory.createTemporaryTable(this.tEnv, "PartT", true);
        this.createPartitionStats("A", 1, TableStats.UNKNOWN.getRowCount());
        this.createPartitionColumnStats("A", 1);
        this.createPartitionStats("A", 2);
        this.createPartitionColumnStats("A", 2);
        RelNode t1 = ((PlannerBase)((TableEnvironmentImpl)this.tEnv).getPlanner()).optimize(TableTestUtil.toRelNode(this.tEnv.sqlQuery("select id, name from PartT where part1 = 'A'")));
        FlinkRelMetadataQuery mq = FlinkRelMetadataQuery.reuseOrCreate((RelMetadataQuery)t1.getCluster().getMetadataQuery());
        Assert.assertEquals((double)1.0E8, (double)mq.getRowCount(t1), (double)0.0);
        Assert.assertEquals(Arrays.asList(8.0, 43.5), (Object)mq.getAverageColumnSizes(t1));
        Assert.assertEquals((double)46.0, (double)mq.getDistinctRowCount(t1, ImmutableBitSet.of((int[])new int[]{0}), null), (double)0.0);
        Assert.assertEquals((double)154.0, (double)mq.getColumnNullCount(t1, 0), (double)0.0);
        Assert.assertEquals((Object)ValueInterval$.MODULE$.apply((Object)BigDecimal.valueOf(-123L), (Object)BigDecimal.valueOf(763322L), true, true), (Object)mq.getColumnInterval(t1, 0));
        Assert.assertEquals((double)40.0, (double)mq.getDistinctRowCount(t1, ImmutableBitSet.of((int[])new int[]{1}), null), (double)0.0);
        Assert.assertEquals((double)0.0, (double)mq.getColumnNullCount(t1, 1), (double)0.0);
        Assert.assertNull((Object)mq.getColumnInterval(t1, 1));
    }

    @Test
    public void testGetPartitionStatsWithUnknownColumnStats() throws Exception {
        TestPartitionableSourceFactory.createTemporaryTable(this.tEnv, "PartT", true);
        this.createPartitionStats("A", 1);
        this.createPartitionStats("A", 2);
        this.createPartitionColumnStats("A", 2);
        RelNode t1 = ((PlannerBase)((TableEnvironmentImpl)this.tEnv).getPlanner()).optimize(TableTestUtil.toRelNode(this.tEnv.sqlQuery("select id, name from PartT where part1 = 'A'")));
        FlinkRelMetadataQuery mq = FlinkRelMetadataQuery.reuseOrCreate((RelMetadataQuery)t1.getCluster().getMetadataQuery());
        Assert.assertEquals((double)200.0, (double)mq.getRowCount(t1), (double)0.0);
        Assert.assertNull((Object)mq.getDistinctRowCount(t1, ImmutableBitSet.of((int[])new int[]{0}), null));
        Assert.assertNull((Object)mq.getColumnNullCount(t1, 0));
        Assert.assertNull((Object)mq.getColumnInterval(t1, 0));
        Assert.assertNull((Object)mq.getDistinctRowCount(t1, ImmutableBitSet.of((int[])new int[]{1}), null));
        Assert.assertNull((Object)mq.getColumnNullCount(t1, 1));
    }

    @Test
    public void testGetPartitionStatsWithSomeUnknownColumnStats() throws Exception {
        TestPartitionableSourceFactory.createTemporaryTable(this.tEnv, "PartT", true);
        this.createPartitionStats("A", 1);
        this.createPartitionColumnStats("A", 1, true);
        this.createPartitionStats("A", 2);
        this.createPartitionColumnStats("A", 2);
        RelNode t1 = ((PlannerBase)((TableEnvironmentImpl)this.tEnv).getPlanner()).optimize(TableTestUtil.toRelNode(this.tEnv.sqlQuery("select id, name from PartT where part1 = 'A'")));
        FlinkRelMetadataQuery mq = FlinkRelMetadataQuery.reuseOrCreate((RelMetadataQuery)t1.getCluster().getMetadataQuery());
        Assert.assertEquals((double)200.0, (double)mq.getRowCount(t1), (double)0.0);
        Assert.assertNull((Object)mq.getDistinctRowCount(t1, ImmutableBitSet.of((int[])new int[]{0}), null));
        Assert.assertNull((Object)mq.getColumnNullCount(t1, 0));
        Assert.assertNull((Object)mq.getColumnInterval(t1, 0));
        Assert.assertNull((Object)mq.getDistinctRowCount(t1, ImmutableBitSet.of((int[])new int[]{1}), null));
        Assert.assertNull((Object)mq.getColumnNullCount(t1, 1));
    }

    private void createPartitionStats(String part1, int part2) throws Exception {
        this.createPartitionStats(part1, part2, 100L);
    }

    private void createPartitionStats(String part1, int part2, long rowCount) throws Exception {
        ObjectPath path = ObjectPath.fromString((String)"default_database.PartT");
        LinkedHashMap<String, String> partSpecMap = new LinkedHashMap<String, String>();
        partSpecMap.put("part1", part1);
        partSpecMap.put("part2", String.valueOf(part2));
        CatalogPartitionSpec partSpec = new CatalogPartitionSpec(partSpecMap);
        this.catalog.createPartition(path, partSpec, (CatalogPartition)new CatalogPartitionImpl(new HashMap(), ""), true);
        this.catalog.alterPartitionStatistics(path, partSpec, new CatalogTableStatistics(rowCount, 10, 1000L, 2000L), true);
    }

    private void createPartitionColumnStats(String part1, int part2) throws Exception {
        this.createPartitionColumnStats(part1, part2, false);
    }

    private void createPartitionColumnStats(String part1, int part2, boolean unknown) throws Exception {
        ObjectPath path = ObjectPath.fromString((String)"default_database.PartT");
        LinkedHashMap<String, String> partSpecMap = new LinkedHashMap<String, String>();
        partSpecMap.put("part1", part1);
        partSpecMap.put("part2", String.valueOf(part2));
        CatalogPartitionSpec partSpec = new CatalogPartitionSpec(partSpecMap);
        CatalogColumnStatisticsDataLong longColStats = new CatalogColumnStatisticsDataLong(Long.valueOf(-123L), Long.valueOf(763322L), Long.valueOf(23L), Long.valueOf(77L));
        CatalogColumnStatisticsDataString stringColStats = new CatalogColumnStatisticsDataString(Long.valueOf(152L), Double.valueOf(43.5), Long.valueOf(20L), Long.valueOf(0L));
        HashMap<String, Object> colStatsMap = new HashMap<String, Object>();
        colStatsMap.put("id", unknown ? new CatalogColumnStatisticsDataLong(null, null, null, null) : longColStats);
        colStatsMap.put("name", unknown ? new CatalogColumnStatisticsDataString(null, null, null, null) : stringColStats);
        this.catalog.alterPartitionColumnStatistics(path, partSpec, new CatalogColumnStatistics(colStatsMap), true);
    }

    private CatalogColumnStatistics createColumnStats() {
        CatalogColumnStatisticsDataBoolean booleanColStats = new CatalogColumnStatisticsDataBoolean(Long.valueOf(55L), Long.valueOf(45L), Long.valueOf(5L));
        CatalogColumnStatisticsDataLong longColStats = new CatalogColumnStatisticsDataLong(Long.valueOf(-123L), Long.valueOf(763322L), Long.valueOf(23L), Long.valueOf(77L));
        CatalogColumnStatisticsDataString stringColStats = new CatalogColumnStatisticsDataString(Long.valueOf(152L), Double.valueOf(43.5), Long.valueOf(20L), Long.valueOf(0L));
        CatalogColumnStatisticsDataDate dateColStats = new CatalogColumnStatisticsDataDate(new org.apache.flink.table.catalog.stats.Date(71L), new org.apache.flink.table.catalog.stats.Date(17923L), Long.valueOf(100L), Long.valueOf(0L));
        CatalogColumnStatisticsDataDouble doubleColStats = new CatalogColumnStatisticsDataDouble(Double.valueOf(-123.35), Double.valueOf(7633.22), Long.valueOf(73L), Long.valueOf(27L));
        HashMap<String, Object> colStatsMap = new HashMap<String, Object>(6);
        colStatsMap.put("b1", booleanColStats);
        colStatsMap.put("l2", longColStats);
        colStatsMap.put("s3", stringColStats);
        colStatsMap.put("d4", dateColStats);
        colStatsMap.put("dd5", doubleColStats);
        return new CatalogColumnStatistics(colStatsMap);
    }

    private void assertStatistics(TableEnvironment tEnv, String tableName) {
        RelNode t1 = TableTestUtil.toRelNode(tEnv.sqlQuery("select * from " + tableName));
        FlinkRelMetadataQuery mq = FlinkRelMetadataQuery.reuseOrCreate((RelMetadataQuery)t1.getCluster().getMetadataQuery());
        Assert.assertEquals((double)100.0, (double)mq.getRowCount(t1), (double)0.0);
        this.assertColumnStatistics(t1, mq);
    }

    private void assertColumnStatistics(RelNode rel, FlinkRelMetadataQuery mq) {
        Assert.assertEquals(Arrays.asList(1.0, 8.0, 43.5, 12.0, 8.0), (Object)mq.getAverageColumnSizes(rel));
        Assert.assertEquals((double)2.0, (double)mq.getDistinctRowCount(rel, ImmutableBitSet.of((int[])new int[]{0}), null), (double)0.0);
        Assert.assertEquals((double)5.0, (double)mq.getColumnNullCount(rel, 0), (double)0.0);
        Assert.assertNull((Object)mq.getColumnInterval(rel, 0));
        Assert.assertEquals((double)23.0, (double)mq.getDistinctRowCount(rel, ImmutableBitSet.of((int[])new int[]{1}), null), (double)0.0);
        Assert.assertEquals((double)77.0, (double)mq.getColumnNullCount(rel, 1), (double)0.0);
        Assert.assertEquals((Object)ValueInterval$.MODULE$.apply((Object)BigDecimal.valueOf(-123L), (Object)BigDecimal.valueOf(763322L), true, true), (Object)mq.getColumnInterval(rel, 1));
        Assert.assertEquals((double)20.0, (double)mq.getDistinctRowCount(rel, ImmutableBitSet.of((int[])new int[]{2}), null), (double)0.0);
        Assert.assertEquals((double)0.0, (double)mq.getColumnNullCount(rel, 2), (double)0.0);
        Assert.assertNull((Object)mq.getColumnInterval(rel, 2));
        Assert.assertEquals((double)100.0, (double)mq.getDistinctRowCount(rel, ImmutableBitSet.of((int[])new int[]{3}), null), (double)0.0);
        Assert.assertEquals((double)0.0, (double)mq.getColumnNullCount(rel, 3), (double)0.0);
        Assert.assertEquals((Object)ValueInterval$.MODULE$.apply((Object)Date.valueOf(DateTimeUtils.unixDateToString((int)71)), (Object)Date.valueOf(DateTimeUtils.unixDateToString((int)17923)), true, true), (Object)mq.getColumnInterval(rel, 3));
        Assert.assertEquals((double)73.0, (double)mq.getDistinctRowCount(rel, ImmutableBitSet.of((int[])new int[]{4}), null), (double)0.0);
        Assert.assertEquals((double)27.0, (double)mq.getColumnNullCount(rel, 4), (double)0.0);
        Assert.assertEquals((Object)ValueInterval$.MODULE$.apply((Object)BigDecimal.valueOf(-123.35), (Object)BigDecimal.valueOf(7633.22), true, true), (Object)mq.getColumnInterval(rel, 4));
    }

    private void alterTableStatisticsWithUnknownRowCount(Catalog catalog, String tableName) throws TableNotExistException, TablePartitionedException {
        catalog.alterTableStatistics(new ObjectPath(this.databaseName, tableName), new CatalogTableStatistics(CatalogTableStatistics.UNKNOWN.getRowCount(), 1, 10000L, 200000L), true);
        catalog.alterTableColumnStatistics(new ObjectPath(this.databaseName, tableName), this.createColumnStats(), true);
    }

    private void assertTableStatisticsWithUnknownRowCount(TableEnvironment tEnv, String tableName) {
        RelNode t1 = TableTestUtil.toRelNode(tEnv.sqlQuery("select * from " + tableName));
        FlinkRelMetadataQuery mq = FlinkRelMetadataQuery.reuseOrCreate((RelMetadataQuery)t1.getCluster().getMetadataQuery());
        Assert.assertEquals((double)1.0E8, (double)mq.getRowCount(t1), (double)0.0);
        this.assertColumnStatistics(t1, mq);
    }
}

