/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.catalog;

import java.io.File;
import java.net.URLClassLoader;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.table.api.EnvironmentSettings;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.api.bridge.java.StreamTableEnvironment;
import org.apache.flink.table.catalog.GenericInMemoryCatalog;
import org.apache.flink.testutils.ClassLoaderUtils;
import org.apache.flink.util.TemporaryClassLoaderContext;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class CatalogITCase {
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();

    @Test
    public void testCreateCatalog() {
        String name = "c1";
        TableEnvironment tableEnv = this.getTableEnvironment();
        String ddl = String.format("create catalog %s with('type'='%s')", name, "generic_in_memory");
        tableEnv.executeSql(ddl);
        Assert.assertTrue((boolean)tableEnv.getCatalog(name).isPresent());
        Assert.assertTrue((boolean)(tableEnv.getCatalog(name).get() instanceof GenericInMemoryCatalog));
    }

    @Test
    public void testDropCatalog() {
        String name = "c1";
        TableEnvironment tableEnv = this.getTableEnvironment();
        String ddl = String.format("create catalog %s with('type'='%s')", name, "generic_in_memory");
        tableEnv.executeSql(ddl);
        Assert.assertTrue((boolean)tableEnv.getCatalog(name).isPresent());
        ddl = String.format("drop catalog %s", name);
        tableEnv.executeSql(ddl);
        Assert.assertFalse((boolean)tableEnv.getCatalog(name).isPresent());
    }

    @Test
    public void testCreateLegacyCatalogFromUserClassLoader() throws Exception {
        String className = "UserCatalogFactory";
        URLClassLoader classLoader = ClassLoaderUtils.withRoot((File)this.temporaryFolder.newFolder()).addResource("META-INF/services/org.apache.flink.table.factories.TableFactory", "UserCatalogFactory").addClass("UserCatalogFactory", "import org.apache.flink.table.catalog.GenericInMemoryCatalog;\nimport org.apache.flink.table.factories.CatalogFactory;\nimport java.util.Collections;\nimport org.apache.flink.table.catalog.Catalog;\nimport java.util.HashMap;\nimport java.util.List;\nimport java.util.Map;\n\tpublic class UserCatalogFactory implements CatalogFactory {\n\t\t@Override\n\t\tpublic Catalog createCatalog(\n\t\t\t\tString name,\n\t\t\t\tMap<String, String> properties) {\n\t\t\treturn new GenericInMemoryCatalog(name);\n\t\t}\n\n\t\t@Override\n\t\tpublic Map<String, String> requiredContext() {\n\t\t\tHashMap<String, String> hashMap = new HashMap<>();\n\t\t\thashMap.put(\"type\", \"userCatalog\");\n\t\t\treturn hashMap;\n\t\t}\n\n\t\t@Override\n\t\tpublic List<String> supportedProperties() {\n\t\t\treturn Collections.emptyList();\n\t\t}\n\t}").build();
        try (TemporaryClassLoaderContext context = TemporaryClassLoaderContext.of((ClassLoader)classLoader);){
            TableEnvironment tableEnvironment = this.getTableEnvironment();
            tableEnvironment.executeSql("CREATE CATALOG cat WITH ('type'='userCatalog')");
            Assert.assertTrue((boolean)tableEnvironment.getCatalog("cat").isPresent());
        }
    }

    @Test
    public void testCreateCatalogFromUserClassLoader() throws Exception {
        String className = "UserCatalogFactory";
        URLClassLoader classLoader = ClassLoaderUtils.withRoot((File)this.temporaryFolder.newFolder()).addResource("META-INF/services/org.apache.flink.table.factories.Factory", "UserCatalogFactory").addClass("UserCatalogFactory", "import org.apache.flink.configuration.ConfigOption;\nimport org.apache.flink.table.catalog.Catalog;\nimport org.apache.flink.table.catalog.GenericInMemoryCatalog;\nimport org.apache.flink.table.factories.CatalogFactory;\n\nimport java.util.Collections;\nimport java.util.Set;\n\npublic class UserCatalogFactory implements CatalogFactory {\n    @Override\n    public Catalog createCatalog(Context context) {\n        return new GenericInMemoryCatalog(context.getName());\n    }\n\n    @Override\n    public String factoryIdentifier() {\n        return \"userCatalog\";\n    }\n\n    @Override\n    public Set<ConfigOption<?>> requiredOptions() {\n        return Collections.emptySet();\n    }\n\n    @Override\n    public Set<ConfigOption<?>> optionalOptions() {\n        return Collections.emptySet();\n    }\n}").build();
        try (TemporaryClassLoaderContext context = TemporaryClassLoaderContext.of((ClassLoader)classLoader);){
            TableEnvironment tableEnvironment = this.getTableEnvironment();
            tableEnvironment.executeSql("CREATE CATALOG cat WITH ('type'='userCatalog')");
            Assert.assertTrue((boolean)tableEnvironment.getCatalog("cat").isPresent());
        }
    }

    private TableEnvironment getTableEnvironment() {
        EnvironmentSettings settings = EnvironmentSettings.newInstance().inStreamingMode().build();
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        return StreamTableEnvironment.create((StreamExecutionEnvironment)env, (EnvironmentSettings)settings);
    }
}

