/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.api.internal;

import java.io.IOException;
import org.apache.flink.table.api.EnvironmentSettings;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.api.internal.StatementSetImpl;
import org.apache.flink.table.api.internal.TableEnvironmentInternal;
import org.apache.flink.table.planner.utils.TableTestUtil;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class StatementSetImplTest {
    TableEnvironmentInternal tableEnv;

    @Before
    public void setup() {
        EnvironmentSettings settings = EnvironmentSettings.newInstance().useBlinkPlanner().inStreamingMode().build();
        this.tableEnv = (TableEnvironmentInternal)TableEnvironment.create((EnvironmentSettings)settings);
    }

    @Test
    public void testGetJsonPlan() throws IOException {
        String srcTableDdl = "CREATE TABLE MyTable (\n  a bigint,\n  b int,\n  c varchar\n) with (\n  'connector' = 'values',\n  'bounded' = 'false')";
        this.tableEnv.executeSql(srcTableDdl);
        String sinkTableDdl = "CREATE TABLE MySink (\n  a bigint,\n  b int,\n  c varchar\n) with (\n  'connector' = 'values',\n  'table-sink-class' = 'DEFAULT')";
        this.tableEnv.executeSql(sinkTableDdl);
        StatementSetImpl stmtSet = (StatementSetImpl)this.tableEnv.createStatementSet();
        stmtSet.addInsertSql("INSERT INTO MySink SELECT * FROM MyTable");
        String jsonPlan = stmtSet.getJsonPlan();
        String actual = TableTestUtil.readFromResource("/jsonplan/testGetJsonPlan.out");
        Assert.assertEquals((Object)TableTestUtil.replaceExecNodeId(TableTestUtil.replaceFlinkVersion(TableTestUtil.getFormattedJson(jsonPlan))), (Object)TableTestUtil.replaceExecNodeId(TableTestUtil.getFormattedJson(actual)));
    }
}

