/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.api;

import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.apache.flink.api.common.JobStatus;
import org.apache.flink.core.execution.JobClient;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.EnvironmentSettings;
import org.apache.flink.table.api.ResultKind;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.api.TableITCase$;
import org.apache.flink.table.api.TableResult;
import org.apache.flink.table.api.bridge.java.StreamTableEnvironment;
import org.apache.flink.table.api.internal.TableEnvironmentImpl;
import org.apache.flink.table.catalog.Column;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.planner.utils.TestTableSourceSinks$;
import org.apache.flink.table.types.DataType;
import org.apache.flink.types.Row;
import org.apache.flink.types.RowKind;
import org.apache.flink.util.CloseableIterator;
import org.apache.flink.util.CollectionUtil;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import scala.None$;
import scala.Predef$;
import scala.Some;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@RunWith(value=Parameterized.class)
@ScalaSignature(bytes="\u0006\u0001\u0005\u001dd\u0001B\u0001\u0003\u00015\u00111\u0002V1cY\u0016LEkQ1tK*\u00111\u0001B\u0001\u0004CBL'BA\u0003\u0007\u0003\u0015!\u0018M\u00197f\u0015\t9\u0001\"A\u0003gY&t7N\u0003\u0002\n\u0015\u00051\u0011\r]1dQ\u0016T\u0011aC\u0001\u0004_J<7\u0001A\n\u0003\u00019\u0001\"a\u0004\n\u000e\u0003AQ!!\u0005\u0004\u0002\tU$\u0018\u000e\\\u0005\u0003'A\u0011!\u0002V3ti2{wmZ3s\u0011!)\u0002A!A!\u0002\u00131\u0012\u0001\u0004;bE2,WI\u001c<OC6,\u0007CA\f\u001e\u001d\tA2$D\u0001\u001a\u0015\u0005Q\u0012!B:dC2\f\u0017B\u0001\u000f\u001a\u0003\u0019\u0001&/\u001a3fM&\u0011ad\b\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005qI\u0002\u0002C\u0011\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0012\u0002\u0017%\u001c8\u000b\u001e:fC6Lgn\u001a\t\u00031\rJ!\u0001J\r\u0003\u000f\t{w\u000e\\3b]\")a\u0005\u0001C\u0001O\u00051A(\u001b8jiz\"2\u0001\u000b\u0016,!\tI\u0003!D\u0001\u0003\u0011\u0015)R\u00051\u0001\u0017\u0011\u0015\tS\u00051\u0001#\u0011\u001di\u0003A1A\u0005\u00029\n\u0011#\u001a=qK\u000e$X\rZ#yG\u0016\u0004H/[8o+\u0005y\u0003C\u0001\u00196\u001b\u0005\t$B\u0001\u001a4\u0003\u0015\u0011X\u000f\\3t\u0015\t!$\"A\u0003kk:LG/\u0003\u00027c\t\tR\t\u001f9fGR,G-\u0012=dKB$\u0018n\u001c8\t\ra\u0002\u0001\u0015!\u00030\u0003I)\u0007\u0010]3di\u0016$W\t_2faRLwN\u001c\u0011\t\u000bi\u0002A\u0011\u0001\u0018\u0002\rQD'o\\<oQ\tID\b\u0005\u0002>}5\t1'\u0003\u0002@g\t!!+\u001e7f\u0011\u001d\t\u0005A1A\u0005\n\t\u000b1b\u0018;f[B4u\u000e\u001c3feV\t1\t\u0005\u00021\t&\u0011Q)\r\u0002\u0010)\u0016l\u0007o\u001c:bef4u\u000e\u001c3fe\"1q\t\u0001Q\u0001\n\r\u000bAb\u0018;f[B4u\u000e\u001c3fe\u0002BQ!\u0013\u0001\u0005\u0002\t\u000b!\u0002^3na\u001a{G\u000eZ3sQ\tAE\bC\u0005M\u0001\u0001\u0007\t\u0019!C\u0001\u001b\u0006!A/\u00128w+\u0005q\u0005CA\u0015P\u0013\t\u0001&A\u0001\tUC\ndW-\u00128wSJ|g.\\3oi\"I!\u000b\u0001a\u0001\u0002\u0004%\taU\u0001\ti\u0016sgo\u0018\u0013fcR\u0011Ak\u0016\t\u00031UK!AV\r\u0003\tUs\u0017\u000e\u001e\u0005\b1F\u000b\t\u00111\u0001O\u0003\rAH%\r\u0005\u00075\u0002\u0001\u000b\u0015\u0002(\u0002\u000bQ,eN\u001e\u0011\t\u000fq\u0003!\u0019!C\u0005;\u0006A1/\u001a;uS:<7/F\u0001_!\tIs,\u0003\u0002a\u0005\t\u0019RI\u001c<je>tW.\u001a8u'\u0016$H/\u001b8hg\"1!\r\u0001Q\u0001\ny\u000b\u0011b]3ui&twm\u001d\u0011\t\u000b\u0011\u0004A\u0011A3\u0002\u000bM,G/\u001e9\u0015\u0003QC#aY4\u0011\u0005uB\u0017BA54\u0005\u0019\u0011UMZ8sK\")1\u000e\u0001C\u0001K\u0006YA/Z:u\u000bb,7-\u001e;fQ\tQW\u000e\u0005\u0002>]&\u0011qn\r\u0002\u0005)\u0016\u001cH\u000fC\u0003r\u0001\u0011\u0005Q-\u0001\u000buKN$8i\u001c7mK\u000e$x+\u001b;i\u00072|7/\u001a\u0015\u0003a6DQ\u0001\u001e\u0001\u0005\u0002\u0015\fA\u0004^3ti\u0016CXmY;uK^KG\u000f[+qI\u0006$Xm\u00115b]\u001e,7\u000f\u000b\u0002t[\"\"\u0001a^?\u007f!\tA80D\u0001z\u0015\tQ8'\u0001\u0004sk:tWM]\u0005\u0003yf\u0014qAU;o/&$\b.A\u0003wC2,XmI\u0001\u0000!\u0011\t\t!a\u0002\u000e\u0005\u0005\r!bAA\u0003g\u00059!/\u001e8oKJ\u001c\u0018\u0002BA\u0005\u0003\u0007\u0011Q\u0002U1sC6,G/\u001a:ju\u0016$waBA\u0007\u0005!\u0005\u0011qB\u0001\f)\u0006\u0014G.Z%U\u0007\u0006\u001cX\rE\u0002*\u0003#1a!\u0001\u0002\t\u0002\u0005M1\u0003BA\t\u0003+\u00012\u0001GA\f\u0013\r\tI\"\u0007\u0002\u0007\u0003:L(+\u001a4\t\u000f\u0019\n\t\u0002\"\u0001\u0002\u001eQ\u0011\u0011q\u0002\u0005\t\u0003C\t\t\u0002\"\u0001\u0002$\u0005Q\u0001/\u0019:b[\u0016$XM]:\u0015\u0005\u0005\u0015\u0002CBA\u0014\u0003_\t\u0019$\u0004\u0002\u0002*)\u0019\u0011#a\u000b\u000b\u0005\u00055\u0012\u0001\u00026bm\u0006LA!!\r\u0002*\tQ1i\u001c7mK\u000e$\u0018n\u001c81\t\u0005U\u0012q\b\t\u00061\u0005]\u00121H\u0005\u0004\u0003sI\"!B!se\u0006L\b\u0003BA\u001f\u0003\u007fa\u0001\u0001\u0002\u0007\u0002B\u0005}\u0011\u0011!A\u0001\u0006\u0003\t\u0019EA\u0002`IE\nB!!\u0012\u0002LA\u0019\u0001$a\u0012\n\u0007\u0005%\u0013DA\u0004O_RD\u0017N\\4\u0011\u0007a\ti%C\u0002\u0002Pe\u00111!\u00118zQ!\ty\"a\u0015\u0002b\u0005\r\u0004\u0003BA+\u00037rA!!\u0001\u0002X%!\u0011\u0011LA\u0002\u00035\u0001\u0016M]1nKR,'/\u001b>fI&!\u0011QLA0\u0005)\u0001\u0016M]1nKR,'o\u001d\u0006\u0005\u00033\n\u0019!\u0001\u0003oC6,\u0017EAA3\u0003AY\b' \u001ejgN#(/Z1n{m\fT\u0010")
public class TableITCase
extends TestLogger {
    private final String tableEnvName;
    private final boolean isStreaming;
    private final ExpectedException expectedException;
    private final TemporaryFolder _tempFolder;
    private TableEnvironment tEnv;
    private final EnvironmentSettings settings;

    @Parameterized.Parameters(name="{0}:isStream={1}")
    public static Collection<Object> parameters() {
        return TableITCase$.MODULE$.parameters();
    }

    public ExpectedException expectedException() {
        return this.expectedException;
    }

    @Rule
    public ExpectedException thrown() {
        return this.expectedException();
    }

    private TemporaryFolder _tempFolder() {
        return this._tempFolder;
    }

    @Rule
    public TemporaryFolder tempFolder() {
        return this._tempFolder();
    }

    public TableEnvironment tEnv() {
        return this.tEnv;
    }

    public void tEnv_$eq(TableEnvironment x$1) {
        this.tEnv = x$1;
    }

    private EnvironmentSettings settings() {
        return this.settings;
    }

    @Before
    public void setup() {
        block4: {
            block3: {
                String string;
                block2: {
                    string = this.tableEnvName;
                    if (!"TableEnvironment".equals(string)) break block2;
                    this.tEnv_$eq((TableEnvironment)TableEnvironmentImpl.create((EnvironmentSettings)this.settings()));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block3;
                }
                if (!"StreamTableEnvironment".equals(string)) break block4;
                this.tEnv_$eq((TableEnvironment)StreamTableEnvironment.create((StreamExecutionEnvironment)StreamExecutionEnvironment.getExecutionEnvironment(), (EnvironmentSettings)this.settings()));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            TestTableSourceSinks$.MODULE$.createPersonCsvTemporaryTable(this.tEnv(), "MyTable");
            return;
        }
        throw new UnsupportedOperationException(new StringBuilder().append((Object)"unsupported tableEnvName: ").append((Object)this.tableEnvName).toString());
    }

    @Test
    public void testExecute() {
        String query = new StringOps(Predef$.MODULE$.augmentString("\n        |select id, concat(concat(`first`, ' '), `last`) as `full name`\n        |from MyTable where mod(id, 2) = 0\n      ")).stripMargin();
        Table table = this.tEnv().sqlQuery(query);
        TableResult tableResult = table.execute();
        Assert.assertTrue((boolean)tableResult.getJobClient().isPresent());
        Assert.assertEquals((Object)ResultKind.SUCCESS_WITH_CONTENT, (Object)tableResult.getResultKind());
        Assert.assertEquals((Object)ResolvedSchema.of((Column[])new Column[]{Column.physical((String)"id", (DataType)DataTypes.INT()), Column.physical((String)"full name", (DataType)DataTypes.STRING())}), (Object)tableResult.getResolvedSchema());
        List<Object> expected = Arrays.asList((Object[])new Row[]{Row.of((Object[])new Object[]{2, "Bob Taylor"}), Row.of((Object[])new Object[]{4, "Peter Smith"}), Row.of((Object[])new Object[]{6, "Sally Miller"}), Row.of((Object[])new Object[]{8, "Kelly Williams"})});
        tableResult.await();
        CloseableIterator it = tableResult.collect();
        List actual = CollectionUtil.iteratorToList((Iterator)it);
        it.close();
        actual.sort(new Comparator<Row>(this){

            public int compare(Row o1, Row o2) {
                return Predef$.MODULE$.int2Integer(BoxesRunTime.unboxToInt((Object)o1.getField(0))).compareTo(Predef$.MODULE$.int2Integer(BoxesRunTime.unboxToInt((Object)o2.getField(0))));
            }
        });
        Assert.assertEquals(expected, (Object)actual);
    }

    @Test
    public void testCollectWithClose() {
        Some jobStatus;
        Some some;
        String query = new StringOps(Predef$.MODULE$.augmentString("\n        |select id, concat(concat(`first`, ' '), `last`) as `full name`\n        |from MyTable where mod(id, 2) = 0\n      ")).stripMargin();
        Table table = this.tEnv().sqlQuery(query);
        TableResult tableResult = table.execute();
        Assert.assertTrue((boolean)tableResult.getJobClient().isPresent());
        Assert.assertEquals((Object)ResultKind.SUCCESS_WITH_CONTENT, (Object)tableResult.getResultKind());
        CloseableIterator it = tableResult.collect();
        it.close();
        try {
            some = new Some(((JobClient)tableResult.getJobClient().get()).getJobStatus().get());
        }
        catch (Throwable throwable) {
            some = jobStatus = None$.MODULE$;
        }
        if (jobStatus.isDefined()) {
            Assert.assertNotEquals((Object)JobStatus.RUNNING, (Object)jobStatus.get());
        }
    }

    @Test
    public void testExecuteWithUpdateChanges() {
        TableResult tableResult = this.tEnv().sqlQuery("select count(*) as c from MyTable").execute();
        Assert.assertTrue((boolean)tableResult.getJobClient().isPresent());
        Assert.assertEquals((Object)ResultKind.SUCCESS_WITH_CONTENT, (Object)tableResult.getResultKind());
        Assert.assertEquals((Object)ResolvedSchema.of((Column[])new Column[]{Column.physical((String)"c", (DataType)((DataType)DataTypes.BIGINT().notNull()))}), (Object)tableResult.getResolvedSchema());
        List<Object> expected = this.isStreaming ? Arrays.asList((Object[])new Row[]{Row.ofKind((RowKind)RowKind.INSERT, (Object[])new Object[]{1L}), Row.ofKind((RowKind)RowKind.UPDATE_BEFORE, (Object[])new Object[]{1L}), Row.ofKind((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{2L}), Row.ofKind((RowKind)RowKind.UPDATE_BEFORE, (Object[])new Object[]{2L}), Row.ofKind((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{3L}), Row.ofKind((RowKind)RowKind.UPDATE_BEFORE, (Object[])new Object[]{3L}), Row.ofKind((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{4L}), Row.ofKind((RowKind)RowKind.UPDATE_BEFORE, (Object[])new Object[]{4L}), Row.ofKind((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{5L}), Row.ofKind((RowKind)RowKind.UPDATE_BEFORE, (Object[])new Object[]{5L}), Row.ofKind((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{6L}), Row.ofKind((RowKind)RowKind.UPDATE_BEFORE, (Object[])new Object[]{6L}), Row.ofKind((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{7L}), Row.ofKind((RowKind)RowKind.UPDATE_BEFORE, (Object[])new Object[]{7L}), Row.ofKind((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{8L})}) : Arrays.asList((Object[])new Row[]{Row.of((Object[])new Object[]{8L})});
        List actual = CollectionUtil.iteratorToList((Iterator)tableResult.collect());
        Assert.assertEquals(expected, (Object)actual);
    }

    public TableITCase(String tableEnvName, boolean isStreaming) {
        this.tableEnvName = tableEnvName;
        this.isStreaming = isStreaming;
        this.expectedException = ExpectedException.none();
        this._tempFolder = new TemporaryFolder();
        this.settings = isStreaming ? EnvironmentSettings.newInstance().inStreamingMode().build() : EnvironmentSettings.newInstance().inBatchMode().build();
    }
}

