/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.api;

import java.io.File;
import java.io.FileFilter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Optional;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.RuntimeExecutionMode;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.api.scala.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ExecutionOptions;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.functions.sink.SinkFunction;
import org.apache.flink.streaming.api.scala.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.scala.StreamExecutionEnvironment$;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.EnvironmentSettings;
import org.apache.flink.table.api.ExplainDetail;
import org.apache.flink.table.api.PlannerType;
import org.apache.flink.table.api.ResultKind;
import org.apache.flink.table.api.StatementSet;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.api.TableEnvironmentITCase$;
import org.apache.flink.table.api.TableResult;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.api.Types;
import org.apache.flink.table.api.bridge.java.StreamTableEnvironment;
import org.apache.flink.table.api.bridge.scala.StreamTableEnvironment$;
import org.apache.flink.table.api.config.TableConfigOptions;
import org.apache.flink.table.api.internal.TableEnvironmentImpl;
import org.apache.flink.table.api.internal.TableEnvironmentInternal;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.CatalogBaseTable;
import org.apache.flink.table.catalog.CatalogFunction;
import org.apache.flink.table.catalog.CatalogFunctionImpl;
import org.apache.flink.table.catalog.CatalogManager;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.CatalogTableImpl;
import org.apache.flink.table.catalog.CatalogView;
import org.apache.flink.table.catalog.CatalogViewImpl;
import org.apache.flink.table.catalog.Column;
import org.apache.flink.table.catalog.GenericInMemoryCatalog;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.ObjectPath;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.catalog.TemporaryOperationListener;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.functions.TestGenericUDF;
import org.apache.flink.table.planner.factories.utils.TestCollectionTableFactory$;
import org.apache.flink.table.planner.runtime.utils.TestingAppendSink;
import org.apache.flink.table.planner.utils.TableTestUtil$;
import org.apache.flink.table.planner.utils.TestTableSourceSinks$;
import org.apache.flink.table.planner.utils.TestTableSourceWithTime;
import org.apache.flink.table.planner.utils.TestTableSourceWithTime$;
import org.apache.flink.table.types.DataType;
import org.apache.flink.types.Row;
import org.apache.flink.types.RowKind;
import org.apache.flink.util.CloseableIterator;
import org.apache.flink.util.CollectionUtil;
import org.apache.flink.util.FileUtils;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Symbol;
import scala.Symbol$;
import scala.Tuple4;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.MutableList;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@RunWith(value=Parameterized.class)
@ScalaSignature(bytes="\u0006\u0001\r\u0005a\u0001B\u0001\u0003\u00015\u0011a\u0003V1cY\u0016,eN^5s_:lWM\u001c;J)\u000e\u000b7/\u001a\u0006\u0003\u0007\u0011\t1!\u00199j\u0015\t)a!A\u0003uC\ndWM\u0003\u0002\b\u0011\u0005)a\r\\5oW*\u0011\u0011BC\u0001\u0007CB\f7\r[3\u000b\u0003-\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\b\u0011\u0005=\u0011R\"\u0001\t\u000b\u0005E1\u0011\u0001B;uS2L!a\u0005\t\u0003\u0015Q+7\u000f\u001e'pO\u001e,'\u000f\u0003\u0005\u0016\u0001\t\u0005\t\u0015!\u0003\u0017\u00031!\u0018M\u00197f\u000b:4h*Y7f!\t9RD\u0004\u0002\u001975\t\u0011DC\u0001\u001b\u0003\u0015\u00198-\u00197b\u0013\ta\u0012$\u0001\u0004Qe\u0016$WMZ\u0005\u0003=}\u0011aa\u0015;sS:<'B\u0001\u000f\u001a\u0011!\t\u0003A!A!\u0002\u0013\u0011\u0013aC5t'R\u0014X-Y7j]\u001e\u0004\"\u0001G\u0012\n\u0005\u0011J\"a\u0002\"p_2,\u0017M\u001c\u0005\u0006M\u0001!\taJ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007!R3\u0006\u0005\u0002*\u00015\t!\u0001C\u0003\u0016K\u0001\u0007a\u0003C\u0003\"K\u0001\u0007!\u0005C\u0004.\u0001\t\u0007I\u0011\u0001\u0018\u0002#\u0015D\b/Z2uK\u0012,\u0005pY3qi&|g.F\u00010!\t\u0001T'D\u00012\u0015\t\u00114'A\u0003sk2,7O\u0003\u00025\u0015\u0005)!.\u001e8ji&\u0011a'\r\u0002\u0012\u000bb\u0004Xm\u0019;fI\u0016C8-\u001a9uS>t\u0007B\u0002\u001d\u0001A\u0003%q&\u0001\nfqB,7\r^3e\u000bb\u001cW\r\u001d;j_:\u0004\u0003\"\u0002\u001e\u0001\t\u0003q\u0013A\u0002;ie><h\u000e\u000b\u0002:yA\u0011QHP\u0007\u0002g%\u0011qh\r\u0002\u0005%VdW\rC\u0004B\u0001\t\u0007I\u0011\u0002\"\u0002\u0017}#X-\u001c9G_2$WM]\u000b\u0002\u0007B\u0011\u0001\u0007R\u0005\u0003\u000bF\u0012q\u0002V3na>\u0014\u0018M]=G_2$WM\u001d\u0005\u0007\u000f\u0002\u0001\u000b\u0011B\"\u0002\u0019}#X-\u001c9G_2$WM\u001d\u0011\t\u000b%\u0003A\u0011\u0001\"\u0002\u0015Q,W\u000e\u001d$pY\u0012,'\u000f\u000b\u0002Iy!IA\n\u0001a\u0001\u0002\u0004%\t!T\u0001\u0005i\u0016sg/F\u0001O!\tIs*\u0003\u0002Q\u0005\t\u0001B+\u00192mK\u0016sg/\u001b:p]6,g\u000e\u001e\u0005\n%\u0002\u0001\r\u00111A\u0005\u0002M\u000b\u0001\u0002^#om~#S-\u001d\u000b\u0003)^\u0003\"\u0001G+\n\u0005YK\"\u0001B+oSRDq\u0001W)\u0002\u0002\u0003\u0007a*A\u0002yIEBaA\u0017\u0001!B\u0013q\u0015!\u0002;F]Z\u0004\u0003b\u0002/\u0001\u0005\u0004%I!X\u0001\tg\u0016$H/\u001b8hgV\ta\f\u0005\u0002*?&\u0011\u0001M\u0001\u0002\u0014\u000b:4\u0018N]8o[\u0016tGoU3ui&twm\u001d\u0005\u0007E\u0002\u0001\u000b\u0011\u00020\u0002\u0013M,G\u000f^5oON\u0004\u0003\"\u00023\u0001\t\u0003)\u0017!B:fiV\u0004H#\u0001+)\u0005\r<\u0007CA\u001fi\u0013\tI7G\u0001\u0004CK\u001a|'/\u001a\u0005\u0006W\u0002!\t\u0001\\\u0001\u0013i\u0016\u001cHoU3u!2\fgN\\3s)f\u0004X-F\u0001UQ\tQg\u000e\u0005\u0002>_&\u0011\u0001o\r\u0002\u0005)\u0016\u001cH\u000fC\u0003s\u0001\u0011\u0005Q-\u0001\u000buKN$8+\u001a;Fq\u0016\u001cW\u000f^5p]6{G-\u001a\u0015\u0003c:DQ!\u001e\u0001\u0005\u0002\u0015\f\u0011\u0005^3ti\u0016CXmY;uKR;\u0018nY3Vg&twmU1nKR\u000b'\r\\3F]ZD#\u0001\u001e8\t\u000ba\u0004A\u0011A3\u0002?Q,7\u000f^#ya2\f\u0017N\\!oI\u0016CXmY;uKNKgn\u001a7f'&t7\u000e\u000b\u0002x]\")1\u0010\u0001C\u0001K\u0006\tC/Z:u\u000bb\u0004H.Y5o\u0003:$W\t_3dkR,W*\u001e7uSBdWmU5oW\"\u0012!P\u001c\u0005\u0006}\u0002!\t!Z\u0001\u0011i\u0016\u001cH/\u0012=qY\u0006Lg\u000eV<jG\u0016D#! 8\t\r\u0005\r\u0001\u0001\"\u0001f\u0003q!Xm\u001d;Tc2,\u0006\u000fZ1uK\u0006sG\rV8ECR\f7\u000b\u001e:fC6D3!!\u0001o\u0011\u0019\tI\u0001\u0001C\u0001K\u0006aB/Z:u)>$\u0015\r^1TiJ,\u0017-\\!oIN\u000bH.\u00169eCR,\u0007fAA\u0004]\"1\u0011q\u0002\u0001\u0005\u0002\u0015\f\u0001\u0005^3ti\u001a\u0013x.\u001c+p\t\u0006$\u0018m\u0015;sK\u0006l\u0017I\u001c3Tc2,\u0006\u000fZ1uK\"\u001a\u0011Q\u00028\t\r\u0005U\u0001\u0001\"\u0001f\u0003q!Xm\u001d;Fq\u0016\u001cW\u000f^3Tc2<\u0016\u000e\u001e5J]N,'\u000f^%oi>D3!a\u0005o\u0011\u0019\tY\u0002\u0001C\u0001K\u0006\tC/Z:u\u000bb,7-\u001e;f'Fdw+\u001b;i\u0013:\u001cXM\u001d;Pm\u0016\u0014xO]5uK\"\u001a\u0011\u0011\u00048\t\r\u0005\u0005\u0002\u0001\"\u0001f\u0003i!Xm\u001d;Fq\u0016\u001cW\u000f^3Tc2\fe\u000eZ*rYV\u0003H-\u0019;fQ\r\tyB\u001c\u0005\u0007\u0003O\u0001A\u0011A3\u0002;Q,7\u000f^#yK\u000e,H/Z*rY\u0006sG\rV8ECR\f7\u000b\u001e:fC6D3!!\no\u0011\u0019\ti\u0003\u0001C\u0001K\u0006\tB/Z:u\u000bb,7-\u001e;f\u0013:\u001cXM\u001d;)\u0007\u0005-b\u000e\u0003\u0004\u00024\u0001!\t!Z\u0001\u001bi\u0016\u001cH/\u0012=fGV$X-\u00138tKJ$xJ^3soJLG/\u001a\u0015\u0004\u0003cq\u0007BBA\u001d\u0001\u0011\u0005Q-\u0001\tuKN$H+\u00192mK\u0012kEjU=oG\"\u001a\u0011q\u00078\t\r\u0005}\u0002\u0001\"\u0001f\u0003A!Xm\u001d;Ti\u0006$X-\\3oiN+G\u000fK\u0002\u0002>9Da!!\u0012\u0001\t\u0003)\u0017!\b;fgR\u001cF/\u0019;f[\u0016tGoU3u/&$\bn\u0014<fe^\u0014\u0018\u000e^3)\u0007\u0005\rc\u000e\u0003\u0004\u0002L\u0001!\t!Z\u0001'i\u0016\u001cHo\u0015;bi\u0016lWM\u001c;TKR<\u0016\u000e\u001e5TC6,7+\u001b8l)\u0006\u0014G.\u001a(b[\u0016\u001c\bfAA%]\"1\u0011\u0011\u000b\u0001\u0005\u0002\u0015\f\u0011\u0003^3ti\u0016CXmY;uKN+G.Z2uQ\r\tyE\u001c\u0005\u0007\u0003/\u0002A\u0011A3\u0002EQ,7\u000f^#yK\u000e,H/Z*fY\u0016\u001cGoV5uQV\u0003H-\u0019;f\u0007\"\fgnZ3tQ\r\t)F\u001c\u0005\u0007\u0003;\u0002A\u0011A3\u0002EQ,7\u000f^#yK\u000e,H/Z*fY\u0016\u001cGoV5uQRKW.Z!uiJL'-\u001e;fQ\r\tYF\u001c\u0005\u0007\u0003G\u0002A\u0011A3\u0002%Q,7\u000f^\"mK\u0006\u0014x\n]3sCRLwN\u001c\u0015\u0004\u0003Cr\u0007BBA5\u0001\u0011\u0005Q-\u0001\u0010uKN$H+Z7q_J\f'/_(qKJ\fG/[8o\u0019&\u001cH/\u001a8fe\"\u001a\u0011q\r8\t\u000f\u0005=\u0004\u0001\"\u0001\u0002r\u0005iq-\u001a;QKJ\u001cxN\u001c#bi\u0006,\"!a\u001d\u0011\r\u0005U\u0014QQAF\u001d\u0011\t9(!!\u000f\t\u0005e\u0014qP\u0007\u0003\u0003wR1!! \r\u0003\u0019a$o\\8u}%\t!$C\u0002\u0002\u0004f\tq\u0001]1dW\u0006<W-\u0003\u0003\u0002\b\u0006%%\u0001\u0002'jgRT1!a!\u001a!%A\u0012Q\u0012\f\u0002\u0012\u0006]e#C\u0002\u0002\u0010f\u0011a\u0001V;qY\u0016$\u0004c\u0001\r\u0002\u0014&\u0019\u0011QS\r\u0003\u0007%sG\u000fE\u0002\u0019\u00033K1!a'\u001a\u0005\u0019!u.\u001e2mK\"9\u0011q\u0014\u0001\u0005\n\u0005\u0005\u0016!E1tg\u0016\u0014HOR5sgR4\u0016\r\\;fgR\u0019A+a)\t\u000f\u0005\u0015\u0016Q\u0014a\u0001-\u0005Y1m\u001d<GS2,\u0007+\u0019;i\u0011\u001d\tI\u000b\u0001C\u0005\u0003W\u000b\u0001#Y:tKJ$H*Y:u-\u0006dW/Z:\u0015\u0007Q\u000bi\u000bC\u0004\u0002&\u0006\u001d\u0006\u0019\u0001\f\t\u000f\u0005E\u0006\u0001\"\u0003\u00024\u0006)r-\u001a;FqB,7\r^3e\u0019\u0006\u001cHOV1mk\u0016\u001cXCAA[!\u0015\t)(!\"\u0017\u0011\u001d\tI\f\u0001C\u0005\u0003w\u000bab\u00195fG.,U\u000e\u001d;z\r&dW\rF\u0002U\u0003{Cq!!*\u00028\u0002\u0007a\u0003C\u0004\u0002B\u0002!I!a1\u0002\u0015\u0011,G.\u001a;f\r&dW\rF\u0002U\u0003\u000bDq!a2\u0002@\u0002\u0007a#\u0001\u0003qCRD\u0007bBAf\u0001\u0011%\u0011QZ\u0001\u0013CN\u001cXM\u001d;GS2,gj\u001c;Fq&\u001cH\u000fF\u0002U\u0003\u001fDq!a2\u0002J\u0002\u0007a\u0003C\u0004\u0002T\u0002!I!!6\u0002-\rDWmY6J]N,'\u000f\u001e+bE2,'+Z:vYR$R\u0001VAl\u0003CD\u0001\"!7\u0002R\u0002\u0007\u00111\\\u0001\fi\u0006\u0014G.\u001a*fgVdG\u000fE\u0002*\u0003;L1!a8\u0003\u0005-!\u0016M\u00197f%\u0016\u001cX\u000f\u001c;\t\u0011\u0005\r\u0018\u0011\u001ba\u0001\u0003K\f!BZ5fY\u0012t\u0015-\\3t!\u0011A\u0012q\u001d\f\n\u0007\u0005%\u0018D\u0001\u0006=e\u0016\u0004X-\u0019;fIzBq!!<\u0001\t\u0013\ty/\u0001\u0005sK\u0006$g)\u001b7f)\u0011\t),!=\t\u000f\u0005\u0015\u00161\u001ea\u0001-\u00191\u0011Q\u001f\u0001\u0001\u0003o\u0014q\u0002T5ti\u0016tWM]\"bi\u0006dwnZ\n\u0007\u0003g\fIP!\u0002\u0011\t\u0005m(\u0011A\u0007\u0003\u0003{T1!a@\u0005\u0003\u001d\u0019\u0017\r^1m_\u001eLAAa\u0001\u0002~\n1r)\u001a8fe&\u001c\u0017J\\'f[>\u0014\u0018pQ1uC2|w\r\u0005\u0003\u0002|\n\u001d\u0011\u0002\u0002B\u0005\u0003{\u0014!\u0004V3na>\u0014\u0018M]=Pa\u0016\u0014\u0018\r^5p]2K7\u000f^3oKJD!B!\u0004\u0002t\n\u0005\t\u0015!\u0003\u0017\u0003\u0011q\u0017-\\3\t\u000f\u0019\n\u0019\u0010\"\u0001\u0003\u0012Q!!1\u0003B\f!\u0011\u0011)\"a=\u000e\u0003\u0001AqA!\u0004\u0003\u0010\u0001\u0007a\u0003\u0003\u0006\u0003\u001c\u0005M(\u0019!C\u0001\u0005;\tA\u0002^1cY\u0016\u001cu.\\7f]R,\u0012A\u0006\u0005\t\u0005C\t\u0019\u0010)A\u0005-\u0005iA/\u00192mK\u000e{W.\\3oi\u0002B!B!\n\u0002t\n\u0007I\u0011\u0001B\u000f\u0003-1WO\\2DYjt\u0015-\\3\t\u0011\t%\u00121\u001fQ\u0001\nY\tABZ;oG\u000ec'PT1nK\u0002B!B!\f\u0002t\u0002\u0007I\u0011\u0001B\u0018\u00031qW/\u001c+f[B$\u0016M\u00197f+\t\t\t\n\u0003\u0006\u00034\u0005M\b\u0019!C\u0001\u0005k\t\u0001C\\;n)\u0016l\u0007\u000fV1cY\u0016|F%Z9\u0015\u0007Q\u00139\u0004C\u0005Y\u0005c\t\t\u00111\u0001\u0002\u0012\"I!1HAzA\u0003&\u0011\u0011S\u0001\u000e]VlG+Z7q)\u0006\u0014G.\u001a\u0011\t\u0015\t}\u00121\u001fa\u0001\n\u0003\u0011y#A\u0006ok6$V-\u001c9Gk:\u001c\u0007B\u0003B\"\u0003g\u0004\r\u0011\"\u0001\u0003F\u0005ya.^7UK6\u0004h)\u001e8d?\u0012*\u0017\u000fF\u0002U\u0005\u000fB\u0011\u0002\u0017B!\u0003\u0003\u0005\r!!%\t\u0013\t-\u00131\u001fQ!\n\u0005E\u0015\u0001\u00048v[R+W\u000e\u001d$v]\u000e\u0004\u0003\u0002\u0003B(\u0003g$\tE!\u0015\u0002-=t7I]3bi\u0016$V-\u001c9pe\u0006\u0014\u0018\u0010V1cY\u0016$bAa\u0015\u0003Z\t\r\u0004\u0003BA~\u0005+JAAa\u0016\u0002~\n\u00012)\u0019;bY><')Y:f)\u0006\u0014G.\u001a\u0005\t\u00057\u0012i\u00051\u0001\u0003^\u0005IA/\u00192mKB\u000bG\u000f\u001b\t\u0005\u0003w\u0014y&\u0003\u0003\u0003b\u0005u(AC(cU\u0016\u001cG\u000fU1uQ\"9QA!\u0014A\u0002\tM\u0003\u0002\u0003B4\u0003g$\tE!\u001b\u0002)=tGI]8q)\u0016l\u0007o\u001c:bef$\u0016M\u00197f)\r!&1\u000e\u0005\t\u00057\u0012)\u00071\u0001\u0003^!A!qNAz\t\u0003\u0012\t(A\rp]\u000e\u0013X-\u0019;f)\u0016l\u0007o\u001c:bef4UO\\2uS>tGC\u0002B:\u0005s\u0012i\b\u0005\u0003\u0002|\nU\u0014\u0002\u0002B<\u0003{\u0014qbQ1uC2|wMR;oGRLwN\u001c\u0005\t\u0005w\u0012i\u00071\u0001\u0003^\u0005aa-\u001e8di&|g\u000eU1uQ\"A!q\u0010B7\u0001\u0004\u0011\u0019(\u0001\u0005gk:\u001cG/[8o\u0011!\u0011\u0019)a=\u0005B\t\u0015\u0015aF8o\tJ|\u0007\u000fV3na>\u0014\u0018M]=Gk:\u001cG/[8o)\r!&q\u0011\u0005\t\u0005w\u0012\t\t1\u0001\u0003^!:\u0001Aa#\u0003\u0018\ne\u0005\u0003\u0002BG\u0005'k!Aa$\u000b\u0007\tE5'\u0001\u0004sk:tWM]\u0005\u0005\u0005+\u0013yIA\u0004Sk:<\u0016\u000e\u001e5\u0002\u000bY\fG.^3$\u0005\tm\u0005\u0003\u0002BO\u0005Gk!Aa(\u000b\u0007\t\u00056'A\u0004sk:tWM]:\n\t\t\u0015&q\u0014\u0002\u000e!\u0006\u0014\u0018-\\3uKJL'0\u001a3\b\u000f\t%&\u0001#\u0001\u0003,\u00061B+\u00192mK\u0016sg/\u001b:p]6,g\u000e^%U\u0007\u0006\u001cX\rE\u0002*\u0005[3a!\u0001\u0002\t\u0002\t=6\u0003\u0002BW\u0005c\u00032\u0001\u0007BZ\u0013\r\u0011),\u0007\u0002\u0007\u0003:L(+\u001a4\t\u000f\u0019\u0012i\u000b\"\u0001\u0003:R\u0011!1\u0016\u0005\t\u0005{\u0013i\u000b\"\u0001\u0003@\u0006Q\u0001/\u0019:b[\u0016$XM]:\u0015\u0005\t\u0005\u0007C\u0002Bb\u0005\u0017\u0014y-\u0004\u0002\u0003F*\u0019\u0011Ca2\u000b\u0005\t%\u0017\u0001\u00026bm\u0006LAA!4\u0003F\nQ1i\u001c7mK\u000e$\u0018n\u001c81\t\tE'1\u001c\t\u00061\tM'q[\u0005\u0004\u0005+L\"!B!se\u0006L\b\u0003\u0002Bm\u00057d\u0001\u0001\u0002\u0007\u0003^\nm\u0016\u0011!A\u0001\u0006\u0003\u0011yNA\u0002`IE\nBA!9\u0003hB\u0019\u0001Da9\n\u0007\t\u0015\u0018DA\u0004O_RD\u0017N\\4\u0011\u0007a\u0011I/C\u0002\u0003lf\u00111!\u00118zQ!\u0011YLa<\u0003\u000e\tu\b\u0003\u0002By\u0005otAA!(\u0003t&!!Q\u001fBP\u00035\u0001\u0016M]1nKR,'/\u001b>fI&!!\u0011 B~\u0005)\u0001\u0016M]1nKR,'o\u001d\u0006\u0005\u0005k\u0014y*\t\u0002\u0003\u0000\u0006\u00012\u0010M?;SN\u001cFO]3b[vZ\u0018' ")
public class TableEnvironmentITCase
extends TestLogger {
    private final String tableEnvName;
    private final boolean isStreaming;
    private final ExpectedException expectedException;
    private final TemporaryFolder _tempFolder;
    private TableEnvironment tEnv;
    private final EnvironmentSettings settings;
    private static Symbol symbol$1 = Symbol$.MODULE$.apply("first");
    private static Symbol symbol$2 = Symbol$.MODULE$.apply("id");
    private static Symbol symbol$3 = Symbol$.MODULE$.apply("score");
    private static Symbol symbol$4 = Symbol$.MODULE$.apply("last");

    @Parameterized.Parameters(name="{0}:isStream={1}")
    public static Collection<Object> parameters() {
        return TableEnvironmentITCase$.MODULE$.parameters();
    }

    public ExpectedException expectedException() {
        return this.expectedException;
    }

    @Rule
    public ExpectedException thrown() {
        return this.expectedException();
    }

    private TemporaryFolder _tempFolder() {
        return this._tempFolder;
    }

    @Rule
    public TemporaryFolder tempFolder() {
        return this._tempFolder();
    }

    public TableEnvironment tEnv() {
        return this.tEnv;
    }

    public void tEnv_$eq(TableEnvironment x$1) {
        this.tEnv = x$1;
    }

    private EnvironmentSettings settings() {
        return this.settings;
    }

    @Before
    public void setup() {
        block4: {
            block3: {
                String string;
                block2: {
                    string = this.tableEnvName;
                    if (!"TableEnvironment".equals(string)) break block2;
                    this.tEnv_$eq((TableEnvironment)TableEnvironmentImpl.create((EnvironmentSettings)this.settings()));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block3;
                }
                if (!"StreamTableEnvironment".equals(string)) break block4;
                this.tEnv_$eq((TableEnvironment)StreamTableEnvironment.create((org.apache.flink.streaming.api.environment.StreamExecutionEnvironment)org.apache.flink.streaming.api.environment.StreamExecutionEnvironment.getExecutionEnvironment(), (EnvironmentSettings)this.settings()));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            TestTableSourceSinks$.MODULE$.createPersonCsvTemporaryTable(this.tEnv(), "MyTable");
            return;
        }
        throw new UnsupportedOperationException(new StringBuilder().append((Object)"unsupported tableEnvName: ").append((Object)this.tableEnvName).toString());
    }

    @Test
    public void testSetPlannerType() {
        this.tEnv().getConfig().getConfiguration().set(TableConfigOptions.TABLE_PLANNER, (Object)PlannerType.OLD);
        TestTableSourceSinks$.MODULE$.createCsvTemporarySinkTable(this.tEnv(), new TableSchema((String[])((Object[])new String[]{"first"}), (TypeInformation[])((Object[])new TypeInformation[]{org.apache.flink.api.common.typeinfo.Types.STRING})), "MySink1", TestTableSourceSinks$.MODULE$.createCsvTemporarySinkTable$default$4());
        this.thrown().expect(IllegalArgumentException.class);
        this.thrown().expectMessage("Mismatch between configured planner and actual planner. Currently, the 'table.planner' can only be set when instantiating the table environment. Subsequent changes are not supported. Please instantiate a new TableEnvironment if necessary.");
        this.tEnv().executeSql("insert into MySink1 select first from MyTable");
    }

    @Test
    public void testSetExecutionMode() {
        Configuration configuration = this.isStreaming ? this.tEnv().getConfig().getConfiguration().set(ExecutionOptions.RUNTIME_MODE, (Object)RuntimeExecutionMode.BATCH) : this.tEnv().getConfig().getConfiguration().set(ExecutionOptions.RUNTIME_MODE, (Object)RuntimeExecutionMode.STREAMING);
        this.thrown().expect(IllegalArgumentException.class);
        this.thrown().expectMessage("Mismatch between configured runtime mode and actual runtime mode. Currently, the 'execution.runtime-mode' can only be set when instantiating the table environment. Subsequent changes are not supported. Please instantiate a new TableEnvironment if necessary.");
        this.tEnv().explainSql("select first from MyTable", new ExplainDetail[0]);
    }

    @Test
    public void testExecuteTwiceUsingSameTableEnv() {
        String sink1Path = TestTableSourceSinks$.MODULE$.createCsvTemporarySinkTable(this.tEnv(), new TableSchema((String[])((Object[])new String[]{"first"}), (TypeInformation[])((Object[])new TypeInformation[]{org.apache.flink.api.common.typeinfo.Types.STRING})), "MySink1", TestTableSourceSinks$.MODULE$.createCsvTemporarySinkTable$default$4());
        String sink2Path = TestTableSourceSinks$.MODULE$.createCsvTemporarySinkTable(this.tEnv(), new TableSchema((String[])((Object[])new String[]{"first"}), (TypeInformation[])((Object[])new TypeInformation[]{org.apache.flink.api.common.typeinfo.Types.STRING})), "MySink2", TestTableSourceSinks$.MODULE$.createCsvTemporarySinkTable$default$4());
        this.checkEmptyFile(sink1Path);
        this.checkEmptyFile(sink2Path);
        Table table1 = this.tEnv().sqlQuery("select first from MyTable");
        this.tEnv().insertInto(table1, "MySink1", new String[0]);
        this.tEnv().execute("test1");
        this.assertFirstValues(sink1Path);
        this.checkEmptyFile(sink2Path);
        new File(sink1Path).delete();
        Assert.assertFalse((boolean)new File(sink1Path).exists());
        Table table2 = this.tEnv().sqlQuery("select last from MyTable");
        this.tEnv().insertInto(table2, "MySink2", new String[0]);
        this.tEnv().execute("test2");
        Assert.assertFalse((boolean)new File(sink1Path).exists());
        this.assertLastValues(sink2Path);
    }

    @Test
    public void testExplainAndExecuteSingleSink() {
        String sinkPath = TestTableSourceSinks$.MODULE$.createCsvTemporarySinkTable(this.tEnv(), new TableSchema((String[])((Object[])new String[]{"first"}), (TypeInformation[])((Object[])new TypeInformation[]{org.apache.flink.api.common.typeinfo.Types.STRING})), "MySink1", TestTableSourceSinks$.MODULE$.createCsvTemporarySinkTable$default$4());
        Table table1 = this.tEnv().sqlQuery("select first from MyTable");
        this.tEnv().insertInto(table1, "MySink1", new String[0]);
        this.tEnv().explain(false);
        this.tEnv().execute("test1");
        this.assertFirstValues(sinkPath);
    }

    @Test
    public void testExplainAndExecuteMultipleSink() {
        String sink1Path = TestTableSourceSinks$.MODULE$.createCsvTemporarySinkTable(this.tEnv(), new TableSchema((String[])((Object[])new String[]{"first"}), (TypeInformation[])((Object[])new TypeInformation[]{org.apache.flink.api.common.typeinfo.Types.STRING})), "MySink1", TestTableSourceSinks$.MODULE$.createCsvTemporarySinkTable$default$4());
        String sink2Path = TestTableSourceSinks$.MODULE$.createCsvTemporarySinkTable(this.tEnv(), new TableSchema((String[])((Object[])new String[]{"first"}), (TypeInformation[])((Object[])new TypeInformation[]{org.apache.flink.api.common.typeinfo.Types.STRING})), "MySink2", TestTableSourceSinks$.MODULE$.createCsvTemporarySinkTable$default$4());
        Table table1 = this.tEnv().sqlQuery("select first from MyTable");
        this.tEnv().insertInto(table1, "MySink1", new String[0]);
        Table table2 = this.tEnv().sqlQuery("select last from MyTable");
        this.tEnv().insertInto(table2, "MySink2", new String[0]);
        this.tEnv().explain(false);
        this.tEnv().execute("test1");
        this.assertFirstValues(sink1Path);
        this.assertLastValues(sink2Path);
    }

    @Test
    public void testExplainTwice() {
        String sink1Path = TestTableSourceSinks$.MODULE$.createCsvTemporarySinkTable(this.tEnv(), new TableSchema((String[])((Object[])new String[]{"first"}), (TypeInformation[])((Object[])new TypeInformation[]{org.apache.flink.api.common.typeinfo.Types.STRING})), "MySink1", TestTableSourceSinks$.MODULE$.createCsvTemporarySinkTable$default$4());
        String sink2Path = TestTableSourceSinks$.MODULE$.createCsvTemporarySinkTable(this.tEnv(), new TableSchema((String[])((Object[])new String[]{"first"}), (TypeInformation[])((Object[])new TypeInformation[]{org.apache.flink.api.common.typeinfo.Types.STRING})), "MySink2", TestTableSourceSinks$.MODULE$.createCsvTemporarySinkTable$default$4());
        Table table1 = this.tEnv().sqlQuery("select first from MyTable");
        this.tEnv().insertInto(table1, "MySink1", new String[0]);
        Table table2 = this.tEnv().sqlQuery("select last from MyTable");
        this.tEnv().insertInto(table2, "MySink2", new String[0]);
        String result1 = this.tEnv().explain(false);
        String result2 = this.tEnv().explain(false);
        Assert.assertEquals((Object)TableTestUtil$.MODULE$.replaceStageId(result1), (Object)TableTestUtil$.MODULE$.replaceStageId(result2));
    }

    @Test
    public void testSqlUpdateAndToDataStream() {
        if (this.tableEnvName.equals("StreamTableEnvironment")) {
            org.apache.flink.streaming.api.environment.StreamExecutionEnvironment streamEnv = org.apache.flink.streaming.api.environment.StreamExecutionEnvironment.getExecutionEnvironment();
            StreamTableEnvironment streamTableEnv = StreamTableEnvironment.create((org.apache.flink.streaming.api.environment.StreamExecutionEnvironment)streamEnv, (EnvironmentSettings)this.settings());
            TestTableSourceSinks$.MODULE$.createPersonCsvTemporaryTable((TableEnvironment)streamTableEnv, "MyTable");
            String sink1Path = TestTableSourceSinks$.MODULE$.createCsvTemporarySinkTable((TableEnvironment)streamTableEnv, new TableSchema((String[])((Object[])new String[]{"first"}), (TypeInformation[])((Object[])new TypeInformation[]{org.apache.flink.api.common.typeinfo.Types.STRING})), "MySink1", TestTableSourceSinks$.MODULE$.createCsvTemporarySinkTable$default$4());
            this.checkEmptyFile(sink1Path);
            streamTableEnv.sqlUpdate("insert into MySink1 select first from MyTable");
            Table table = streamTableEnv.sqlQuery("select last from MyTable where id > 0");
            DataStream resultSet = streamTableEnv.toAppendStream(table, Row.class);
            TestingAppendSink sink = new TestingAppendSink();
            resultSet.addSink((SinkFunction)sink);
            String explain2 = streamTableEnv.explain(false);
            Assert.assertEquals((Object)TableTestUtil$.MODULE$.replaceStageId(TableTestUtil$.MODULE$.readFromResource("/explain/testSqlUpdateAndToDataStream.out")), (Object)TableTestUtil$.MODULE$.replaceStageId(explain2));
            streamTableEnv.execute("test1");
            this.assertFirstValues(sink1Path);
            Assert.assertFalse((boolean)sink.isInitialized());
            this.deleteFile(sink1Path);
            streamEnv.execute("test2");
            Assert.assertEquals((Object)this.getExpectedLastValues().sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$));
            this.assertFileNotExist(sink1Path);
            return;
        }
    }

    @Test
    public void testToDataStreamAndSqlUpdate() {
        if (this.tableEnvName.equals("StreamTableEnvironment")) {
            org.apache.flink.streaming.api.environment.StreamExecutionEnvironment streamEnv = org.apache.flink.streaming.api.environment.StreamExecutionEnvironment.getExecutionEnvironment();
            StreamTableEnvironment streamTableEnv = StreamTableEnvironment.create((org.apache.flink.streaming.api.environment.StreamExecutionEnvironment)streamEnv, (EnvironmentSettings)this.settings());
            TestTableSourceSinks$.MODULE$.createPersonCsvTemporaryTable((TableEnvironment)streamTableEnv, "MyTable");
            String sink1Path = TestTableSourceSinks$.MODULE$.createCsvTemporarySinkTable((TableEnvironment)streamTableEnv, new TableSchema((String[])((Object[])new String[]{"first"}), (TypeInformation[])((Object[])new TypeInformation[]{org.apache.flink.api.common.typeinfo.Types.STRING})), "MySink1", TestTableSourceSinks$.MODULE$.createCsvTemporarySinkTable$default$4());
            this.checkEmptyFile(sink1Path);
            Table table = streamTableEnv.sqlQuery("select last from MyTable where id > 0");
            DataStream resultSet = streamTableEnv.toAppendStream(table, Row.class);
            TestingAppendSink sink = new TestingAppendSink();
            resultSet.addSink((SinkFunction)sink);
            streamTableEnv.sqlUpdate("insert into MySink1 select first from MyTable");
            String explain2 = streamTableEnv.explain(false);
            Assert.assertEquals((Object)TableTestUtil$.MODULE$.replaceStageId(TableTestUtil$.MODULE$.readFromResource("/explain/testSqlUpdateAndToDataStream.out")), (Object)TableTestUtil$.MODULE$.replaceStageId(explain2));
            streamEnv.execute("test2");
            this.checkEmptyFile(sink1Path);
            Assert.assertEquals((Object)this.getExpectedLastValues().sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$));
            streamTableEnv.execute("test1");
            this.assertFirstValues(sink1Path);
            Assert.assertEquals((Object)this.getExpectedLastValues().sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$));
            return;
        }
    }

    @Test
    public void testFromToDataStreamAndSqlUpdate() {
        if (this.tableEnvName.equals("StreamTableEnvironment")) {
            StreamExecutionEnvironment streamEnv = StreamExecutionEnvironment$.MODULE$.getExecutionEnvironment();
            org.apache.flink.table.api.bridge.scala.StreamTableEnvironment streamTableEnv = StreamTableEnvironment$.MODULE$.create(streamEnv, this.settings());
            Table t = org.apache.flink.table.api.bridge.scala.package$.MODULE$.dataStreamConversions(streamEnv.fromCollection(this.getPersonData(), (TypeInformation)new CaseClassTypeInfo<Tuple4<String, Object, Object, String>>(this){

                public /* synthetic */ TypeInformation[] protected$types($anon$2 x$1) {
                    return x$1.types;
                }

                public TypeSerializer<Tuple4<String, Object, Object, String>> createSerializer(ExecutionConfig executionConfig) {
                    TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                    RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anon$2 $outer;
                        private final ExecutionConfig executionConfig$1;
                        private final TypeSerializer[] fieldSerializers$1;

                        public final void apply(int i) {
                            this.apply$mcVI$sp(i);
                        }

                        public void apply$mcVI$sp(int i) {
                            this.fieldSerializers$1[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$1);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.executionConfig$1 = executionConfig$1;
                            this.fieldSerializers$1 = fieldSerializers$1;
                        }
                    });
                    ScalaCaseClassSerializer<Tuple4<String, Object, Object, String>> unused = new ScalaCaseClassSerializer<Tuple4<String, Object, Object, String>>(this, fieldSerializers){

                        public Tuple4<String, Object, Object, String> createInstance(Object[] fields) {
                            return new Tuple4((Object)((String)fields[0]), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[1])), (Object)BoxesRunTime.boxToDouble((double)BoxesRunTime.unboxToDouble((Object)fields[2])), (Object)((String)fields[3]));
                        }
                    };
                    return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
                }
            })).toTable(streamTableEnv, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$.MODULE$.symbol2FieldExpression(symbol$1), package$.MODULE$.symbol2FieldExpression(symbol$2), package$.MODULE$.symbol2FieldExpression(symbol$3), package$.MODULE$.symbol2FieldExpression(symbol$4)}));
            streamTableEnv.registerTable("MyTable", t);
            String sink1Path = TestTableSourceSinks$.MODULE$.createCsvTemporarySinkTable((TableEnvironment)streamTableEnv, new TableSchema((String[])((Object[])new String[]{"first"}), (TypeInformation[])((Object[])new TypeInformation[]{org.apache.flink.api.common.typeinfo.Types.STRING})), "MySink1", TestTableSourceSinks$.MODULE$.createCsvTemporarySinkTable$default$4());
            this.checkEmptyFile(sink1Path);
            Table table = streamTableEnv.sqlQuery("select last from MyTable where id > 0");
            org.apache.flink.streaming.api.scala.DataStream resultSet = streamTableEnv.toAppendStream(table, TypeExtractor.createTypeInfo(Row.class));
            TestingAppendSink sink = new TestingAppendSink();
            resultSet.addSink((SinkFunction)sink);
            streamTableEnv.sqlUpdate("insert into MySink1 select first from MyTable");
            String explain2 = streamTableEnv.explain(false);
            Assert.assertEquals((Object)TableTestUtil$.MODULE$.replaceStageId(TableTestUtil$.MODULE$.readFromResource("/explain/testFromToDataStreamAndSqlUpdate.out")), (Object)TableTestUtil$.MODULE$.replaceStageId(explain2));
            streamEnv.execute("test2");
            this.checkEmptyFile(sink1Path);
            Assert.assertEquals((Object)this.getExpectedLastValues().sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$));
            streamTableEnv.execute("test1");
            this.assertFirstValues(sink1Path);
            Assert.assertEquals((Object)this.getExpectedLastValues().sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$));
            return;
        }
    }

    @Test
    public void testExecuteSqlWithInsertInto() {
        String sinkPath = TestTableSourceSinks$.MODULE$.createCsvTemporarySinkTable(this.tEnv(), new TableSchema((String[])((Object[])new String[]{"first"}), (TypeInformation[])((Object[])new TypeInformation[]{org.apache.flink.api.common.typeinfo.Types.STRING})), "MySink1", TestTableSourceSinks$.MODULE$.createCsvTemporarySinkTable$default$4());
        this.checkEmptyFile(sinkPath);
        TableResult tableResult = this.tEnv().executeSql("insert into MySink1 select first from MyTable");
        this.checkInsertTableResult(tableResult, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"default_catalog.default_database.MySink1"}));
        this.assertFirstValues(sinkPath);
    }

    @Test
    public void testExecuteSqlWithInsertOverwrite() {
        if (this.isStreaming) {
            return;
        }
        String sinkPath = this._tempFolder().newFolder().toString();
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |create table MySink (\n         |  first string\n         |) with (\n         |  'connector' = 'filesystem',\n         |  'path' = '", "',\n         |  'format' = 'testcsv'\n         |)\n       "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{sinkPath})))).stripMargin());
        TableResult tableResult1 = this.tEnv().executeSql("insert overwrite MySink select first from MyTable");
        this.checkInsertTableResult(tableResult1, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"default_catalog.default_database.MySink"}));
        this.assertFirstValues(sinkPath);
        TableResult tableResult2 = this.tEnv().executeSql("insert overwrite MySink select first from MyTable");
        this.checkInsertTableResult(tableResult2, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"default_catalog.default_database.MySink"}));
        this.assertFirstValues(sinkPath);
    }

    @Test
    public void testExecuteSqlAndSqlUpdate() {
        String sink1Path = TestTableSourceSinks$.MODULE$.createCsvTemporarySinkTable(this.tEnv(), new TableSchema((String[])((Object[])new String[]{"first"}), (TypeInformation[])((Object[])new TypeInformation[]{org.apache.flink.api.common.typeinfo.Types.STRING})), "MySink1", TestTableSourceSinks$.MODULE$.createCsvTemporarySinkTable$default$4());
        String sink2Path = TestTableSourceSinks$.MODULE$.createCsvTemporarySinkTable(this.tEnv(), new TableSchema((String[])((Object[])new String[]{"last"}), (TypeInformation[])((Object[])new TypeInformation[]{org.apache.flink.api.common.typeinfo.Types.STRING})), "MySink2", TestTableSourceSinks$.MODULE$.createCsvTemporarySinkTable$default$4());
        this.checkEmptyFile(sink1Path);
        this.checkEmptyFile(sink2Path);
        TableResult tableResult = this.tEnv().executeSql("insert into MySink1 select first from MyTable");
        this.checkInsertTableResult(tableResult, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"default_catalog.default_database.MySink1"}));
        this.assertFirstValues(sink1Path);
        this.checkEmptyFile(sink2Path);
        new File(sink1Path).delete();
        Assert.assertFalse((boolean)new File(sink1Path).exists());
        Table table2 = this.tEnv().sqlQuery("select last from MyTable");
        this.tEnv().insertInto(table2, "MySink2", new String[0]);
        this.tEnv().execute("test2");
        Assert.assertFalse((boolean)new File(sink1Path).exists());
        this.assertLastValues(sink2Path);
    }

    @Test
    public void testExecuteSqlAndToDataStream() {
        if (this.tableEnvName.equals("StreamTableEnvironment")) {
            org.apache.flink.streaming.api.environment.StreamExecutionEnvironment streamEnv = org.apache.flink.streaming.api.environment.StreamExecutionEnvironment.getExecutionEnvironment();
            StreamTableEnvironment streamTableEnv = StreamTableEnvironment.create((org.apache.flink.streaming.api.environment.StreamExecutionEnvironment)streamEnv, (EnvironmentSettings)this.settings());
            TestTableSourceSinks$.MODULE$.createPersonCsvTemporaryTable((TableEnvironment)streamTableEnv, "MyTable");
            String sink1Path = TestTableSourceSinks$.MODULE$.createCsvTemporarySinkTable((TableEnvironment)streamTableEnv, new TableSchema((String[])((Object[])new String[]{"first"}), (TypeInformation[])((Object[])new TypeInformation[]{org.apache.flink.api.common.typeinfo.Types.STRING})), "MySink1", TestTableSourceSinks$.MODULE$.createCsvTemporarySinkTable$default$4());
            this.checkEmptyFile(sink1Path);
            Table table = streamTableEnv.sqlQuery("select last from MyTable where id > 0");
            DataStream resultSet = streamTableEnv.toAppendStream(table, Row.class);
            TestingAppendSink sink = new TestingAppendSink();
            resultSet.addSink((SinkFunction)sink);
            TableResult tableResult = streamTableEnv.executeSql("insert into MySink1 select first from MyTable");
            this.checkInsertTableResult(tableResult, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"default_catalog.default_database.MySink1"}));
            this.assertFirstValues(sink1Path);
            Assert.assertFalse((boolean)sink.isInitialized());
            this.deleteFile(sink1Path);
            streamEnv.execute("test2");
            Assert.assertEquals((Object)this.getExpectedLastValues().sorted((Ordering)Ordering.String$.MODULE$), (Object)sink.getAppendResults().sorted((Ordering)Ordering.String$.MODULE$));
            this.assertFileNotExist(sink1Path);
            return;
        }
    }

    @Test
    public void testExecuteInsert() {
        String sinkPath = TestTableSourceSinks$.MODULE$.createCsvTemporarySinkTable(this.tEnv(), new TableSchema((String[])((Object[])new String[]{"first"}), (TypeInformation[])((Object[])new TypeInformation[]{org.apache.flink.api.common.typeinfo.Types.STRING})), "MySink", TestTableSourceSinks$.MODULE$.createCsvTemporarySinkTable$default$4());
        this.checkEmptyFile(sinkPath);
        Table table = this.tEnv().sqlQuery("select first from MyTable");
        TableResult tableResult = table.executeInsert("MySink");
        this.checkInsertTableResult(tableResult, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"default_catalog.default_database.MySink"}));
        this.assertFirstValues(sinkPath);
    }

    @Test
    public void testExecuteInsertOverwrite() {
        if (this.isStreaming) {
            return;
        }
        String sinkPath = this._tempFolder().newFolder().toString();
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |create table MySink (\n         |  first string\n         |) with (\n         |  'connector' = 'filesystem',\n         |  'path' = '", "',\n         |  'format' = 'testcsv'\n         |)\n       "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{sinkPath})))).stripMargin());
        TableResult tableResult1 = this.tEnv().sqlQuery("select first from MyTable").executeInsert("MySink", true);
        this.checkInsertTableResult(tableResult1, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"default_catalog.default_database.MySink"}));
        this.assertFirstValues(sinkPath);
        TableResult tableResult2 = this.tEnv().sqlQuery("select first from MyTable").executeInsert("MySink", true);
        this.checkInsertTableResult(tableResult2, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"default_catalog.default_database.MySink"}));
        this.assertFirstValues(sinkPath);
    }

    @Test
    public void testTableDMLSync() {
        this.tEnv().getConfig().getConfiguration().set(TableConfigOptions.TABLE_DML_SYNC, (Object)BoxesRunTime.boxToBoolean((boolean)true));
        String sink1Path = this._tempFolder().newFolder().toString();
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |create table MySink1 (\n         |  first string,\n         |  last string\n         |) with (\n         |  'connector' = 'filesystem',\n         |  'path' = '", "',\n         |  'format' = 'testcsv'\n         |)\n       "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{sink1Path})))).stripMargin());
        String sink2Path = this._tempFolder().newFolder().toString();
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |create table MySink2 (\n         |  first string\n         |) with (\n         |  'connector' = 'filesystem',\n         |  'path' = '", "',\n         |  'format' = 'testcsv'\n         |)\n       "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{sink2Path})))).stripMargin());
        String sink3Path = this._tempFolder().newFolder().toString();
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |create table MySink3 (\n         |  last string\n         |) with (\n         |  'connector' = 'filesystem',\n         |  'path' = '", "',\n         |  'format' = 'testcsv'\n         |)\n       "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{sink3Path})))).stripMargin());
        TableResult tableResult1 = this.tEnv().sqlQuery("select first, last from MyTable").executeInsert("MySink1", false);
        StatementSet stmtSet = this.tEnv().createStatementSet();
        stmtSet.addInsertSql("INSERT INTO MySink2 select first from MySink1");
        stmtSet.addInsertSql("INSERT INTO MySink3 select last from MySink1");
        TableResult tableResult2 = stmtSet.execute();
        this.assertFirstValues(sink2Path);
        this.assertLastValues(sink3Path);
        this.checkInsertTableResult(tableResult2, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"default_catalog.default_database.MySink2", "default_catalog.default_database.MySink3"}));
        tableResult1.await();
        tableResult2.await();
    }

    @Test
    public void testStatementSet() {
        String sink1Path = TestTableSourceSinks$.MODULE$.createCsvTemporarySinkTable(this.tEnv(), new TableSchema((String[])((Object[])new String[]{"first"}), (TypeInformation[])((Object[])new TypeInformation[]{org.apache.flink.api.common.typeinfo.Types.STRING})), "MySink1", TestTableSourceSinks$.MODULE$.createCsvTemporarySinkTable$default$4());
        String sink2Path = TestTableSourceSinks$.MODULE$.createCsvTemporarySinkTable(this.tEnv(), new TableSchema((String[])((Object[])new String[]{"last"}), (TypeInformation[])((Object[])new TypeInformation[]{org.apache.flink.api.common.typeinfo.Types.STRING})), "MySink2", TestTableSourceSinks$.MODULE$.createCsvTemporarySinkTable$default$4());
        StatementSet stmtSet = this.tEnv().createStatementSet();
        stmtSet.addInsert("MySink1", this.tEnv().sqlQuery("select first from MyTable")).addInsertSql("insert into MySink2 select last from MyTable");
        String actual = stmtSet.explain(new ExplainDetail[0]);
        String expected = TableTestUtil$.MODULE$.readFromResource("/explain/testStatementSet.out");
        Assert.assertEquals((Object)TableTestUtil$.MODULE$.replaceStageId(expected), (Object)TableTestUtil$.MODULE$.replaceStageId(actual));
        TableResult tableResult = stmtSet.execute();
        this.checkInsertTableResult(tableResult, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"default_catalog.default_database.MySink1", "default_catalog.default_database.MySink2"}));
        this.assertFirstValues(sink1Path);
        this.assertLastValues(sink2Path);
    }

    @Test
    public void testStatementSetWithOverwrite() {
        if (this.isStreaming) {
            return;
        }
        String sink1Path = this._tempFolder().newFolder().toString();
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |create table MySink1 (\n         |  first string\n         |) with (\n         |  'connector' = 'filesystem',\n         |  'path' = '", "',\n         |  'format' = 'testcsv'\n         |)\n       "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{sink1Path})))).stripMargin());
        String sink2Path = this._tempFolder().newFolder().toString();
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |create table MySink2 (\n         |  last string\n         |) with (\n         |  'connector' = 'filesystem',\n         |  'path' = '", "',\n         |  'format' = 'testcsv'\n         |)\n       "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{sink2Path})))).stripMargin());
        StatementSet stmtSet = this.tEnv().createStatementSet();
        stmtSet.addInsert("MySink1", this.tEnv().sqlQuery("select first from MyTable"), true);
        stmtSet.addInsertSql("insert overwrite MySink2 select last from MyTable");
        TableResult tableResult1 = stmtSet.execute();
        this.checkInsertTableResult(tableResult1, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"default_catalog.default_database.MySink1", "default_catalog.default_database.MySink2"}));
        this.assertFirstValues(sink1Path);
        this.assertLastValues(sink2Path);
        stmtSet.addInsert("MySink1", this.tEnv().sqlQuery("select first from MyTable"), true).addInsertSql("insert overwrite MySink2 select last from MyTable");
        TableResult tableResult2 = stmtSet.execute();
        this.checkInsertTableResult(tableResult2, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"default_catalog.default_database.MySink1", "default_catalog.default_database.MySink2"}));
        this.assertFirstValues(sink1Path);
        this.assertLastValues(sink2Path);
    }

    @Test
    public void testStatementSetWithSameSinkTableNames() {
        if (this.isStreaming) {
            return;
        }
        String sinkPath = this._tempFolder().newFolder().toString();
        this.tEnv().executeSql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |create table MySink (\n         |  first string\n         |) with (\n         |  'connector' = 'filesystem',\n         |  'path' = '", "',\n         |  'format' = 'testcsv'\n         |)\n       "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{sinkPath})))).stripMargin());
        StatementSet stmtSet = this.tEnv().createStatementSet();
        stmtSet.addInsert("MySink", this.tEnv().sqlQuery("select first from MyTable"), true);
        stmtSet.addInsertSql("insert overwrite MySink select last from MyTable");
        TableResult tableResult = stmtSet.execute();
        this.checkInsertTableResult(tableResult, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"default_catalog.default_database.MySink_1", "default_catalog.default_database.MySink_2"}));
    }

    @Test
    public void testExecuteSelect() {
        String query = new StringOps(Predef$.MODULE$.augmentString("\n        |select id, concat(concat(`first`, ' '), `last`) as `full name`\n        |from MyTable where mod(id, 2) = 0\n      ")).stripMargin();
        TableResult tableResult = this.tEnv().executeSql(query);
        Assert.assertTrue((boolean)tableResult.getJobClient().isPresent());
        Assert.assertEquals((Object)ResultKind.SUCCESS_WITH_CONTENT, (Object)tableResult.getResultKind());
        Assert.assertEquals((Object)ResolvedSchema.of((Column[])new Column[]{Column.physical((String)"id", (DataType)DataTypes.INT()), Column.physical((String)"full name", (DataType)DataTypes.STRING())}), (Object)tableResult.getResolvedSchema());
        java.util.List<Object> expected = Arrays.asList((Object[])new Row[]{Row.of((Object[])new Object[]{2, "Bob Taylor"}), Row.of((Object[])new Object[]{4, "Peter Smith"}), Row.of((Object[])new Object[]{6, "Sally Miller"}), Row.of((Object[])new Object[]{8, "Kelly Williams"})});
        java.util.List actual = CollectionUtil.iteratorToList((Iterator)tableResult.collect());
        actual.sort(new Comparator<Row>(this){

            public int compare(Row o1, Row o2) {
                return Predef$.MODULE$.int2Integer(BoxesRunTime.unboxToInt((Object)o1.getField(0))).compareTo(Predef$.MODULE$.int2Integer(BoxesRunTime.unboxToInt((Object)o2.getField(0))));
            }
        });
        Assert.assertEquals(expected, (Object)actual);
    }

    @Test
    public void testExecuteSelectWithUpdateChanges() {
        TableResult tableResult = this.tEnv().sqlQuery("select count(*) as c from MyTable").execute();
        Assert.assertTrue((boolean)tableResult.getJobClient().isPresent());
        Assert.assertEquals((Object)ResultKind.SUCCESS_WITH_CONTENT, (Object)tableResult.getResultKind());
        Assert.assertEquals((Object)ResolvedSchema.of((Column[])new Column[]{Column.physical((String)"c", (DataType)((DataType)DataTypes.BIGINT().notNull()))}), (Object)tableResult.getResolvedSchema());
        java.util.List<Object> expected = this.isStreaming ? Arrays.asList((Object[])new Row[]{Row.ofKind((RowKind)RowKind.INSERT, (Object[])new Object[]{1L}), Row.ofKind((RowKind)RowKind.UPDATE_BEFORE, (Object[])new Object[]{1L}), Row.ofKind((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{2L}), Row.ofKind((RowKind)RowKind.UPDATE_BEFORE, (Object[])new Object[]{2L}), Row.ofKind((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{3L}), Row.ofKind((RowKind)RowKind.UPDATE_BEFORE, (Object[])new Object[]{3L}), Row.ofKind((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{4L}), Row.ofKind((RowKind)RowKind.UPDATE_BEFORE, (Object[])new Object[]{4L}), Row.ofKind((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{5L}), Row.ofKind((RowKind)RowKind.UPDATE_BEFORE, (Object[])new Object[]{5L}), Row.ofKind((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{6L}), Row.ofKind((RowKind)RowKind.UPDATE_BEFORE, (Object[])new Object[]{6L}), Row.ofKind((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{7L}), Row.ofKind((RowKind)RowKind.UPDATE_BEFORE, (Object[])new Object[]{7L}), Row.ofKind((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{8L})}) : Arrays.asList((Object[])new Row[]{Row.of((Object[])new Object[]{8L})});
        java.util.List actual = CollectionUtil.iteratorToList((Iterator)tableResult.collect());
        Assert.assertEquals(expected, (Object)actual);
    }

    @Test
    public void testExecuteSelectWithTimeAttribute() {
        Seq data = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Mary"}));
        TableSchema schema = new TableSchema((String[])((Object[])new String[]{"name", "pt"}), (TypeInformation[])((Object[])new TypeInformation[]{Types.STRING(), Types.LOCAL_DATE_TIME()}));
        TypeInformation sourceType = Types.STRING();
        TestTableSourceWithTime tableSource = new TestTableSourceWithTime(true, schema, sourceType, data, null, "pt", TestTableSourceWithTime$.MODULE$.$lessinit$greater$default$7(), TestTableSourceWithTime$.MODULE$.$lessinit$greater$default$8());
        ((TableEnvironmentInternal)this.tEnv()).registerTableSourceInternal("T", tableSource);
        TableResult tableResult = this.tEnv().executeSql("select * from T");
        Assert.assertTrue((boolean)tableResult.getJobClient().isPresent());
        Assert.assertEquals((Object)ResultKind.SUCCESS_WITH_CONTENT, (Object)tableResult.getResultKind());
        Assert.assertEquals((Object)ResolvedSchema.of((Column[])new Column[]{Column.physical((String)"name", (DataType)DataTypes.STRING()), Column.physical((String)"pt", (DataType)DataTypes.TIMESTAMP_LTZ((int)3))}), (Object)tableResult.getResolvedSchema());
        CloseableIterator it = tableResult.collect();
        Assert.assertTrue((boolean)it.hasNext());
        Row row2 = (Row)it.next();
        Assert.assertEquals((long)2L, (long)row2.getArity());
        Assert.assertEquals((Object)"Mary", (Object)row2.getField(0));
        Assert.assertFalse((boolean)it.hasNext());
    }

    @Test
    public void testClearOperation() {
        TestCollectionTableFactory$.MODULE$.reset();
        TableEnvironmentImpl tableEnv = TableEnvironmentImpl.create((EnvironmentSettings)this.settings());
        tableEnv.executeSql("create table dest1(x map<int,bigint>) with('connector' = 'COLLECTION')");
        tableEnv.executeSql("create table dest2(x int) with('connector' = 'COLLECTION')");
        tableEnv.executeSql("create table src(x int) with('connector' = 'COLLECTION')");
        try {
            tableEnv.executeSql("insert into dest1 select count(*) from src");
            Assert.fail((String)"insert is expected to fail due to type mismatch");
        }
        catch (Exception exception) {}
        tableEnv.executeSql("drop table dest1");
        tableEnv.executeSql("insert into dest2 select x from src").await();
    }

    @Test
    public void testTemporaryOperationListener() {
        ListenerCatalog listener = new ListenerCatalog("listener_cat");
        String currentCat = this.tEnv().getCurrentCatalog();
        this.tEnv().registerCatalog(listener.getName(), (Catalog)listener);
        this.tEnv().executeSql("create temporary table tbl1 (x int)");
        Assert.assertEquals((long)0L, (long)listener.numTempTable());
        this.tEnv().executeSql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"create temporary table ", ".`default`.tbl1 (x int)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{listener.getName()})));
        Assert.assertEquals((long)1L, (long)listener.numTempTable());
        Optional tableResult = ((TableEnvironmentInternal)this.tEnv()).getCatalogManager().getTable(ObjectIdentifier.of((String)listener.getName(), (String)"default", (String)"tbl1"));
        Assert.assertTrue((boolean)tableResult.isPresent());
        Assert.assertEquals((Object)listener.tableComment(), (Object)((CatalogManager.TableLookupResult)tableResult.get()).getTable().getComment());
        this.tEnv().executeSql("drop temporary table tbl1");
        Assert.assertEquals((long)1L, (long)listener.numTempTable());
        this.tEnv().executeSql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"drop temporary table ", ".`default`.tbl1"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{listener.getName()})));
        Assert.assertEquals((long)0L, (long)listener.numTempTable());
        this.tEnv().useCatalog(listener.getName());
        this.tEnv().executeSql("create temporary table tbl1 (x int)");
        Assert.assertEquals((long)1L, (long)listener.numTempTable());
        this.tEnv().executeSql("drop temporary table tbl1");
        Assert.assertEquals((long)0L, (long)listener.numTempTable());
        this.tEnv().useCatalog(currentCat);
        this.tEnv().executeSql("create temporary view v1 as select 1");
        Assert.assertEquals((long)0L, (long)listener.numTempTable());
        this.tEnv().executeSql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"create temporary view ", ".`default`.v1 as select 1"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{listener.getName()})));
        Assert.assertEquals((long)1L, (long)listener.numTempTable());
        Optional viewResult = ((TableEnvironmentInternal)this.tEnv()).getCatalogManager().getTable(ObjectIdentifier.of((String)listener.getName(), (String)"default", (String)"v1"));
        Assert.assertTrue((boolean)viewResult.isPresent());
        Assert.assertEquals((Object)listener.tableComment(), (Object)((CatalogManager.TableLookupResult)viewResult.get()).getTable().getComment());
        this.tEnv().executeSql("drop temporary view v1");
        Assert.assertEquals((long)1L, (long)listener.numTempTable());
        this.tEnv().executeSql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"drop temporary view ", ".`default`.v1"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{listener.getName()})));
        Assert.assertEquals((long)0L, (long)listener.numTempTable());
        this.tEnv().useCatalog(listener.getName());
        this.tEnv().executeSql("create temporary view v1 as select 1");
        Assert.assertEquals((long)1L, (long)listener.numTempTable());
        this.tEnv().executeSql("drop temporary view  v1");
        Assert.assertEquals((long)0L, (long)listener.numTempTable());
        this.tEnv().useCatalog(currentCat);
        String clzName = "foo.class.name";
        try {
            this.tEnv().executeSql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"create temporary function func1 as '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{clzName})));
            Assert.fail((String)"Creating a temporary function with invalid class should fail");
        }
        catch (Exception exception) {}
        Assert.assertEquals((long)0L, (long)listener.numTempFunc());
        this.tEnv().executeSql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"create temporary function ", ".`default`.func1 as '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{listener.getName(), clzName})));
        Assert.assertEquals((long)1L, (long)listener.numTempFunc());
        this.tEnv().executeSql("drop temporary function if exists func1");
        Assert.assertEquals((long)1L, (long)listener.numTempFunc());
        this.tEnv().executeSql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"drop temporary function ", ".`default`.func1"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{listener.getName()})));
        Assert.assertEquals((long)0L, (long)listener.numTempFunc());
        this.tEnv().useCatalog(listener.getName());
        this.tEnv().executeSql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"create temporary function func1 as '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{clzName})));
        Assert.assertEquals((long)1L, (long)listener.numTempFunc());
        this.tEnv().executeSql("drop temporary function func1");
        Assert.assertEquals((long)0L, (long)listener.numTempFunc());
        this.tEnv().useCatalog(currentCat);
        listener.close();
    }

    public List<Tuple4<String, Object, Object, String>> getPersonData() {
        MutableList data = new MutableList();
        data.$plus$eq((Object)new Tuple4((Object)"Mike", (Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToDouble((double)12.3), (Object)"Smith"));
        data.$plus$eq((Object)new Tuple4((Object)"Bob", (Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToDouble((double)45.6), (Object)"Taylor"));
        data.$plus$eq((Object)new Tuple4((Object)"Sam", (Object)BoxesRunTime.boxToInteger((int)3), (Object)BoxesRunTime.boxToDouble((double)7.89), (Object)"Miller"));
        data.$plus$eq((Object)new Tuple4((Object)"Peter", (Object)BoxesRunTime.boxToInteger((int)4), (Object)BoxesRunTime.boxToDouble((double)0.12), (Object)"Smith"));
        data.$plus$eq((Object)new Tuple4((Object)"Liz", (Object)BoxesRunTime.boxToInteger((int)5), (Object)BoxesRunTime.boxToDouble((double)34.5), (Object)"Williams"));
        data.$plus$eq((Object)new Tuple4((Object)"Sally", (Object)BoxesRunTime.boxToInteger((int)6), (Object)BoxesRunTime.boxToDouble((double)6.78), (Object)"Miller"));
        data.$plus$eq((Object)new Tuple4((Object)"Alice", (Object)BoxesRunTime.boxToInteger((int)7), (Object)BoxesRunTime.boxToDouble((double)90.1), (Object)"Smith"));
        data.$plus$eq((Object)new Tuple4((Object)"Kelly", (Object)BoxesRunTime.boxToInteger((int)8), (Object)BoxesRunTime.boxToDouble((double)2.34), (Object)"Williams"));
        return data.toList();
    }

    private void assertFirstValues(String csvFilePath) {
        List expected = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Mike", "Bob", "Sam", "Peter", "Liz", "Sally", "Alice", "Kelly"}));
        List<String> actual = this.readFile(csvFilePath);
        Assert.assertEquals((Object)expected.sorted((Ordering)Ordering.String$.MODULE$), (Object)actual.sorted((Ordering)Ordering.String$.MODULE$));
    }

    private void assertLastValues(String csvFilePath) {
        List<String> actual = this.readFile(csvFilePath);
        Assert.assertEquals((Object)this.getExpectedLastValues().sorted((Ordering)Ordering.String$.MODULE$), (Object)actual.sorted((Ordering)Ordering.String$.MODULE$));
    }

    private List<String> getExpectedLastValues() {
        return List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Smith", "Taylor", "Miller", "Smith", "Williams", "Miller", "Smith", "Williams"}));
    }

    private void checkEmptyFile(String csvFilePath) {
        Assert.assertTrue((boolean)FileUtils.readFileUtf8((File)new File(csvFilePath)).isEmpty());
    }

    private void deleteFile(String path) {
        new File(path).delete();
        Assert.assertFalse((boolean)new File(path).exists());
    }

    private void assertFileNotExist(String path) {
        Assert.assertFalse((boolean)new File(path).exists());
    }

    private void checkInsertTableResult(TableResult tableResult, Seq<String> fieldNames) {
        Assert.assertTrue((boolean)tableResult.getJobClient().isPresent());
        Assert.assertEquals((Object)ResultKind.SUCCESS_WITH_CONTENT, (Object)tableResult.getResultKind());
        Assert.assertEquals(Arrays.asList((Object[])fieldNames.toArray(ClassTag$.MODULE$.apply(String.class))), (Object)tableResult.getResolvedSchema().getColumnNames());
        CloseableIterator it = tableResult.collect();
        Assert.assertTrue((boolean)it.hasNext());
        Seq affectedRowCounts = (Seq)fieldNames.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Long apply(String x$1) {
                return -1L;
            }
        }, Seq$.MODULE$.canBuildFrom());
        Assert.assertEquals((Object)Row.of((Object[])((Object[])affectedRowCounts.toArray(ClassTag$.MODULE$.apply(Long.class)))), (Object)it.next());
        Assert.assertFalse((boolean)it.hasNext());
    }

    private List<String> readFile(String csvFilePath) {
        File file = new File(csvFilePath);
        return file.isDirectory() ? Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])file.listFiles(new FileFilter(this){

            public boolean accept(File f) {
                return f.isFile();
            }
        })).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(File x$1) {
                return FileUtils.readFileUtf8((File)x$1);
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final ArrayOps<String> apply(String x$2) {
                return Predef$.MODULE$.refArrayOps((Object[])x$2.split("\n"));
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).toList() : Predef$.MODULE$.refArrayOps((Object[])FileUtils.readFileUtf8((File)file).split("\n")).toList();
    }

    public TableEnvironmentITCase(String tableEnvName, boolean isStreaming) {
        this.tableEnvName = tableEnvName;
        this.isStreaming = isStreaming;
        this.expectedException = ExpectedException.none();
        this._tempFolder = new TemporaryFolder();
        this.settings = isStreaming ? EnvironmentSettings.newInstance().inStreamingMode().build() : EnvironmentSettings.newInstance().inBatchMode().build();
    }

    public class ListenerCatalog
    extends GenericInMemoryCatalog
    implements TemporaryOperationListener {
        private final String tableComment;
        private final String funcClzName;
        private int numTempTable;
        private int numTempFunc;

        public String tableComment() {
            return this.tableComment;
        }

        public String funcClzName() {
            return this.funcClzName;
        }

        public int numTempTable() {
            return this.numTempTable;
        }

        public void numTempTable_$eq(int x$1) {
            this.numTempTable = x$1;
        }

        public int numTempFunc() {
            return this.numTempFunc;
        }

        public void numTempFunc_$eq(int x$1) {
            this.numTempFunc = x$1;
        }

        public CatalogBaseTable onCreateTemporaryTable(ObjectPath tablePath, CatalogBaseTable table) {
            CatalogTableImpl catalogTableImpl;
            this.numTempTable_$eq(this.numTempTable() + 1);
            if (table instanceof CatalogTable) {
                catalogTableImpl = new CatalogTableImpl(table.getSchema(), table.getOptions(), this.tableComment());
            } else {
                CatalogView view = (CatalogView)table;
                catalogTableImpl = new CatalogViewImpl(view.getOriginalQuery(), view.getExpandedQuery(), view.getSchema(), view.getOptions(), this.tableComment());
            }
            return catalogTableImpl;
        }

        public void onDropTemporaryTable(ObjectPath tablePath) {
            this.numTempTable_$eq(this.numTempTable() - 1);
        }

        public CatalogFunction onCreateTemporaryFunction(ObjectPath functionPath, CatalogFunction function) {
            this.numTempFunc_$eq(this.numTempFunc() + 1);
            return new CatalogFunctionImpl(this.funcClzName(), function.getFunctionLanguage());
        }

        public void onDropTemporaryFunction(ObjectPath functionPath) {
            this.numTempFunc_$eq(this.numTempFunc() - 1);
        }

        public /* synthetic */ TableEnvironmentITCase org$apache$flink$table$api$TableEnvironmentITCase$ListenerCatalog$$$outer() {
            return TableEnvironmentITCase.this;
        }

        public ListenerCatalog(String name) {
            if (TableEnvironmentITCase.this == null) {
                throw null;
            }
            super(name);
            this.tableComment = "listener_comment";
            this.funcClzName = TestGenericUDF.class.getName();
            this.numTempTable = 0;
            this.numTempFunc = 0;
        }
    }
}

