/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.api.bridge.scala.internal;

import java.lang.reflect.Method;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.table.api.EnvironmentSettings;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.bridge.scala.internal.StreamTableEnvironmentImpl;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.CatalogManager;
import org.apache.flink.table.catalog.FunctionCatalog;
import org.apache.flink.table.catalog.GenericInMemoryCatalog;
import org.apache.flink.table.delegation.Executor;
import org.apache.flink.table.delegation.ExecutorFactory;
import org.apache.flink.table.delegation.Planner;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.flink.table.factories.PlannerFactoryUtil;
import org.apache.flink.table.module.ModuleManager;

public final class StreamTableEnvironmentImpl$ {
    public static final StreamTableEnvironmentImpl$ MODULE$;

    static {
        new StreamTableEnvironmentImpl$();
    }

    public StreamTableEnvironmentImpl create(org.apache.flink.streaming.api.scala.StreamExecutionEnvironment executionEnvironment, EnvironmentSettings settings, TableConfig tableConfig) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        ModuleManager moduleManager = new ModuleManager();
        CatalogManager catalogManager = CatalogManager.newBuilder().classLoader(classLoader).config((ReadableConfig)tableConfig.getConfiguration()).defaultCatalog(settings.getBuiltInCatalogName(), (Catalog)new GenericInMemoryCatalog(settings.getBuiltInCatalogName(), settings.getBuiltInDatabaseName())).executionConfig(executionEnvironment.getConfig()).build();
        FunctionCatalog functionCatalog = new FunctionCatalog(tableConfig, catalogManager, moduleManager);
        Executor executor = this.lookupExecutor(classLoader, settings.getExecutor(), executionEnvironment);
        Planner planner = PlannerFactoryUtil.createPlanner((String)settings.getPlanner(), (Executor)executor, (TableConfig)tableConfig, (CatalogManager)catalogManager, (FunctionCatalog)functionCatalog);
        return new StreamTableEnvironmentImpl(catalogManager, moduleManager, functionCatalog, tableConfig, executionEnvironment, planner, executor, settings.isStreamingMode(), classLoader);
    }

    private Executor lookupExecutor(ClassLoader classLoader, String executorIdentifier, org.apache.flink.streaming.api.scala.StreamExecutionEnvironment executionEnvironment) {
        try {
            ExecutorFactory executorFactory = (ExecutorFactory)FactoryUtil.discoverFactory((ClassLoader)classLoader, ExecutorFactory.class, (String)executorIdentifier);
            Method createMethod = executorFactory.getClass().getMethod("create", StreamExecutionEnvironment.class);
            return (Executor)createMethod.invoke((Object)executorFactory, executionEnvironment.getWrappedStreamExecutionEnvironment());
        }
        catch (Exception exception) {
            throw new TableException("Could not instantiate the executor. Make sure a planner module is on the classpath", (Throwable)exception);
        }
    }

    private StreamTableEnvironmentImpl$() {
        MODULE$ = this;
    }
}

