/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.util;

import java.util.Arrays;
import java.util.List;
import org.apache.flink.streaming.api.operators.AbstractInput;
import org.apache.flink.streaming.api.operators.AbstractStreamOperatorV2;
import org.apache.flink.streaming.api.operators.BoundedMultiInput;
import org.apache.flink.streaming.api.operators.Input;
import org.apache.flink.streaming.api.operators.MultipleInputStreamOperator;
import org.apache.flink.streaming.api.operators.StreamOperatorParameters;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;

public class TestBoundedMultipleInputOperator
extends AbstractStreamOperatorV2<String>
implements MultipleInputStreamOperator<String>,
BoundedMultiInput {
    private static final long serialVersionUID = 1L;
    private final String name;

    public TestBoundedMultipleInputOperator(String name, StreamOperatorParameters<String> parameters) {
        super(parameters, 3);
        this.name = name;
    }

    public List<Input> getInputs() {
        return Arrays.asList(new Input[]{new TestInput(this, 1), new TestInput(this, 2), new TestInput(this, 3)});
    }

    public void endInput(int inputId) {
        this.output.collect((Object)new StreamRecord((Object)("[" + this.name + "-" + inputId + "]: End of input")));
    }

    public void close() throws Exception {
        this.output.collect((Object)new StreamRecord((Object)("[" + this.name + "]: Bye")));
        super.close();
    }

    class TestInput
    extends AbstractInput<String, String> {
        public TestInput(AbstractStreamOperatorV2<String> owner, int inputId) {
            super(owner, inputId);
        }

        public void processElement(StreamRecord<String> element) throws Exception {
            this.output.collect((Object)element.replace((Object)("[" + TestBoundedMultipleInputOperator.this.name + "-" + this.inputId + "]: " + (String)element.getValue())));
        }
    }
}

