/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.api.operators.Output;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.streaming.util.KeyedOneInputStreamOperatorTestHarness;
import org.apache.flink.streaming.util.MockOutput;

public class MockContext<IN, OUT> {
    private List<OUT> outputs;
    private MockOutput<OUT> output;

    public MockContext(Collection<IN> inputs) {
        if (inputs.isEmpty()) {
            throw new RuntimeException("Inputs must not be empty");
        }
        this.outputs = new ArrayList<OUT>();
        this.output = new MockOutput<OUT>(this.outputs);
    }

    public List<OUT> getOutputs() {
        return this.outputs;
    }

    public Output<StreamRecord<OUT>> getOutput() {
        return this.output;
    }

    public static <IN, OUT> List<OUT> createAndExecute(OneInputStreamOperator<IN, OUT> operator, List<IN> inputs) throws Exception {
        return MockContext.createAndExecuteForKeyedStream(operator, inputs, null, null);
    }

    public static <IN, OUT, KEY> List<OUT> createAndExecuteForKeyedStream(OneInputStreamOperator<IN, OUT> operator, List<IN> inputs, KeySelector<IN, KEY> keySelector, TypeInformation<KEY> keyType) throws Exception {
        KeyedOneInputStreamOperatorTestHarness<KEY, IN, OUT> testHarness = new KeyedOneInputStreamOperatorTestHarness<KEY, IN, OUT>(operator, keySelector, keyType);
        testHarness.setup();
        testHarness.open();
        operator.open();
        for (IN in : inputs) {
            testHarness.processElement(new StreamRecord(in));
        }
        testHarness.close();
        ConcurrentLinkedQueue<Object> output = testHarness.getOutput();
        ArrayList<Object> result = new ArrayList<Object>();
        for (Object o : output) {
            if (!(o instanceof StreamRecord)) continue;
            result.add(((StreamRecord)o).getValue());
        }
        return result;
    }
}

