/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.util;

import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.state.StateDescriptor;
import org.apache.flink.api.common.state.StateTtlConfig;
import org.apache.flink.api.common.state.ValueState;
import org.apache.flink.api.common.state.ValueStateDescriptor;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.IntSerializer;
import org.apache.flink.runtime.checkpoint.OperatorSubtaskState;
import org.apache.flink.runtime.state.KeyedStateBackend;
import org.apache.flink.runtime.state.VoidNamespace;
import org.apache.flink.runtime.state.VoidNamespaceSerializer;
import org.apache.flink.streaming.api.functions.ProcessFunction;
import org.apache.flink.streaming.api.operators.AbstractStreamOperator;
import org.apache.flink.streaming.api.operators.ProcessOperator;
import org.apache.flink.streaming.util.AbstractStreamOperatorTestHarness;
import org.apache.flink.streaming.util.OneInputStreamOperatorTestHarness;
import org.apache.flink.util.Collector;
import org.apache.flink.util.OutputTag;
import org.apache.flink.util.TestLogger;
import org.hamcrest.CoreMatchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class AbstractStreamOperatorTestHarnessTest
extends TestLogger {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void testInitializeAfterOpenning() throws Throwable {
        this.expectedException.expect(IllegalStateException.class);
        this.expectedException.expectMessage(CoreMatchers.containsString((String)"TestHarness has already been initialized."));
        AbstractStreamOperatorTestHarness result = new AbstractStreamOperatorTestHarness(new AbstractStreamOperator<Integer>(){}, 1, 1, 0);
        result.setup();
        result.open();
        result.initializeState(OperatorSubtaskState.builder().build());
    }

    @Test
    public void testSetTtlTimeProvider() throws Exception {
        AbstractStreamOperator<Integer> operator = new AbstractStreamOperator<Integer>(){};
        try (AbstractStreamOperatorTestHarness result = new AbstractStreamOperatorTestHarness(operator, 1, 1, 0);){
            result.config.setStateKeySerializer((TypeSerializer)IntSerializer.INSTANCE);
            Time timeToLive = Time.hours((long)1L);
            result.initializeState(OperatorSubtaskState.builder().build());
            result.open();
            ValueStateDescriptor stateDescriptor = new ValueStateDescriptor("test", (TypeSerializer)IntSerializer.INSTANCE);
            stateDescriptor.enableTimeToLive(StateTtlConfig.newBuilder((Time)timeToLive).build());
            KeyedStateBackend keyedStateBackend = operator.getKeyedStateBackend();
            ValueState state = (ValueState)keyedStateBackend.getPartitionedState((Object)VoidNamespace.INSTANCE, (TypeSerializer)VoidNamespaceSerializer.INSTANCE, (StateDescriptor)stateDescriptor);
            int expectedValue = 42;
            keyedStateBackend.setCurrentKey((Object)1);
            result.setStateTtlProcessingTime(0L);
            state.update((Object)expectedValue);
            Assert.assertEquals((long)expectedValue, (long)((Integer)state.value()).intValue());
            result.setStateTtlProcessingTime(timeToLive.toMilliseconds() + 1L);
            Assert.assertNull((Object)state.value());
        }
    }

    @Test
    public void testSideOutputTypeInformation() throws Throwable {
        int probe = 12;
        TypeSerializer typeSerializer = (TypeSerializer)Mockito.spy(TypeSerializer.class);
        TypeInformation typeInformation = (TypeInformation)Mockito.spy((Object)Types.INT);
        Mockito.when((Object)typeInformation.createSerializer((ExecutionConfig)ArgumentMatchers.any(ExecutionConfig.class))).thenReturn((Object)typeSerializer);
        OutputTag outputTag = new OutputTag("test", typeInformation);
        SideOutputTypeInformationTestFunction testFunction = new SideOutputTypeInformationTestFunction((OutputTag<Integer>)outputTag);
        OneInputStreamOperatorTestHarness result = new OneInputStreamOperatorTestHarness(new ProcessOperator((ProcessFunction)testFunction));
        result.setup();
        result.open();
        result.processElement(12, 1000L);
        ((TypeSerializer)Mockito.verify((Object)typeSerializer, (VerificationMode)Mockito.times((int)1))).copy((Object)ArgumentMatchers.eq((int)12));
    }

    private static class SideOutputTypeInformationTestFunction
    extends ProcessFunction<Integer, Integer> {
        private final OutputTag<Integer> outputTag;

        SideOutputTypeInformationTestFunction(OutputTag<Integer> outputTag) {
            this.outputTag = outputTag;
        }

        public void processElement(Integer value, ProcessFunction.Context ctx, Collector<Integer> out) throws Exception {
            ctx.output(this.outputTag, (Object)value);
        }
    }
}

