/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.tasks;

import java.util.Collections;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.JobID;
import org.apache.flink.configuration.ClusterOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.UserSystemExitException;
import org.apache.flink.runtime.broadcast.BroadcastVariableManager;
import org.apache.flink.runtime.clusterframework.types.AllocationID;
import org.apache.flink.runtime.concurrent.Executors;
import org.apache.flink.runtime.execution.Environment;
import org.apache.flink.runtime.execution.librarycache.LibraryCacheManager;
import org.apache.flink.runtime.execution.librarycache.TestingClassLoaderLease;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.executiongraph.JobInformation;
import org.apache.flink.runtime.executiongraph.TaskInformation;
import org.apache.flink.runtime.externalresource.ExternalResourceInfoProvider;
import org.apache.flink.runtime.filecache.FileCache;
import org.apache.flink.runtime.io.disk.iomanager.IOManager;
import org.apache.flink.runtime.io.disk.iomanager.IOManagerAsync;
import org.apache.flink.runtime.io.network.NettyShuffleEnvironment;
import org.apache.flink.runtime.io.network.NettyShuffleEnvironmentBuilder;
import org.apache.flink.runtime.io.network.TaskEventDispatcher;
import org.apache.flink.runtime.io.network.partition.NoOpResultPartitionConsumableNotifier;
import org.apache.flink.runtime.io.network.partition.ResultPartitionConsumableNotifier;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.jobgraph.OperatorID;
import org.apache.flink.runtime.jobgraph.tasks.InputSplitProvider;
import org.apache.flink.runtime.jobgraph.tasks.TaskOperatorEventGateway;
import org.apache.flink.runtime.memory.MemoryManagerBuilder;
import org.apache.flink.runtime.metrics.groups.UnregisteredMetricGroups;
import org.apache.flink.runtime.operators.testutils.MockEnvironment;
import org.apache.flink.runtime.operators.testutils.MockEnvironmentBuilder;
import org.apache.flink.runtime.query.KvStateRegistry;
import org.apache.flink.runtime.security.FlinkSecurityManager;
import org.apache.flink.runtime.shuffle.ShuffleEnvironment;
import org.apache.flink.runtime.state.TaskStateManager;
import org.apache.flink.runtime.state.TestTaskStateManager;
import org.apache.flink.runtime.taskexecutor.GlobalAggregateManager;
import org.apache.flink.runtime.taskexecutor.KvStateService;
import org.apache.flink.runtime.taskexecutor.PartitionProducerStateChecker;
import org.apache.flink.runtime.taskexecutor.TestGlobalAggregateManager;
import org.apache.flink.runtime.taskmanager.CheckpointResponder;
import org.apache.flink.runtime.taskmanager.NoOpTaskOperatorEventGateway;
import org.apache.flink.runtime.taskmanager.Task;
import org.apache.flink.runtime.taskmanager.TaskManagerActions;
import org.apache.flink.runtime.taskmanager.TaskManagerRuntimeInfo;
import org.apache.flink.runtime.util.TestingTaskManagerRuntimeInfo;
import org.apache.flink.streaming.api.TimeCharacteristic;
import org.apache.flink.streaming.api.functions.source.SourceFunction;
import org.apache.flink.streaming.api.graph.StreamConfig;
import org.apache.flink.streaming.api.operators.AbstractStreamOperator;
import org.apache.flink.streaming.api.operators.StreamOperator;
import org.apache.flink.streaming.api.operators.StreamSource;
import org.apache.flink.streaming.runtime.tasks.SourceStreamTask;
import org.apache.flink.streaming.runtime.tasks.StreamTask;
import org.apache.flink.streaming.runtime.tasks.StreamTaskTest;
import org.apache.flink.streaming.runtime.tasks.mailbox.MailboxDefaultAction;
import org.apache.flink.util.SerializedValue;
import org.apache.flink.util.TestLogger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class StreamTaskSystemExitTest
extends TestLogger {
    private static final int TEST_EXIT_CODE = 123;
    private SecurityManager originalSecurityManager;

    private static void systemExit() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkExit(123);
        }
    }

    @Before
    public void setUp() {
        Configuration configuration = new Configuration();
        configuration.set(ClusterOptions.INTERCEPT_USER_SYSTEM_EXIT, (Object)ClusterOptions.UserSystemExitMode.THROW);
        this.originalSecurityManager = System.getSecurityManager();
        FlinkSecurityManager.setFromConfiguration((Configuration)configuration);
    }

    @After
    public void tearDown() {
        System.setSecurityManager(this.originalSecurityManager);
    }

    @Test
    public void testInitSystemExitStreamTask() throws Exception {
        Task task = this.createSystemExitTask(InitSystemExitStreamTask.class.getName(), null);
        task.run();
        Assert.assertNotNull((Object)task.getFailureCause());
        Assert.assertEquals(task.getFailureCause().getClass(), UserSystemExitException.class);
    }

    @Test
    public void testProcessInputSystemExitStreamTask() throws Exception {
        Task task = this.createSystemExitTask(ProcessInputSystemExitStreamTask.class.getName(), null);
        task.run();
        Assert.assertNotNull((Object)task.getFailureCause());
        Assert.assertEquals(task.getFailureCause().getClass(), UserSystemExitException.class);
    }

    @Test(expected=UserSystemExitException.class)
    public void testCancelSystemExitStreamTask() throws Exception {
        MockEnvironment mockEnvironment = new MockEnvironmentBuilder().build();
        SystemExitStreamTask systemExitStreamTask = new SystemExitStreamTask((Environment)mockEnvironment, SystemExitStreamTask.ExitPoint.CANCEL);
        systemExitStreamTask.cancel();
    }

    @Test
    public void testStreamSourceSystemExitStreamTask() throws Exception {
        TestStreamSource testStreamSource = new TestStreamSource(new SystemExitSourceFunction());
        Task task = this.createSystemExitTask(SystemExitSourceStreamTask.class.getName(), (StreamOperator<?>)testStreamSource);
        task.run();
        Assert.assertNotNull((Object)task.getFailureCause());
        Assert.assertEquals(task.getFailureCause().getClass(), UserSystemExitException.class);
    }

    private Task createSystemExitTask(String invokableClassName, StreamOperator<?> operator) throws Exception {
        Configuration taskConfiguration = new Configuration();
        StreamConfig streamConfig = new StreamConfig(taskConfiguration);
        streamConfig.setOperatorID(new OperatorID());
        streamConfig.setStreamOperator(operator);
        streamConfig.setTimeCharacteristic(TimeCharacteristic.ProcessingTime);
        JobInformation jobInformation = new JobInformation(new JobID(), "Test Job", new SerializedValue((Object)new ExecutionConfig()), new Configuration(), Collections.emptyList(), Collections.emptyList());
        TaskInformation taskInformation = new TaskInformation(new JobVertexID(), "Test Task", 1, 1, invokableClassName, taskConfiguration);
        TestingTaskManagerRuntimeInfo taskManagerRuntimeInfo = new TestingTaskManagerRuntimeInfo();
        NettyShuffleEnvironment shuffleEnvironment = new NettyShuffleEnvironmentBuilder().build();
        return new Task(jobInformation, taskInformation, new ExecutionAttemptID(), new AllocationID(), 0, 0, Collections.emptyList(), Collections.emptyList(), MemoryManagerBuilder.newBuilder().setMemorySize(32768L).build(), (IOManager)new IOManagerAsync(), (ShuffleEnvironment)shuffleEnvironment, new KvStateService(new KvStateRegistry(), null, null), (BroadcastVariableManager)Mockito.mock(BroadcastVariableManager.class), new TaskEventDispatcher(), ExternalResourceInfoProvider.NO_EXTERNAL_RESOURCES, (TaskStateManager)new TestTaskStateManager(), (TaskManagerActions)Mockito.mock(TaskManagerActions.class), (InputSplitProvider)Mockito.mock(InputSplitProvider.class), (CheckpointResponder)Mockito.mock(CheckpointResponder.class), (TaskOperatorEventGateway)new NoOpTaskOperatorEventGateway(), (GlobalAggregateManager)new TestGlobalAggregateManager(), (LibraryCacheManager.ClassLoaderHandle)TestingClassLoaderLease.newBuilder().build(), (FileCache)Mockito.mock(FileCache.class), (TaskManagerRuntimeInfo)taskManagerRuntimeInfo, UnregisteredMetricGroups.createUnregisteredTaskMetricGroup(), (ResultPartitionConsumableNotifier)new NoOpResultPartitionConsumableNotifier(), (PartitionProducerStateChecker)Mockito.mock(PartitionProducerStateChecker.class), Executors.directExecutor());
    }

    static class TestStreamSource<OUT, SRC extends SourceFunction<OUT>>
    extends StreamSource<OUT, SRC> {
        public TestStreamSource(SRC sourceFunction) {
            super(sourceFunction);
        }
    }

    private static class SystemExitSourceFunction
    implements SourceFunction<String> {
        private SystemExitSourceFunction() {
        }

        public void run(SourceFunction.SourceContext<String> ctx) {
            StreamTaskSystemExitTest.systemExit();
        }

        public void cancel() {
        }
    }

    public static class SystemExitSourceStreamTask
    extends SourceStreamTask<String, SystemExitSourceFunction, StreamTaskTest.TestStreamSource<String, SystemExitSourceFunction>> {
        public SystemExitSourceStreamTask(Environment env) throws Exception {
            super(env);
        }
    }

    public static class ProcessInputSystemExitStreamTask
    extends SystemExitStreamTask {
        public ProcessInputSystemExitStreamTask(Environment env) throws Exception {
            super(env, SystemExitStreamTask.ExitPoint.PROCESS_INPUT);
        }
    }

    public static class InitSystemExitStreamTask
    extends SystemExitStreamTask {
        public InitSystemExitStreamTask(Environment env) throws Exception {
            super(env, SystemExitStreamTask.ExitPoint.INIT);
        }
    }

    public static class SystemExitStreamTask
    extends StreamTask<String, AbstractStreamOperator<String>> {
        private final ExitPoint exitPoint;

        public SystemExitStreamTask(Environment env) throws Exception {
            this(env, ExitPoint.NONE);
        }

        public SystemExitStreamTask(Environment env, ExitPoint exitPoint) throws Exception {
            super(env, null);
            this.exitPoint = exitPoint;
        }

        protected void init() {
            if (this.exitPoint == ExitPoint.INIT) {
                StreamTaskSystemExitTest.systemExit();
            }
        }

        protected void processInput(MailboxDefaultAction.Controller controller) throws Exception {
            if (this.exitPoint == ExitPoint.PROCESS_INPUT) {
                StreamTaskSystemExitTest.systemExit();
            }
        }

        protected void cleanup() {
        }

        protected void cancelTask() {
            if (this.exitPoint == ExitPoint.CANCEL) {
                StreamTaskSystemExitTest.systemExit();
            }
        }

        protected static enum ExitPoint {
            NONE,
            INIT,
            PROCESS_INPUT,
            CANCEL;

        }
    }
}

