/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.operators.sink;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import org.apache.flink.core.io.SimpleVersionedSerializer;
import org.apache.flink.streaming.api.functions.sink.filesystem.bucketassigners.SimpleVersionedStringSerializer;
import org.apache.flink.streaming.runtime.operators.sink.StreamingCommitterState;
import org.apache.flink.streaming.runtime.operators.sink.StreamingCommitterStateSerializer;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;

public class StreamingCommitterStateSerializerTest {
    @Test
    public void serializeNonEmptyState() throws IOException {
        StreamingCommitterState expectedStreamingCommitterState = new StreamingCommitterState(Arrays.asList("city", "great", "temper", "valley"));
        StreamingCommitterStateSerializer streamingCommitterStateSerializer = new StreamingCommitterStateSerializer((SimpleVersionedSerializer)SimpleVersionedStringSerializer.INSTANCE);
        byte[] serialize = streamingCommitterStateSerializer.serialize(expectedStreamingCommitterState);
        StreamingCommitterState streamingCommitterState = streamingCommitterStateSerializer.deserialize(streamingCommitterStateSerializer.getVersion(), serialize);
        MatcherAssert.assertThat((Object)streamingCommitterState.getCommittables(), (Matcher)CoreMatchers.equalTo((Object)expectedStreamingCommitterState.getCommittables()));
    }

    @Test
    public void serializeEmptyState() throws IOException {
        StreamingCommitterState expectedStreamingCommitterState = new StreamingCommitterState(Collections.emptyList());
        StreamingCommitterStateSerializer streamingCommitterStateSerializer = new StreamingCommitterStateSerializer((SimpleVersionedSerializer)SimpleVersionedStringSerializer.INSTANCE);
        byte[] serialize = streamingCommitterStateSerializer.serialize(expectedStreamingCommitterState);
        StreamingCommitterState streamingCommitterState = streamingCommitterStateSerializer.deserialize(streamingCommitterStateSerializer.getVersion(), serialize);
        MatcherAssert.assertThat((Object)streamingCommitterState.getCommittables(), (Matcher)CoreMatchers.equalTo((Object)expectedStreamingCommitterState.getCommittables()));
    }
}

