/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.operators.sink;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.StringSerializer;
import org.apache.flink.api.connector.sink.Committer;
import org.apache.flink.api.connector.sink.Sink;
import org.apache.flink.core.io.SimpleVersionedSerializer;
import org.apache.flink.runtime.checkpoint.OperatorSubtaskState;
import org.apache.flink.streaming.api.operators.OneInputStreamOperatorFactory;
import org.apache.flink.streaming.runtime.operators.sink.StreamingCommitterOperatorFactory;
import org.apache.flink.streaming.runtime.operators.sink.TestSink;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.streaming.util.OneInputStreamOperatorTestHarness;
import org.apache.flink.streaming.util.TestHarnessUtil;
import org.apache.flink.util.TestLogger;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;

public class StreamingCommitterOperatorTest
extends TestLogger {
    @Test(expected=IllegalStateException.class)
    public void throwExceptionWithoutSerializer() throws Exception {
        OneInputStreamOperatorTestHarness<String, String> testHarness = this.createTestHarness(new TestSink.DefaultCommitter(), null);
        testHarness.initializeEmptyState();
        testHarness.open();
    }

    @Test(expected=IllegalStateException.class)
    public void throwExceptionWithoutCommitter() throws Exception {
        OneInputStreamOperatorTestHarness<String, String> testHarness = this.createTestHarness(null, TestSink.StringCommittableSerializer.INSTANCE);
        testHarness.initializeEmptyState();
        testHarness.open();
    }

    @Test(expected=UnsupportedOperationException.class)
    public void doNotSupportRetry() throws Exception {
        List<String> input = Arrays.asList("lazy", "leaf");
        OneInputStreamOperatorTestHarness<String, String> testHarness = this.createTestHarness(new TestSink.AlwaysRetryCommitter());
        testHarness.initializeEmptyState();
        testHarness.open();
        testHarness.processElements(input.stream().map(StreamRecord::new).collect(Collectors.toList()));
        testHarness.snapshot(1L, 1L);
        testHarness.notifyOfCompletedCheckpoint(1L);
        testHarness.close();
    }

    @Test
    public void closeCommitter() throws Exception {
        TestSink.DefaultCommitter committer = new TestSink.DefaultCommitter();
        OneInputStreamOperatorTestHarness<String, String> testHarness = this.createTestHarness(committer);
        testHarness.initializeEmptyState();
        testHarness.open();
        testHarness.close();
        MatcherAssert.assertThat((Object)committer.isClosed(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void restoredFromMergedState() throws Exception {
        List<String> input1 = Arrays.asList("today", "whom");
        OperatorSubtaskState operatorSubtaskState1 = TestHarnessUtil.buildSubtaskState(this.createTestHarness(), input1);
        List<String> input2 = Arrays.asList("future", "evil", "how");
        OperatorSubtaskState operatorSubtaskState2 = TestHarnessUtil.buildSubtaskState(this.createTestHarness(), input2);
        TestSink.DefaultCommitter committer = new TestSink.DefaultCommitter();
        OneInputStreamOperatorTestHarness<String, String> testHarness = this.createTestHarness(committer);
        OperatorSubtaskState mergedOperatorSubtaskState = OneInputStreamOperatorTestHarness.repackageState(operatorSubtaskState1, operatorSubtaskState2);
        testHarness.initializeState(OneInputStreamOperatorTestHarness.repartitionOperatorState(mergedOperatorSubtaskState, 2, 2, 1, 0));
        testHarness.open();
        ArrayList<String> expectedOutput = new ArrayList<String>();
        expectedOutput.addAll(input1);
        expectedOutput.addAll(input2);
        testHarness.snapshot(1L, 1L);
        testHarness.notifyOfCompletedCheckpoint(1L);
        testHarness.close();
        MatcherAssert.assertThat(testHarness.getOutput(), (Matcher)Matchers.containsInAnyOrder((Object[])expectedOutput.stream().map(StreamRecord::new).toArray()));
        MatcherAssert.assertThat(committer.getCommittedData(), (Matcher)Matchers.containsInAnyOrder((Object[])expectedOutput.toArray()));
    }

    @Test
    public void commitMultipleStagesTogether() throws Exception {
        TestSink.DefaultCommitter committer = new TestSink.DefaultCommitter();
        List<String> input1 = Arrays.asList("cautious", "nature");
        List<String> input2 = Arrays.asList("count", "over");
        List<String> input3 = Arrays.asList("lawyer", "grammar");
        ArrayList<String> expectedOutput = new ArrayList<String>();
        expectedOutput.addAll(input1);
        expectedOutput.addAll(input2);
        expectedOutput.addAll(input3);
        OneInputStreamOperatorTestHarness<String, String> testHarness = this.createTestHarness(committer);
        testHarness.initializeEmptyState();
        testHarness.open();
        testHarness.processElements(input1.stream().map(StreamRecord::new).collect(Collectors.toList()));
        testHarness.snapshot(1L, 1L);
        testHarness.processElements(input2.stream().map(StreamRecord::new).collect(Collectors.toList()));
        testHarness.snapshot(2L, 2L);
        testHarness.processElements(input3.stream().map(StreamRecord::new).collect(Collectors.toList()));
        testHarness.snapshot(3L, 3L);
        testHarness.notifyOfCompletedCheckpoint(1L);
        testHarness.notifyOfCompletedCheckpoint(3L);
        testHarness.close();
        MatcherAssert.assertThat((Object)testHarness.getOutput().toArray(), (Matcher)Matchers.equalTo((Object)expectedOutput.stream().map(StreamRecord::new).toArray()));
        MatcherAssert.assertThat((Object)committer.getCommittedData().toArray(), (Matcher)Matchers.equalTo((Object)expectedOutput.toArray()));
    }

    private OneInputStreamOperatorTestHarness<String, String> createTestHarness() throws Exception {
        return this.createTestHarness(new TestSink.DefaultCommitter(), TestSink.StringCommittableSerializer.INSTANCE);
    }

    private OneInputStreamOperatorTestHarness<String, String> createTestHarness(Committer<String> committer) throws Exception {
        return this.createTestHarness(committer, TestSink.StringCommittableSerializer.INSTANCE);
    }

    private OneInputStreamOperatorTestHarness<String, String> createTestHarness(Committer<String> committer, SimpleVersionedSerializer<String> serializer) throws Exception {
        return new OneInputStreamOperatorTestHarness<String, String>((OneInputStreamOperatorFactory<String, String>)new StreamingCommitterOperatorFactory((Sink)TestSink.newBuilder().setCommitter(committer).setCommittableSerializer(serializer).build()), (TypeSerializer<String>)StringSerializer.INSTANCE);
    }
}

