/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.operators.sort;

import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import org.apache.flink.core.io.InputStatus;
import org.apache.flink.runtime.checkpoint.CheckpointException;
import org.apache.flink.runtime.checkpoint.channel.ChannelStateWriter;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.apache.flink.streaming.runtime.io.PushingAsyncDataInput;
import org.apache.flink.streaming.runtime.io.StreamTaskInput;
import org.apache.flink.streaming.runtime.streamrecord.StreamElement;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;

final class CollectionDataInput<E>
implements StreamTaskInput<E> {
    private final Iterator<StreamElement> elementsIterator;
    private final int inputIdx;

    CollectionDataInput(Collection<StreamElement> elements) {
        this(elements, 0);
    }

    CollectionDataInput(Collection<StreamElement> elements, int inputIdx) {
        this.elementsIterator = elements.iterator();
        this.inputIdx = inputIdx;
    }

    public InputStatus emitNext(PushingAsyncDataInput.DataOutput<E> output) throws Exception {
        if (this.elementsIterator.hasNext()) {
            StreamElement streamElement = this.elementsIterator.next();
            if (streamElement instanceof StreamRecord) {
                output.emitRecord(streamElement.asRecord());
            } else if (streamElement instanceof Watermark) {
                output.emitWatermark(streamElement.asWatermark());
            } else {
                throw new IllegalStateException("Unsupported element type: " + streamElement);
            }
        }
        return this.elementsIterator.hasNext() ? InputStatus.MORE_AVAILABLE : InputStatus.END_OF_INPUT;
    }

    public CompletableFuture<?> getAvailableFuture() {
        return CompletableFuture.completedFuture(null);
    }

    public int getInputIndex() {
        return this.inputIdx;
    }

    public CompletableFuture<Void> prepareSnapshot(ChannelStateWriter channelStateWriter, long checkpointId) throws CheckpointException {
        return null;
    }

    public void close() throws IOException {
    }
}

