/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.operators;

import java.util.ArrayList;
import java.util.List;
import org.apache.flink.api.java.tuple.Tuple4;
import org.apache.flink.streaming.api.functions.sink.SinkFunction;
import org.apache.flink.streaming.api.operators.StreamSink;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.streaming.util.OneInputStreamOperatorTestHarness;
import org.apache.flink.util.TestLogger;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class StreamSinkOperatorTest
extends TestLogger {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void testTimeQuerying() throws Exception {
        BufferingQueryingSink bufferingSink = new BufferingQueryingSink();
        StreamSink operator = new StreamSink(bufferingSink);
        OneInputStreamOperatorTestHarness testHarness = new OneInputStreamOperatorTestHarness(operator);
        testHarness.setup();
        testHarness.open();
        testHarness.processWatermark(new Watermark(17L));
        testHarness.setProcessingTime(12L);
        testHarness.processElement(new StreamRecord((Object)"Hello", 12L));
        testHarness.processWatermark(new Watermark(42L));
        testHarness.setProcessingTime(15L);
        testHarness.processElement(new StreamRecord((Object)"Ciao", 13L));
        testHarness.processWatermark(new Watermark(42L));
        testHarness.setProcessingTime(15L);
        testHarness.processElement(new StreamRecord((Object)"Ciao"));
        Assert.assertThat((Object)bufferingSink.data.size(), (Matcher)CoreMatchers.is((Object)3));
        Assert.assertThat((Object)bufferingSink.data, (Matcher)Matchers.contains((Object[])new Tuple4[]{new Tuple4((Object)17L, (Object)12L, (Object)12L, (Object)"Hello"), new Tuple4((Object)42L, (Object)15L, (Object)13L, (Object)"Ciao"), new Tuple4((Object)42L, (Object)15L, null, (Object)"Ciao")}));
        testHarness.close();
    }

    private static class BufferingQueryingSink<T>
    implements SinkFunction<T> {
        private final List<Tuple4<Long, Long, Long, T>> data = new ArrayList<Tuple4<Long, Long, Long, T>>();

        public void invoke(T value, SinkFunction.Context context) throws Exception {
            Long timestamp = context.timestamp();
            if (timestamp != null) {
                this.data.add(new Tuple4((Object)context.currentWatermark(), (Object)context.currentProcessingTime(), (Object)context.timestamp(), value));
            } else {
                this.data.add(new Tuple4((Object)context.currentWatermark(), (Object)context.currentProcessingTime(), null, value));
            }
        }
    }
}

