/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.pulsar.source.reader.message;

import org.apache.flink.connector.base.source.reader.RecordsBySplits;
import org.apache.flink.connector.pulsar.source.reader.message.PulsarMessage;
import org.apache.flink.util.Collector;
import org.apache.pulsar.client.api.Message;

public class PulsarMessageCollector<T>
implements Collector<T> {
    private final String splitId;
    private final RecordsBySplits.Builder<PulsarMessage<T>> builder;
    private Message<?> message;

    public PulsarMessageCollector(String splitId, RecordsBySplits.Builder<PulsarMessage<T>> builder) {
        this.splitId = splitId;
        this.builder = builder;
    }

    public void setMessage(Message<?> message) {
        this.message = message;
    }

    public void collect(T t) {
        PulsarMessage<T> result = new PulsarMessage<T>(this.message.getMessageId(), t, this.message.getEventTime());
        this.builder.add(this.splitId, result);
    }

    public void close() {
    }
}

