/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.pulsar.source.enumerator.topic.range;

import java.util.List;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.connector.pulsar.source.enumerator.topic.TopicMetadata;
import org.apache.flink.connector.pulsar.source.enumerator.topic.TopicRange;
import org.apache.flink.connector.pulsar.source.enumerator.topic.range.RangeGenerator;
import org.apache.flink.connector.pulsar.source.enumerator.topic.range.TopicRangeUtils;

@PublicEvolving
public class FixedRangeGenerator
implements RangeGenerator {
    private static final long serialVersionUID = -3895203007855538734L;
    private final List<TopicRange> ranges;
    private final RangeGenerator.KeySharedMode sharedMode;

    public FixedRangeGenerator(List<TopicRange> ranges) {
        this(ranges, RangeGenerator.KeySharedMode.JOIN);
    }

    public FixedRangeGenerator(List<TopicRange> ranges, RangeGenerator.KeySharedMode sharedMode) {
        TopicRangeUtils.validateTopicRanges(ranges, sharedMode);
        this.ranges = ranges;
        this.sharedMode = sharedMode;
    }

    @Override
    public List<TopicRange> range(TopicMetadata metadata, int parallelism) {
        return this.ranges;
    }

    @Override
    public RangeGenerator.KeySharedMode keyShareMode(TopicMetadata metadata, int parallelism) {
        return this.sharedMode;
    }
}

