/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.pulsar.source.enumerator.cursor;

import org.apache.flink.annotation.Internal;
import org.apache.flink.util.Preconditions;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.impl.BatchMessageIdImpl;
import org.apache.pulsar.client.impl.MessageIdImpl;

@Internal
public final class MessageIdUtils {
    private MessageIdUtils() {
    }

    public static MessageId nextMessageId(MessageId messageId) {
        MessageIdImpl idImpl = MessageIdUtils.unwrapMessageId(messageId);
        long ledgerId = idImpl.getLedgerId();
        long entryId = idImpl.getEntryId();
        int partitionIndex = idImpl.getPartitionIndex();
        if (entryId < 0L) {
            return new MessageIdImpl(ledgerId, 0L, partitionIndex);
        }
        return new MessageIdImpl(ledgerId, entryId + 1L, partitionIndex);
    }

    public static MessageIdImpl unwrapMessageId(MessageId messageId) {
        MessageIdImpl idImpl = MessageIdImpl.convertToMessageIdImpl(messageId);
        if (idImpl instanceof BatchMessageIdImpl) {
            int batchSize = ((BatchMessageIdImpl)idImpl).getBatchSize();
            Preconditions.checkArgument((batchSize <= 1 ? 1 : 0) != 0, (String)"We only support normal message id currently. This batch size is %d", (Object[])new Object[]{batchSize});
        }
        return idImpl;
    }
}

