/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.pulsar.common.utils;

import org.apache.flink.annotation.Internal;
import org.apache.flink.util.function.SupplierWithException;
import org.apache.flink.util.function.ThrowingRunnable;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.client.api.PulsarClientException;

@Internal
public final class PulsarExceptionUtils {
    private PulsarExceptionUtils() {
    }

    public static <R extends PulsarClientException> void sneakyClient(ThrowingRunnable<R> runnable) {
        PulsarExceptionUtils.sneaky(runnable);
    }

    public static <T, R extends PulsarClientException> T sneakyClient(SupplierWithException<T, R> supplier) {
        return PulsarExceptionUtils.sneaky(supplier);
    }

    public static <R extends PulsarAdminException> void sneakyAdmin(ThrowingRunnable<R> runnable) {
        PulsarExceptionUtils.sneaky(runnable);
    }

    public static <T, R extends PulsarAdminException> T sneakyAdmin(SupplierWithException<T, R> supplier) {
        return PulsarExceptionUtils.sneaky(supplier);
    }

    private static <R extends Exception> void sneaky(ThrowingRunnable<R> runnable) {
        try {
            runnable.run();
        }
        catch (Exception r) {
            PulsarExceptionUtils.sneakyThrow(r);
        }
    }

    private static <T, R extends Exception> T sneaky(SupplierWithException<T, R> supplier) {
        try {
            return (T)supplier.get();
        }
        catch (Exception r) {
            PulsarExceptionUtils.sneakyThrow(r);
            throw new RuntimeException("Never throw here.");
        }
    }

    public static <T extends Exception> void sneakyThrow(Exception t) throws T {
        throw t;
    }
}

