/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.webmonitor.handlers;

import java.nio.file.Path;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.client.deployment.application.ApplicationRunner;
import org.apache.flink.client.program.PackagedProgram;
import org.apache.flink.client.program.ProgramInvocationException;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.DeploymentOptions;
import org.apache.flink.runtime.dispatcher.DispatcherGateway;
import org.apache.flink.runtime.jobgraph.SavepointRestoreSettings;
import org.apache.flink.runtime.rest.handler.AbstractRestHandler;
import org.apache.flink.runtime.rest.handler.HandlerRequest;
import org.apache.flink.runtime.rest.handler.RestHandlerException;
import org.apache.flink.runtime.rest.handler.util.HandlerRequestUtils;
import org.apache.flink.runtime.rest.messages.MessageHeaders;
import org.apache.flink.runtime.webmonitor.handlers.AllowNonRestoredStateQueryParameter;
import org.apache.flink.runtime.webmonitor.handlers.JarRunMessageParameters;
import org.apache.flink.runtime.webmonitor.handlers.JarRunRequestBody;
import org.apache.flink.runtime.webmonitor.handlers.JarRunResponseBody;
import org.apache.flink.runtime.webmonitor.handlers.SavepointPathQueryParameter;
import org.apache.flink.runtime.webmonitor.handlers.utils.JarHandlerUtils;
import org.apache.flink.runtime.webmonitor.retriever.GatewayRetriever;
import org.apache.flink.shaded.guava18.com.google.common.base.Strings;
import org.slf4j.Logger;

public class JarRunHandler
extends AbstractRestHandler<DispatcherGateway, JarRunRequestBody, JarRunResponseBody, JarRunMessageParameters> {
    private final Path jarDir;
    private final Configuration configuration;
    private final ApplicationRunner applicationRunner;
    private final Executor executor;

    public JarRunHandler(GatewayRetriever<? extends DispatcherGateway> leaderRetriever, Time timeout, Map<String, String> responseHeaders, MessageHeaders<JarRunRequestBody, JarRunResponseBody, JarRunMessageParameters> messageHeaders, Path jarDir, Configuration configuration, Executor executor, Supplier<ApplicationRunner> applicationRunnerSupplier) {
        super(leaderRetriever, timeout, responseHeaders, messageHeaders);
        this.jarDir = Objects.requireNonNull(jarDir);
        this.configuration = Objects.requireNonNull(configuration);
        this.executor = Objects.requireNonNull(executor);
        this.applicationRunner = applicationRunnerSupplier.get();
    }

    protected CompletableFuture<JarRunResponseBody> handleRequest(@Nonnull HandlerRequest<JarRunRequestBody, JarRunMessageParameters> request, @Nonnull DispatcherGateway gateway) throws RestHandlerException {
        Configuration effectiveConfiguration = new Configuration(this.configuration);
        effectiveConfiguration.set(DeploymentOptions.ATTACHED, (Object)false);
        effectiveConfiguration.set(DeploymentOptions.TARGET, (Object)"embedded");
        JarHandlerUtils.JarHandlerContext context = JarHandlerUtils.JarHandlerContext.fromRequest(request, this.jarDir, this.log);
        context.applyToConfiguration(effectiveConfiguration);
        SavepointRestoreSettings.toConfiguration((SavepointRestoreSettings)this.getSavepointRestoreSettings(request), (Configuration)effectiveConfiguration);
        PackagedProgram program = context.toPackagedProgram(effectiveConfiguration);
        return CompletableFuture.supplyAsync(() -> this.applicationRunner.run(gateway, program, effectiveConfiguration), this.executor).thenApply(jobIds -> {
            if (jobIds.isEmpty()) {
                throw new CompletionException(new ProgramInvocationException("No jobs submitted."));
            }
            return new JarRunResponseBody((JobID)jobIds.get(0));
        });
    }

    private SavepointRestoreSettings getSavepointRestoreSettings(@Nonnull HandlerRequest<JarRunRequestBody, JarRunMessageParameters> request) throws RestHandlerException {
        JarRunRequestBody requestBody = (JarRunRequestBody)request.getRequestBody();
        boolean allowNonRestoredState = (Boolean)HandlerRequestUtils.fromRequestBodyOrQueryParameter((Object)requestBody.getAllowNonRestoredState(), () -> (Boolean)HandlerRequestUtils.getQueryParameter((HandlerRequest)request, AllowNonRestoredStateQueryParameter.class), (Object)false, (Logger)this.log);
        String savepointPath = (String)HandlerRequestUtils.fromRequestBodyOrQueryParameter((Object)Strings.emptyToNull((String)requestBody.getSavepointPath()), () -> Strings.emptyToNull((String)((String)HandlerRequestUtils.getQueryParameter((HandlerRequest)request, SavepointPathQueryParameter.class))), null, (Logger)this.log);
        SavepointRestoreSettings savepointRestoreSettings = savepointPath != null ? SavepointRestoreSettings.forPath((String)savepointPath, (boolean)allowNonRestoredState) : SavepointRestoreSettings.none();
        return savepointRestoreSettings;
    }
}

