/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.io.jdbc.split;

import java.io.Serializable;
import org.apache.flink.api.java.io.jdbc.split.ParameterValuesProvider;

public class NumericBetweenParametersProvider
implements ParameterValuesProvider {
    private long fetchSize;
    private final long min;
    private final long max;

    public NumericBetweenParametersProvider(long fetchSize, long min, long max) {
        this.fetchSize = fetchSize;
        this.min = min;
        this.max = max;
    }

    @Override
    public Serializable[][] getParameterValues() {
        double maxElemCount = this.max - this.min + 1L;
        int size = new Double(Math.ceil(maxElemCount / (double)this.fetchSize)).intValue();
        Serializable[][] parameters = new Serializable[size][2];
        int count = 0;
        long i = this.min;
        while (i < this.max) {
            long currentLimit = i + this.fetchSize - 1L;
            parameters[count] = new Long[]{i, currentLimit};
            if (currentLimit + 1L + this.fetchSize > this.max) {
                parameters[count + 1] = new Long[]{currentLimit + 1L, this.max};
                break;
            }
            i += this.fetchSize;
            ++count;
        }
        return parameters;
    }
}

