/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.operators;

import java.util.Arrays;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.Public;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.InvalidProgramException;
import org.apache.flink.api.common.functions.FlatJoinFunction;
import org.apache.flink.api.common.functions.JoinFunction;
import org.apache.flink.api.common.functions.Partitioner;
import org.apache.flink.api.common.functions.RichFlatJoinFunction;
import org.apache.flink.api.common.operators.BinaryOperatorInformation;
import org.apache.flink.api.common.operators.DualInputSemanticProperties;
import org.apache.flink.api.common.operators.Keys;
import org.apache.flink.api.common.operators.Operator;
import org.apache.flink.api.common.operators.base.InnerJoinOperatorBase;
import org.apache.flink.api.common.operators.base.JoinOperatorBase;
import org.apache.flink.api.common.operators.base.OuterJoinOperatorBase;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.Utils;
import org.apache.flink.api.java.functions.FunctionAnnotation;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.api.java.functions.SemanticPropUtil;
import org.apache.flink.api.java.operators.DeltaIteration;
import org.apache.flink.api.java.operators.KeyFunctions;
import org.apache.flink.api.java.operators.TwoInputUdfOperator;
import org.apache.flink.api.java.operators.join.JoinFunctionAssigner;
import org.apache.flink.api.java.operators.join.JoinOperatorSetsBase;
import org.apache.flink.api.java.operators.join.JoinType;
import org.apache.flink.api.java.operators.translation.TupleLeftUnwrappingJoiner;
import org.apache.flink.api.java.operators.translation.TupleRightUnwrappingJoiner;
import org.apache.flink.api.java.operators.translation.TupleUnwrappingJoiner;
import org.apache.flink.api.java.operators.translation.WrappingFunction;
import org.apache.flink.api.java.tuple.Tuple;
import org.apache.flink.api.java.tuple.Tuple1;
import org.apache.flink.api.java.tuple.Tuple10;
import org.apache.flink.api.java.tuple.Tuple11;
import org.apache.flink.api.java.tuple.Tuple12;
import org.apache.flink.api.java.tuple.Tuple13;
import org.apache.flink.api.java.tuple.Tuple14;
import org.apache.flink.api.java.tuple.Tuple15;
import org.apache.flink.api.java.tuple.Tuple16;
import org.apache.flink.api.java.tuple.Tuple17;
import org.apache.flink.api.java.tuple.Tuple18;
import org.apache.flink.api.java.tuple.Tuple19;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.tuple.Tuple20;
import org.apache.flink.api.java.tuple.Tuple21;
import org.apache.flink.api.java.tuple.Tuple22;
import org.apache.flink.api.java.tuple.Tuple23;
import org.apache.flink.api.java.tuple.Tuple24;
import org.apache.flink.api.java.tuple.Tuple25;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.flink.api.java.tuple.Tuple4;
import org.apache.flink.api.java.tuple.Tuple5;
import org.apache.flink.api.java.tuple.Tuple6;
import org.apache.flink.api.java.tuple.Tuple7;
import org.apache.flink.api.java.tuple.Tuple8;
import org.apache.flink.api.java.tuple.Tuple9;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.util.Collector;
import org.apache.flink.util.Preconditions;

@Public
public abstract class JoinOperator<I1, I2, OUT>
extends TwoInputUdfOperator<I1, I2, OUT, JoinOperator<I1, I2, OUT>> {
    protected final Keys<I1> keys1;
    protected final Keys<I2> keys2;
    private final JoinOperatorBase.JoinHint joinHint;
    protected final JoinType joinType;
    private Partitioner<?> customPartitioner;

    protected JoinOperator(DataSet<I1> input1, DataSet<I2> input2, Keys<I1> keys1, Keys<I2> keys2, TypeInformation<OUT> returnType, JoinOperatorBase.JoinHint hint, JoinType type) {
        super(input1, input2, returnType);
        int[] positions;
        Preconditions.checkNotNull(keys1);
        Preconditions.checkNotNull(keys2);
        try {
            if (!keys1.areCompatible(keys2)) {
                throw new InvalidProgramException("The types of the key fields do not match.");
            }
        }
        catch (Keys.IncompatibleKeysException ike) {
            throw new InvalidProgramException("The types of the key fields do not match: " + ike.getMessage(), (Throwable)ike);
        }
        if (input1 instanceof DeltaIteration.SolutionSetPlaceHolder) {
            if (keys1 instanceof Keys.ExpressionKeys) {
                positions = keys1.computeLogicalKeyPositions();
                ((DeltaIteration.SolutionSetPlaceHolder)input1).checkJoinKeyFields(positions);
            } else {
                throw new InvalidProgramException("Currently, the solution set may only be joined with using tuple field positions.");
            }
        }
        if (input2 instanceof DeltaIteration.SolutionSetPlaceHolder) {
            if (keys2 instanceof Keys.ExpressionKeys) {
                positions = keys2.computeLogicalKeyPositions();
                ((DeltaIteration.SolutionSetPlaceHolder)input2).checkJoinKeyFields(positions);
            } else {
                throw new InvalidProgramException("Currently, the solution set may only be joined with using tuple field positions.");
            }
        }
        this.keys1 = keys1;
        this.keys2 = keys2;
        this.joinHint = hint == null ? JoinOperatorBase.JoinHint.OPTIMIZER_CHOOSES : hint;
        this.joinType = type;
    }

    protected Keys<I1> getKeys1() {
        return this.keys1;
    }

    protected Keys<I2> getKeys2() {
        return this.keys2;
    }

    @Internal
    public JoinOperatorBase.JoinHint getJoinHint() {
        return this.joinHint;
    }

    @Internal
    public JoinType getJoinType() {
        return this.joinType;
    }

    public JoinOperator<I1, I2, OUT> withPartitioner(Partitioner<?> partitioner) {
        if (partitioner != null) {
            this.keys1.validateCustomPartitioner(partitioner, null);
            this.keys2.validateCustomPartitioner(partitioner, null);
        }
        this.customPartitioner = this.getInput1().clean(partitioner);
        return this;
    }

    @Internal
    public Partitioner<?> getPartitioner() {
        return this.customPartitioner;
    }

    @Internal
    private static final class JoinProjection<I1, I2> {
        private final DataSet<I1> ds1;
        private final DataSet<I2> ds2;
        private final Keys<I1> keys1;
        private final Keys<I2> keys2;
        private final JoinOperatorBase.JoinHint hint;
        private int[] fieldIndexes;
        private boolean[] isFieldInFirst;
        private final int numFieldsDs1;
        private final int numFieldsDs2;

        public JoinProjection(DataSet<I1> ds1, DataSet<I2> ds2, Keys<I1> keys1, Keys<I2> keys2, JoinOperatorBase.JoinHint hint, int[] firstFieldIndexes, int[] secondFieldIndexes) {
            boolean isTuple;
            boolean firstInput;
            boolean isSecondTuple;
            boolean isFirstTuple;
            this.ds1 = ds1;
            this.ds2 = ds2;
            this.keys1 = keys1;
            this.keys2 = keys2;
            this.hint = hint;
            if (ds1.getType() instanceof TupleTypeInfo) {
                this.numFieldsDs1 = ds1.getType().getArity();
                isFirstTuple = true;
            } else {
                this.numFieldsDs1 = 1;
                isFirstTuple = false;
            }
            if (ds2.getType() instanceof TupleTypeInfo) {
                this.numFieldsDs2 = ds2.getType().getArity();
                isSecondTuple = true;
            } else {
                this.numFieldsDs2 = 1;
                isSecondTuple = false;
            }
            if (firstFieldIndexes != null && secondFieldIndexes == null) {
                firstInput = true;
                isTuple = isFirstTuple;
                this.fieldIndexes = firstFieldIndexes;
                if (this.fieldIndexes.length == 0) {
                    isTuple = false;
                }
            } else if (firstFieldIndexes == null && secondFieldIndexes != null) {
                firstInput = false;
                isTuple = isSecondTuple;
                this.fieldIndexes = secondFieldIndexes;
                if (this.fieldIndexes.length == 0) {
                    isTuple = false;
                }
            } else {
                if (firstFieldIndexes == null && secondFieldIndexes == null) {
                    throw new IllegalArgumentException("You must provide at least one field index array.");
                }
                throw new IllegalArgumentException("You must provide at most one field index array.");
            }
            if (!isTuple && this.fieldIndexes.length != 0) {
                throw new IllegalArgumentException("Input is not a Tuple. Call projectFirst() (or projectSecond()) without arguments to include it.");
            }
            if (this.fieldIndexes.length > 22) {
                throw new IllegalArgumentException("You may select only up to twenty-two (22) fields.");
            }
            if (isTuple) {
                this.isFieldInFirst = new boolean[this.fieldIndexes.length];
                int maxFieldIndex = firstInput ? this.numFieldsDs1 : this.numFieldsDs2;
                for (int i = 0; i < this.fieldIndexes.length; ++i) {
                    Preconditions.checkElementIndex((int)this.fieldIndexes[i], (int)maxFieldIndex);
                    this.isFieldInFirst[i] = firstInput;
                }
            } else {
                this.isFieldInFirst = new boolean[]{firstInput};
                this.fieldIndexes = new int[]{-1};
            }
        }

        protected JoinProjection<I1, I2> projectFirst(int ... firstFieldIndexes) {
            boolean isFirstTuple;
            boolean bl = isFirstTuple = this.ds1.getType() instanceof TupleTypeInfo && firstFieldIndexes.length > 0;
            if (!isFirstTuple && firstFieldIndexes.length != 0) {
                throw new IllegalArgumentException("Input is not a Tuple. Call projectFirst() without arguments to include it.");
            }
            if (firstFieldIndexes.length > 22 - this.fieldIndexes.length) {
                throw new IllegalArgumentException("You may select only up to twenty-two (22) fields in total.");
            }
            int offset = this.fieldIndexes.length;
            if (isFirstTuple) {
                this.fieldIndexes = Arrays.copyOf(this.fieldIndexes, this.fieldIndexes.length + firstFieldIndexes.length);
                this.isFieldInFirst = Arrays.copyOf(this.isFieldInFirst, this.isFieldInFirst.length + firstFieldIndexes.length);
                int maxFieldIndex = this.numFieldsDs1;
                for (int i = 0; i < firstFieldIndexes.length; ++i) {
                    Preconditions.checkElementIndex((int)firstFieldIndexes[i], (int)maxFieldIndex);
                    this.isFieldInFirst[offset + i] = true;
                    this.fieldIndexes[offset + i] = firstFieldIndexes[i];
                }
            } else {
                this.fieldIndexes = Arrays.copyOf(this.fieldIndexes, this.fieldIndexes.length + 1);
                this.isFieldInFirst = Arrays.copyOf(this.isFieldInFirst, this.isFieldInFirst.length + 1);
                this.isFieldInFirst[offset] = true;
                this.fieldIndexes[offset] = -1;
            }
            return this;
        }

        protected JoinProjection<I1, I2> projectSecond(int ... secondFieldIndexes) {
            boolean isSecondTuple;
            boolean bl = isSecondTuple = this.ds2.getType() instanceof TupleTypeInfo && secondFieldIndexes.length > 0;
            if (!isSecondTuple && secondFieldIndexes.length != 0) {
                throw new IllegalArgumentException("Input is not a Tuple. Call projectSecond() without arguments to include it.");
            }
            if (secondFieldIndexes.length > 22 - this.fieldIndexes.length) {
                throw new IllegalArgumentException("You may select only up to twenty-two (22) fields in total.");
            }
            int offset = this.fieldIndexes.length;
            if (isSecondTuple) {
                this.fieldIndexes = Arrays.copyOf(this.fieldIndexes, this.fieldIndexes.length + secondFieldIndexes.length);
                this.isFieldInFirst = Arrays.copyOf(this.isFieldInFirst, this.isFieldInFirst.length + secondFieldIndexes.length);
                int maxFieldIndex = this.numFieldsDs2;
                for (int i = 0; i < secondFieldIndexes.length; ++i) {
                    Preconditions.checkElementIndex((int)secondFieldIndexes[i], (int)maxFieldIndex);
                    this.isFieldInFirst[offset + i] = false;
                    this.fieldIndexes[offset + i] = secondFieldIndexes[i];
                }
            } else {
                this.fieldIndexes = Arrays.copyOf(this.fieldIndexes, this.fieldIndexes.length + 1);
                this.isFieldInFirst = Arrays.copyOf(this.isFieldInFirst, this.isFieldInFirst.length + 1);
                this.isFieldInFirst[offset] = false;
                this.fieldIndexes[offset] = -1;
            }
            return this;
        }

        public <OUT extends Tuple> ProjectJoin<I1, I2, OUT> projectTupleX() {
            ProjectJoin projectJoin = null;
            switch (this.fieldIndexes.length) {
                case 1: {
                    projectJoin = this.projectTuple1();
                    break;
                }
                case 2: {
                    projectJoin = this.projectTuple2();
                    break;
                }
                case 3: {
                    projectJoin = this.projectTuple3();
                    break;
                }
                case 4: {
                    projectJoin = this.projectTuple4();
                    break;
                }
                case 5: {
                    projectJoin = this.projectTuple5();
                    break;
                }
                case 6: {
                    projectJoin = this.projectTuple6();
                    break;
                }
                case 7: {
                    projectJoin = this.projectTuple7();
                    break;
                }
                case 8: {
                    projectJoin = this.projectTuple8();
                    break;
                }
                case 9: {
                    projectJoin = this.projectTuple9();
                    break;
                }
                case 10: {
                    projectJoin = this.projectTuple10();
                    break;
                }
                case 11: {
                    projectJoin = this.projectTuple11();
                    break;
                }
                case 12: {
                    projectJoin = this.projectTuple12();
                    break;
                }
                case 13: {
                    projectJoin = this.projectTuple13();
                    break;
                }
                case 14: {
                    projectJoin = this.projectTuple14();
                    break;
                }
                case 15: {
                    projectJoin = this.projectTuple15();
                    break;
                }
                case 16: {
                    projectJoin = this.projectTuple16();
                    break;
                }
                case 17: {
                    projectJoin = this.projectTuple17();
                    break;
                }
                case 18: {
                    projectJoin = this.projectTuple18();
                    break;
                }
                case 19: {
                    projectJoin = this.projectTuple19();
                    break;
                }
                case 20: {
                    projectJoin = this.projectTuple20();
                    break;
                }
                case 21: {
                    projectJoin = this.projectTuple21();
                    break;
                }
                case 22: {
                    projectJoin = this.projectTuple22();
                    break;
                }
                case 23: {
                    projectJoin = this.projectTuple23();
                    break;
                }
                case 24: {
                    projectJoin = this.projectTuple24();
                    break;
                }
                case 25: {
                    projectJoin = this.projectTuple25();
                    break;
                }
                default: {
                    throw new IllegalStateException("Excessive arity in tuple.");
                }
            }
            return projectJoin;
        }

        public <T0> ProjectJoin<I1, I2, Tuple1<T0>> projectTuple1() {
            TypeInformation<?>[] fTypes = this.extractFieldTypes(this.fieldIndexes);
            TupleTypeInfo tType = new TupleTypeInfo(fTypes);
            return new ProjectJoin(this.ds1, this.ds2, this.keys1, this.keys2, this.hint, this.fieldIndexes, this.isFieldInFirst, tType, this);
        }

        public <T0, T1> ProjectJoin<I1, I2, Tuple2<T0, T1>> projectTuple2() {
            TypeInformation<?>[] fTypes = this.extractFieldTypes(this.fieldIndexes);
            TupleTypeInfo tType = new TupleTypeInfo(fTypes);
            return new ProjectJoin(this.ds1, this.ds2, this.keys1, this.keys2, this.hint, this.fieldIndexes, this.isFieldInFirst, tType, this);
        }

        public <T0, T1, T2> ProjectJoin<I1, I2, Tuple3<T0, T1, T2>> projectTuple3() {
            TypeInformation<?>[] fTypes = this.extractFieldTypes(this.fieldIndexes);
            TupleTypeInfo tType = new TupleTypeInfo(fTypes);
            return new ProjectJoin(this.ds1, this.ds2, this.keys1, this.keys2, this.hint, this.fieldIndexes, this.isFieldInFirst, tType, this);
        }

        public <T0, T1, T2, T3> ProjectJoin<I1, I2, Tuple4<T0, T1, T2, T3>> projectTuple4() {
            TypeInformation<?>[] fTypes = this.extractFieldTypes(this.fieldIndexes);
            TupleTypeInfo tType = new TupleTypeInfo(fTypes);
            return new ProjectJoin(this.ds1, this.ds2, this.keys1, this.keys2, this.hint, this.fieldIndexes, this.isFieldInFirst, tType, this);
        }

        public <T0, T1, T2, T3, T4> ProjectJoin<I1, I2, Tuple5<T0, T1, T2, T3, T4>> projectTuple5() {
            TypeInformation<?>[] fTypes = this.extractFieldTypes(this.fieldIndexes);
            TupleTypeInfo tType = new TupleTypeInfo(fTypes);
            return new ProjectJoin(this.ds1, this.ds2, this.keys1, this.keys2, this.hint, this.fieldIndexes, this.isFieldInFirst, tType, this);
        }

        public <T0, T1, T2, T3, T4, T5> ProjectJoin<I1, I2, Tuple6<T0, T1, T2, T3, T4, T5>> projectTuple6() {
            TypeInformation<?>[] fTypes = this.extractFieldTypes(this.fieldIndexes);
            TupleTypeInfo tType = new TupleTypeInfo(fTypes);
            return new ProjectJoin(this.ds1, this.ds2, this.keys1, this.keys2, this.hint, this.fieldIndexes, this.isFieldInFirst, tType, this);
        }

        public <T0, T1, T2, T3, T4, T5, T6> ProjectJoin<I1, I2, Tuple7<T0, T1, T2, T3, T4, T5, T6>> projectTuple7() {
            TypeInformation<?>[] fTypes = this.extractFieldTypes(this.fieldIndexes);
            TupleTypeInfo tType = new TupleTypeInfo(fTypes);
            return new ProjectJoin(this.ds1, this.ds2, this.keys1, this.keys2, this.hint, this.fieldIndexes, this.isFieldInFirst, tType, this);
        }

        public <T0, T1, T2, T3, T4, T5, T6, T7> ProjectJoin<I1, I2, Tuple8<T0, T1, T2, T3, T4, T5, T6, T7>> projectTuple8() {
            TypeInformation<?>[] fTypes = this.extractFieldTypes(this.fieldIndexes);
            TupleTypeInfo tType = new TupleTypeInfo(fTypes);
            return new ProjectJoin(this.ds1, this.ds2, this.keys1, this.keys2, this.hint, this.fieldIndexes, this.isFieldInFirst, tType, this);
        }

        public <T0, T1, T2, T3, T4, T5, T6, T7, T8> ProjectJoin<I1, I2, Tuple9<T0, T1, T2, T3, T4, T5, T6, T7, T8>> projectTuple9() {
            TypeInformation<?>[] fTypes = this.extractFieldTypes(this.fieldIndexes);
            TupleTypeInfo tType = new TupleTypeInfo(fTypes);
            return new ProjectJoin(this.ds1, this.ds2, this.keys1, this.keys2, this.hint, this.fieldIndexes, this.isFieldInFirst, tType, this);
        }

        public <T0, T1, T2, T3, T4, T5, T6, T7, T8, T9> ProjectJoin<I1, I2, Tuple10<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9>> projectTuple10() {
            TypeInformation<?>[] fTypes = this.extractFieldTypes(this.fieldIndexes);
            TupleTypeInfo tType = new TupleTypeInfo(fTypes);
            return new ProjectJoin(this.ds1, this.ds2, this.keys1, this.keys2, this.hint, this.fieldIndexes, this.isFieldInFirst, tType, this);
        }

        public <T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10> ProjectJoin<I1, I2, Tuple11<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10>> projectTuple11() {
            TypeInformation<?>[] fTypes = this.extractFieldTypes(this.fieldIndexes);
            TupleTypeInfo tType = new TupleTypeInfo(fTypes);
            return new ProjectJoin(this.ds1, this.ds2, this.keys1, this.keys2, this.hint, this.fieldIndexes, this.isFieldInFirst, tType, this);
        }

        public <T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11> ProjectJoin<I1, I2, Tuple12<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11>> projectTuple12() {
            TypeInformation<?>[] fTypes = this.extractFieldTypes(this.fieldIndexes);
            TupleTypeInfo tType = new TupleTypeInfo(fTypes);
            return new ProjectJoin(this.ds1, this.ds2, this.keys1, this.keys2, this.hint, this.fieldIndexes, this.isFieldInFirst, tType, this);
        }

        public <T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12> ProjectJoin<I1, I2, Tuple13<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12>> projectTuple13() {
            TypeInformation<?>[] fTypes = this.extractFieldTypes(this.fieldIndexes);
            TupleTypeInfo tType = new TupleTypeInfo(fTypes);
            return new ProjectJoin(this.ds1, this.ds2, this.keys1, this.keys2, this.hint, this.fieldIndexes, this.isFieldInFirst, tType, this);
        }

        public <T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13> ProjectJoin<I1, I2, Tuple14<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13>> projectTuple14() {
            TypeInformation<?>[] fTypes = this.extractFieldTypes(this.fieldIndexes);
            TupleTypeInfo tType = new TupleTypeInfo(fTypes);
            return new ProjectJoin(this.ds1, this.ds2, this.keys1, this.keys2, this.hint, this.fieldIndexes, this.isFieldInFirst, tType, this);
        }

        public <T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14> ProjectJoin<I1, I2, Tuple15<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14>> projectTuple15() {
            TypeInformation<?>[] fTypes = this.extractFieldTypes(this.fieldIndexes);
            TupleTypeInfo tType = new TupleTypeInfo(fTypes);
            return new ProjectJoin(this.ds1, this.ds2, this.keys1, this.keys2, this.hint, this.fieldIndexes, this.isFieldInFirst, tType, this);
        }

        public <T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15> ProjectJoin<I1, I2, Tuple16<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15>> projectTuple16() {
            TypeInformation<?>[] fTypes = this.extractFieldTypes(this.fieldIndexes);
            TupleTypeInfo tType = new TupleTypeInfo(fTypes);
            return new ProjectJoin(this.ds1, this.ds2, this.keys1, this.keys2, this.hint, this.fieldIndexes, this.isFieldInFirst, tType, this);
        }

        public <T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16> ProjectJoin<I1, I2, Tuple17<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16>> projectTuple17() {
            TypeInformation<?>[] fTypes = this.extractFieldTypes(this.fieldIndexes);
            TupleTypeInfo tType = new TupleTypeInfo(fTypes);
            return new ProjectJoin(this.ds1, this.ds2, this.keys1, this.keys2, this.hint, this.fieldIndexes, this.isFieldInFirst, tType, this);
        }

        public <T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17> ProjectJoin<I1, I2, Tuple18<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17>> projectTuple18() {
            TypeInformation<?>[] fTypes = this.extractFieldTypes(this.fieldIndexes);
            TupleTypeInfo tType = new TupleTypeInfo(fTypes);
            return new ProjectJoin(this.ds1, this.ds2, this.keys1, this.keys2, this.hint, this.fieldIndexes, this.isFieldInFirst, tType, this);
        }

        public <T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18> ProjectJoin<I1, I2, Tuple19<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18>> projectTuple19() {
            TypeInformation<?>[] fTypes = this.extractFieldTypes(this.fieldIndexes);
            TupleTypeInfo tType = new TupleTypeInfo(fTypes);
            return new ProjectJoin(this.ds1, this.ds2, this.keys1, this.keys2, this.hint, this.fieldIndexes, this.isFieldInFirst, tType, this);
        }

        public <T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19> ProjectJoin<I1, I2, Tuple20<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19>> projectTuple20() {
            TypeInformation<?>[] fTypes = this.extractFieldTypes(this.fieldIndexes);
            TupleTypeInfo tType = new TupleTypeInfo(fTypes);
            return new ProjectJoin(this.ds1, this.ds2, this.keys1, this.keys2, this.hint, this.fieldIndexes, this.isFieldInFirst, tType, this);
        }

        public <T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20> ProjectJoin<I1, I2, Tuple21<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20>> projectTuple21() {
            TypeInformation<?>[] fTypes = this.extractFieldTypes(this.fieldIndexes);
            TupleTypeInfo tType = new TupleTypeInfo(fTypes);
            return new ProjectJoin(this.ds1, this.ds2, this.keys1, this.keys2, this.hint, this.fieldIndexes, this.isFieldInFirst, tType, this);
        }

        public <T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21> ProjectJoin<I1, I2, Tuple22<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21>> projectTuple22() {
            TypeInformation<?>[] fTypes = this.extractFieldTypes(this.fieldIndexes);
            TupleTypeInfo tType = new TupleTypeInfo(fTypes);
            return new ProjectJoin(this.ds1, this.ds2, this.keys1, this.keys2, this.hint, this.fieldIndexes, this.isFieldInFirst, tType, this);
        }

        public <T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, T22> ProjectJoin<I1, I2, Tuple23<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, T22>> projectTuple23() {
            TypeInformation<?>[] fTypes = this.extractFieldTypes(this.fieldIndexes);
            TupleTypeInfo tType = new TupleTypeInfo(fTypes);
            return new ProjectJoin(this.ds1, this.ds2, this.keys1, this.keys2, this.hint, this.fieldIndexes, this.isFieldInFirst, tType, this);
        }

        public <T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, T22, T23> ProjectJoin<I1, I2, Tuple24<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, T22, T23>> projectTuple24() {
            TypeInformation<?>[] fTypes = this.extractFieldTypes(this.fieldIndexes);
            TupleTypeInfo tType = new TupleTypeInfo(fTypes);
            return new ProjectJoin(this.ds1, this.ds2, this.keys1, this.keys2, this.hint, this.fieldIndexes, this.isFieldInFirst, tType, this);
        }

        public <T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, T22, T23, T24> ProjectJoin<I1, I2, Tuple25<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, T22, T23, T24>> projectTuple25() {
            TypeInformation<?>[] fTypes = this.extractFieldTypes(this.fieldIndexes);
            TupleTypeInfo tType = new TupleTypeInfo(fTypes);
            return new ProjectJoin(this.ds1, this.ds2, this.keys1, this.keys2, this.hint, this.fieldIndexes, this.isFieldInFirst, tType, this);
        }

        private TypeInformation<?>[] extractFieldTypes(int[] fields) {
            TypeInformation[] fieldTypes = new TypeInformation[fields.length];
            for (int i = 0; i < fields.length; ++i) {
                Object typeInfo = this.isFieldInFirst[i] ? (fields[i] >= 0 ? ((TupleTypeInfo)this.ds1.getType()).getTypeAt(fields[i]) : this.ds1.getType()) : (fields[i] >= 0 ? ((TupleTypeInfo)this.ds2.getType()).getTypeAt(fields[i]) : this.ds2.getType());
                fieldTypes[i] = typeInfo;
            }
            return fieldTypes;
        }
    }

    @Internal
    private static final class ProjectFlatJoinFunction<T1, T2, R extends Tuple>
    extends RichFlatJoinFunction<T1, T2, R> {
        private static final long serialVersionUID = 1L;
        private final int[] fields;
        private final boolean[] isFromFirst;
        private final R outTuple;

        private ProjectFlatJoinFunction(int[] fields, boolean[] isFromFirst, R outTupleInstance) {
            if (fields.length != isFromFirst.length) {
                throw new IllegalArgumentException("Fields and isFromFirst arrays must have same length!");
            }
            this.fields = fields;
            this.isFromFirst = isFromFirst;
            this.outTuple = outTupleInstance;
        }

        protected int[] getFields() {
            return this.fields;
        }

        protected boolean[] getIsFromFirst() {
            return this.isFromFirst;
        }

        public void join(T1 in1, T2 in2, Collector<R> out) {
            for (int i = 0; i < this.fields.length; ++i) {
                if (this.isFromFirst[i]) {
                    if (this.fields[i] >= 0 && in1 != null) {
                        this.outTuple.setField(((Tuple)in1).getField(this.fields[i]), i);
                        continue;
                    }
                    this.outTuple.setField(in1, i);
                    continue;
                }
                if (this.fields[i] >= 0 && in2 != null) {
                    this.outTuple.setField(((Tuple)in2).getField(this.fields[i]), i);
                    continue;
                }
                this.outTuple.setField(in2, i);
            }
            out.collect(this.outTuple);
        }

        /* synthetic */ ProjectFlatJoinFunction(int[] x0, boolean[] x1, Tuple x2, 1 x3) {
            this(x0, x1, x2);
        }
    }

    @FunctionAnnotation.ForwardedFieldsFirst(value={"*->0"})
    @FunctionAnnotation.ForwardedFieldsSecond(value={"*->1"})
    @Internal
    private static final class DefaultFlatJoinFunction<T1, T2>
    extends RichFlatJoinFunction<T1, T2, Tuple2<T1, T2>> {
        private static final long serialVersionUID = 1L;
        private final Tuple2<T1, T2> outTuple = new Tuple2();

        private DefaultFlatJoinFunction() {
        }

        public void join(T1 first, T2 second, Collector<Tuple2<T1, T2>> out) throws Exception {
            this.outTuple.f0 = first;
            this.outTuple.f1 = second;
            out.collect(this.outTuple);
        }
    }

    @Public
    public static final class JoinOperatorSets<I1, I2>
    extends JoinOperatorSetsBase<I1, I2> {
        public JoinOperatorSets(DataSet<I1> input1, DataSet<I2> input2) {
            super(input1, input2);
        }

        public JoinOperatorSets(DataSet<I1> input1, DataSet<I2> input2, JoinOperatorBase.JoinHint hint) {
            super(input1, input2, hint);
        }

        @Override
        public JoinOperatorSetsPredicate where(int ... fields) {
            return new JoinOperatorSetsPredicate((Keys)new Keys.ExpressionKeys(fields, this.input1.getType()));
        }

        @Override
        public JoinOperatorSetsPredicate where(String ... fields) {
            return new JoinOperatorSetsPredicate((Keys)new Keys.ExpressionKeys(fields, this.input1.getType()));
        }

        @Override
        public <K> JoinOperatorSetsPredicate where(KeySelector<I1, K> keySelector) {
            TypeInformation keyType = TypeExtractor.getKeySelectorTypes(keySelector, this.input1.getType());
            return new JoinOperatorSetsPredicate((Keys)new Keys.SelectorFunctionKeys(this.input1.clean(keySelector), this.input1.getType(), keyType));
        }

        @Public
        public class JoinOperatorSetsPredicate
        extends JoinOperatorSetsBase.JoinOperatorSetsPredicateBase {
            private JoinOperatorSetsPredicate(Keys<I1> keys1) {
                super(JoinOperatorSets.this, keys1);
            }

            public DefaultJoin<I1, I2> equalTo(int ... fields) {
                return this.createDefaultJoin(new Keys.ExpressionKeys(fields, JoinOperatorSets.this.input2.getType()));
            }

            public DefaultJoin<I1, I2> equalTo(String ... fields) {
                return this.createDefaultJoin(new Keys.ExpressionKeys(fields, JoinOperatorSets.this.input2.getType()));
            }

            public <K> DefaultJoin<I1, I2> equalTo(KeySelector<I2, K> keySelector) {
                TypeInformation keyType = TypeExtractor.getKeySelectorTypes(keySelector, JoinOperatorSets.this.input2.getType());
                return this.createDefaultJoin(new Keys.SelectorFunctionKeys(JoinOperatorSets.this.input2.clean(keySelector), JoinOperatorSets.this.input2.getType(), keyType));
            }
        }
    }

    @Public
    public static class ProjectJoin<I1, I2, OUT extends Tuple>
    extends EquiJoin<I1, I2, OUT> {
        private JoinProjection<I1, I2> joinProj;

        protected ProjectJoin(DataSet<I1> input1, DataSet<I2> input2, Keys<I1> keys1, Keys<I2> keys2, JoinOperatorBase.JoinHint hint, int[] fields, boolean[] isFromFirst, TupleTypeInfo<OUT> returnType) {
            super(input1, input2, keys1, keys2, new ProjectFlatJoinFunction(fields, isFromFirst, returnType.createSerializer(input1.getExecutionEnvironment().getConfig()).createInstance(), null), returnType, hint, Utils.getCallLocationName(4));
            this.joinProj = null;
        }

        protected ProjectJoin(DataSet<I1> input1, DataSet<I2> input2, Keys<I1> keys1, Keys<I2> keys2, JoinOperatorBase.JoinHint hint, int[] fields, boolean[] isFromFirst, TupleTypeInfo<OUT> returnType, JoinProjection<I1, I2> joinProj) {
            super(input1, input2, keys1, keys2, new ProjectFlatJoinFunction(fields, isFromFirst, returnType.createSerializer(input1.getExecutionEnvironment().getConfig()).createInstance(), null), returnType, hint, Utils.getCallLocationName(4));
            this.joinProj = joinProj;
        }

        @Override
        protected ProjectFlatJoinFunction<I1, I2, OUT> getFunction() {
            return (ProjectFlatJoinFunction)super.getFunction();
        }

        public <OUT extends Tuple> ProjectJoin<I1, I2, OUT> projectFirst(int ... firstFieldIndexes) {
            this.joinProj = this.joinProj.projectFirst(firstFieldIndexes);
            return this.joinProj.projectTupleX();
        }

        public <OUT extends Tuple> ProjectJoin<I1, I2, OUT> projectSecond(int ... secondFieldIndexes) {
            this.joinProj = this.joinProj.projectSecond(secondFieldIndexes);
            return this.joinProj.projectTupleX();
        }

        @Deprecated
        @PublicEvolving
        public <OUT extends Tuple> JoinOperator<I1, I2, OUT> types(Class<?> ... types) {
            TupleTypeInfo typeInfo = (TupleTypeInfo)this.getResultType();
            if (types.length != typeInfo.getArity()) {
                throw new InvalidProgramException("Provided types do not match projection.");
            }
            for (int i = 0; i < types.length; ++i) {
                Class<?> typeClass = types[i];
                if (typeClass.equals(typeInfo.getTypeAt(i).getTypeClass())) continue;
                throw new InvalidProgramException("Provided type " + typeClass.getSimpleName() + " at position " + i + " does not match projection");
            }
            return this;
        }

        @Override
        public JoinOperator<I1, I2, OUT> withForwardedFieldsFirst(String ... forwardedFieldsFirst) {
            throw new InvalidProgramException("The semantic properties (forwarded fields) are automatically calculated.");
        }

        @Override
        public JoinOperator<I1, I2, OUT> withForwardedFieldsSecond(String ... forwardedFieldsSecond) {
            throw new InvalidProgramException("The semantic properties (forwarded fields) are automatically calculated.");
        }

        @Override
        protected DualInputSemanticProperties extractSemanticAnnotationsFromUdf(Class<?> udfClass) {
            return SemanticPropUtil.createProjectionPropertiesDual(this.getFunction().getFields(), this.getFunction().getIsFromFirst(), this.getInput1Type(), this.getInput2Type());
        }
    }

    @Public
    public static final class DefaultJoin<I1, I2>
    extends EquiJoin<I1, I2, Tuple2<I1, I2>>
    implements JoinFunctionAssigner<I1, I2> {
        public DefaultJoin(DataSet<I1> input1, DataSet<I2> input2, Keys<I1> keys1, Keys<I2> keys2, JoinOperatorBase.JoinHint hint, String joinLocationName, JoinType type) {
            super(input1, input2, keys1, keys2, new DefaultFlatJoinFunction(), new TupleTypeInfo(new TypeInformation[]{input1.getType(), input2.getType()}), hint, joinLocationName, type);
        }

        @Override
        public <R> EquiJoin<I1, I2, R> with(FlatJoinFunction<I1, I2, R> function) {
            if (function == null) {
                throw new NullPointerException("Join function must not be null.");
            }
            TypeInformation returnType = TypeExtractor.getFlatJoinReturnTypes(function, this.getInput1Type(), this.getInput2Type(), (String)Utils.getCallLocationName(), (boolean)true);
            return new EquiJoin(this.getInput1(), this.getInput2(), this.getKeys1(), this.getKeys2(), this.clean(function), returnType, this.getJoinHint(), Utils.getCallLocationName(), this.joinType);
        }

        @Override
        public <R> EquiJoin<I1, I2, R> with(JoinFunction<I1, I2, R> function) {
            if (function == null) {
                throw new NullPointerException("Join function must not be null.");
            }
            WrappingFlatJoinFunction<I1, I2, R> generatedFunction = new WrappingFlatJoinFunction<I1, I2, R>(this.clean(function));
            TypeInformation returnType = TypeExtractor.getJoinReturnTypes(function, this.getInput1Type(), this.getInput2Type(), (String)Utils.getCallLocationName(), (boolean)true);
            return new EquiJoin(this.getInput1(), this.getInput2(), this.getKeys1(), this.getKeys2(), generatedFunction, function, returnType, this.getJoinHint(), Utils.getCallLocationName(), this.joinType);
        }

        public <OUT extends Tuple> ProjectJoin<I1, I2, OUT> projectFirst(int ... firstFieldIndexes) {
            JoinProjection joinProjection = new JoinProjection(this.getInput1(), this.getInput2(), this.getKeys1(), this.getKeys2(), this.getJoinHint(), firstFieldIndexes, null);
            return joinProjection.projectTupleX();
        }

        public <OUT extends Tuple> ProjectJoin<I1, I2, OUT> projectSecond(int ... secondFieldIndexes) {
            JoinProjection joinProjection = new JoinProjection(this.getInput1(), this.getInput2(), this.getKeys1(), this.getKeys2(), this.getJoinHint(), null, secondFieldIndexes);
            return joinProjection.projectTupleX();
        }

        @Internal
        public static class WrappingFlatJoinFunction<IN1, IN2, OUT>
        extends WrappingFunction<JoinFunction<IN1, IN2, OUT>>
        implements FlatJoinFunction<IN1, IN2, OUT> {
            private static final long serialVersionUID = 1L;

            public WrappingFlatJoinFunction(JoinFunction<IN1, IN2, OUT> wrappedFunction) {
                super(wrappedFunction);
            }

            public void join(IN1 left, IN2 right, Collector<OUT> out) throws Exception {
                out.collect(((JoinFunction)this.wrappedFunction).join(left, right));
            }
        }
    }

    @Public
    public static class EquiJoin<I1, I2, OUT>
    extends JoinOperator<I1, I2, OUT> {
        private final FlatJoinFunction<I1, I2, OUT> function;
        private boolean preserve1;
        private boolean preserve2;
        private final String joinLocationName;

        public EquiJoin(DataSet<I1> input1, DataSet<I2> input2, Keys<I1> keys1, Keys<I2> keys2, FlatJoinFunction<I1, I2, OUT> function, TypeInformation<OUT> returnType, JoinOperatorBase.JoinHint hint, String joinLocationName) {
            this(input1, input2, keys1, keys2, function, returnType, hint, joinLocationName, JoinType.INNER);
        }

        public EquiJoin(DataSet<I1> input1, DataSet<I2> input2, Keys<I1> keys1, Keys<I2> keys2, FlatJoinFunction<I1, I2, OUT> generatedFunction, JoinFunction<I1, I2, OUT> function, TypeInformation<OUT> returnType, JoinOperatorBase.JoinHint hint, String joinLocationName) {
            this(input1, input2, keys1, keys2, generatedFunction, function, returnType, hint, joinLocationName, JoinType.INNER);
        }

        public EquiJoin(DataSet<I1> input1, DataSet<I2> input2, Keys<I1> keys1, Keys<I2> keys2, FlatJoinFunction<I1, I2, OUT> function, TypeInformation<OUT> returnType, JoinOperatorBase.JoinHint hint, String joinLocationName, JoinType type) {
            super(input1, input2, keys1, keys2, returnType, hint, type);
            if (function == null) {
                throw new NullPointerException();
            }
            this.function = function;
            this.joinLocationName = joinLocationName;
        }

        public EquiJoin(DataSet<I1> input1, DataSet<I2> input2, Keys<I1> keys1, Keys<I2> keys2, FlatJoinFunction<I1, I2, OUT> generatedFunction, JoinFunction<I1, I2, OUT> function, TypeInformation<OUT> returnType, JoinOperatorBase.JoinHint hint, String joinLocationName, JoinType type) {
            super(input1, input2, keys1, keys2, returnType, hint, type);
            this.joinLocationName = joinLocationName;
            if (function == null) {
                throw new NullPointerException();
            }
            this.function = generatedFunction;
        }

        protected FlatJoinFunction<I1, I2, OUT> getFunction() {
            return this.function;
        }

        @Override
        @Internal
        public DualInputSemanticProperties getSemanticProperties() {
            DualInputSemanticProperties props = super.getSemanticProperties();
            if (props != null && (this.keys1 instanceof Keys.SelectorFunctionKeys || this.keys2 instanceof Keys.SelectorFunctionKeys)) {
                int numFields1 = this.getInput1Type().getTotalFields();
                int numFields2 = this.getInput2Type().getTotalFields();
                int offset1 = this.keys1 instanceof Keys.SelectorFunctionKeys ? ((Keys.SelectorFunctionKeys)this.keys1).getKeyType().getTotalFields() : 0;
                int offset2 = this.keys2 instanceof Keys.SelectorFunctionKeys ? ((Keys.SelectorFunctionKeys)this.keys2).getKeyType().getTotalFields() : 0;
                props = SemanticPropUtil.addSourceFieldOffsets(props, numFields1, numFields2, offset1, offset2);
            }
            return props;
        }

        @Override
        protected DualInputSemanticProperties extractSemanticAnnotationsFromUdf(Class<?> udfClass) {
            if (this.function instanceof DefaultJoin.WrappingFlatJoinFunction) {
                return super.extractSemanticAnnotationsFromUdf(((WrappingFunction)this.function).getWrappedFunction().getClass());
            }
            return super.extractSemanticAnnotationsFromUdf(this.function.getClass());
        }

        @Override
        protected boolean udfWithForwardedFieldsFirstAnnotation(Class<?> udfClass) {
            if (this.function instanceof DefaultJoin.WrappingFlatJoinFunction) {
                return super.udfWithForwardedFieldsFirstAnnotation(((WrappingFunction)this.function).getWrappedFunction().getClass());
            }
            return super.udfWithForwardedFieldsFirstAnnotation(this.function.getClass());
        }

        @Override
        protected boolean udfWithForwardedFieldsSecondAnnotation(Class<?> udfClass) {
            if (this.function instanceof DefaultJoin.WrappingFlatJoinFunction) {
                return super.udfWithForwardedFieldsSecondAnnotation(((WrappingFunction)this.function).getWrappedFunction().getClass());
            }
            return super.udfWithForwardedFieldsSecondAnnotation(this.function.getClass());
        }

        protected JoinOperatorBase<?, ?, OUT, ?> translateToDataFlow(Operator<I1> input1, Operator<I2> input2) {
            boolean requiresTupleUnwrapping;
            String name = this.getName() != null ? this.getName() : "Join at " + this.joinLocationName;
            JoinOperatorBaseBuilder<OUT> builder = new JoinOperatorBaseBuilder(name, this.joinType).withParallelism(this.getParallelism()).withPartitioner(this.getPartitioner()).withJoinHint(this.getJoinHint()).withResultType(this.getResultType());
            boolean bl = requiresTupleUnwrapping = this.keys1 instanceof Keys.SelectorFunctionKeys || this.keys2 instanceof Keys.SelectorFunctionKeys;
            if (requiresTupleUnwrapping) {
                if (this.keys1 instanceof Keys.SelectorFunctionKeys && this.keys2 instanceof Keys.SelectorFunctionKeys) {
                    Keys.SelectorFunctionKeys selectorKeys1 = (Keys.SelectorFunctionKeys)this.keys1;
                    Keys.SelectorFunctionKeys selectorKeys2 = (Keys.SelectorFunctionKeys)this.keys2;
                    builder = builder.withUdf(new TupleUnwrappingJoiner(this.function)).withWrappedInput1(input1, selectorKeys1).withWrappedInput2(input2, selectorKeys2);
                } else if (this.keys2 instanceof Keys.SelectorFunctionKeys) {
                    Keys.SelectorFunctionKeys selectorKeys2 = (Keys.SelectorFunctionKeys)this.keys2;
                    builder = builder.withUdf(new TupleRightUnwrappingJoiner(this.function)).withInput1(input1, this.getInput1Type(), this.keys1).withWrappedInput2(input2, selectorKeys2);
                } else {
                    Keys.SelectorFunctionKeys selectorKeys1 = (Keys.SelectorFunctionKeys)this.keys1;
                    builder = builder.withUdf(new TupleLeftUnwrappingJoiner(this.function)).withWrappedInput1(input1, selectorKeys1).withInput2(input2, this.getInput2Type(), this.keys2);
                }
            } else if (this.keys1 instanceof Keys.ExpressionKeys && this.keys2 instanceof Keys.ExpressionKeys) {
                builder = builder.withUdf(this.function).withInput1(input1, this.getInput1Type(), this.keys1).withInput2(input2, this.getInput2Type(), this.keys2);
            } else {
                throw new UnsupportedOperationException("Unrecognized or incompatible key types.");
            }
            return builder.build();
        }

        private static final class JoinOperatorBaseBuilder<OUT> {
            private final String name;
            private final JoinType joinType;
            private int parallelism;
            private FlatJoinFunction<?, ?, OUT> udf;
            private TypeInformation<OUT> resultType;
            private Operator input1;
            private TypeInformation<?> input1Type;
            private Keys<?> keys1;
            private Operator input2;
            private TypeInformation<?> input2Type;
            private Keys<?> keys2;
            private Partitioner<?> partitioner;
            private JoinOperatorBase.JoinHint joinHint;

            public JoinOperatorBaseBuilder(String name, JoinType joinType) {
                this.name = name;
                this.joinType = joinType;
            }

            public <I1, K> JoinOperatorBaseBuilder<OUT> withWrappedInput1(Operator<I1> input1, Keys.SelectorFunctionKeys<I1, ?> rawKeys1) {
                Keys.SelectorFunctionKeys<I1, ?> keys1 = rawKeys1;
                TypeInformation<Tuple2<?, I1>> typeInfoWithKey1 = KeyFunctions.createTypeWithKey(keys1);
                Operator<Tuple2<?, I1>> keyMapper1 = KeyFunctions.appendKeyExtractor(input1, keys1);
                return this.withInput1((Operator<I1>)keyMapper1, (TypeInformation<I1>)typeInfoWithKey1, (Keys<?>)rawKeys1);
            }

            public <I2, K> JoinOperatorBaseBuilder<OUT> withWrappedInput2(Operator<I2> input2, Keys.SelectorFunctionKeys<I2, ?> rawKeys2) {
                Keys.SelectorFunctionKeys<I2, ?> keys2 = rawKeys2;
                TypeInformation<Tuple2<?, I2>> typeInfoWithKey2 = KeyFunctions.createTypeWithKey(keys2);
                Operator<Tuple2<?, I2>> keyMapper2 = KeyFunctions.appendKeyExtractor(input2, keys2);
                return this.withInput2((Operator<I2>)keyMapper2, (TypeInformation<I2>)typeInfoWithKey2, (Keys<?>)rawKeys2);
            }

            public <I1> JoinOperatorBaseBuilder<OUT> withInput1(Operator<I1> input1, TypeInformation<I1> input1Type, Keys<?> keys1) {
                this.input1 = input1;
                this.input1Type = input1Type;
                this.keys1 = keys1;
                return this;
            }

            public <I2> JoinOperatorBaseBuilder<OUT> withInput2(Operator<I2> input2, TypeInformation<I2> input2Type, Keys<?> keys2) {
                this.input2 = input2;
                this.input2Type = input2Type;
                this.keys2 = keys2;
                return this;
            }

            public JoinOperatorBaseBuilder<OUT> withParallelism(int parallelism) {
                this.parallelism = parallelism;
                return this;
            }

            public JoinOperatorBaseBuilder<OUT> withPartitioner(Partitioner<?> partitioner) {
                this.partitioner = partitioner;
                return this;
            }

            public JoinOperatorBaseBuilder<OUT> withJoinHint(JoinOperatorBase.JoinHint joinHint) {
                this.joinHint = joinHint;
                return this;
            }

            public JoinOperatorBaseBuilder<OUT> withUdf(FlatJoinFunction<?, ?, OUT> udf) {
                this.udf = udf;
                return this;
            }

            public JoinOperatorBaseBuilder<OUT> withResultType(TypeInformation<OUT> resultType) {
                this.resultType = resultType;
                return this;
            }

            public JoinOperatorBase<?, ?, OUT, ?> build() {
                Object operator = this.joinType.isOuter() ? new OuterJoinOperatorBase(this.udf, new BinaryOperatorInformation(this.input1Type, this.input2Type, this.resultType), this.keys1.computeLogicalKeyPositions(), this.keys2.computeLogicalKeyPositions(), this.name, this.getOuterJoinType()) : new InnerJoinOperatorBase(this.udf, new BinaryOperatorInformation(this.input1Type, this.input2Type, this.resultType), this.keys1.computeLogicalKeyPositions(), this.keys2.computeLogicalKeyPositions(), this.name);
                operator.setFirstInput(this.input1);
                operator.setSecondInput(this.input2);
                operator.setParallelism(this.parallelism);
                operator.setCustomPartitioner(this.partitioner);
                operator.setJoinHint(this.joinHint);
                return operator;
            }

            private OuterJoinOperatorBase.OuterJoinType getOuterJoinType() {
                switch (this.joinType) {
                    case LEFT_OUTER: {
                        return OuterJoinOperatorBase.OuterJoinType.LEFT;
                    }
                    case RIGHT_OUTER: {
                        return OuterJoinOperatorBase.OuterJoinType.RIGHT;
                    }
                    case FULL_OUTER: {
                        return OuterJoinOperatorBase.OuterJoinType.FULL;
                    }
                }
                throw new UnsupportedOperationException();
            }
        }
    }
}

