/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.hadoop.mapred.wrapper;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.core.io.LocatableInputSplit;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.WritableFactories;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobConfigurable;

@Internal
public class HadoopInputSplit
extends LocatableInputSplit {
    private static final long serialVersionUID = -6990336376163226160L;
    private final Class<? extends InputSplit> splitType;
    private transient InputSplit hadoopInputSplit;
    @Nullable
    private transient JobConf jobConf;

    public HadoopInputSplit(int splitNumber, InputSplit hInputSplit, @Nullable JobConf jobconf) {
        super(splitNumber, (String)null);
        if (hInputSplit == null) {
            throw new NullPointerException("Hadoop input split must not be null");
        }
        if (HadoopInputSplit.needsJobConf(hInputSplit) && jobconf == null) {
            throw new NullPointerException("Hadoop JobConf must not be null when input split is configurable.");
        }
        this.splitType = hInputSplit.getClass();
        this.jobConf = jobconf;
        this.hadoopInputSplit = hInputSplit;
    }

    public String[] getHostnames() {
        try {
            return this.hadoopInputSplit.getLocations();
        }
        catch (IOException e) {
            return new String[0];
        }
    }

    public InputSplit getHadoopInputSplit() {
        return this.hadoopInputSplit;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        if (HadoopInputSplit.needsJobConf(this.hadoopInputSplit)) {
            this.jobConf.write((DataOutput)out);
        }
        this.hadoopInputSplit.write((DataOutput)out);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        try {
            this.hadoopInputSplit = (InputSplit)WritableFactories.newInstance(this.splitType);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to instantiate Hadoop InputSplit", e);
        }
        if (HadoopInputSplit.needsJobConf(this.hadoopInputSplit)) {
            this.jobConf = new JobConf();
            this.jobConf.readFields((DataInput)in);
            if (this.hadoopInputSplit instanceof Configurable) {
                ((Configurable)this.hadoopInputSplit).setConf((Configuration)this.jobConf);
            } else if (this.hadoopInputSplit instanceof JobConfigurable) {
                ((JobConfigurable)this.hadoopInputSplit).configure(this.jobConf);
            }
        }
        this.hadoopInputSplit.readFields((DataInput)in);
    }

    private static boolean needsJobConf(InputSplit split) {
        return split instanceof Configurable || split instanceof JobConfigurable;
    }
}

