/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.scala.examples.wordcount;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.time.Duration;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.eventtime.WatermarkStrategy;
import org.apache.flink.api.common.functions.FlatMapFunction;
import org.apache.flink.api.common.serialization.Encoder;
import org.apache.flink.api.common.serialization.SimpleStringEncoder;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.connector.sink2.Sink;
import org.apache.flink.api.connector.source.Source;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.api.scala.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.connector.file.sink.FileSink;
import org.apache.flink.connector.file.src.FileSource;
import org.apache.flink.connector.file.src.reader.StreamFormat;
import org.apache.flink.connector.file.src.reader.TextLineInputFormat;
import org.apache.flink.core.fs.Path;
import org.apache.flink.streaming.api.datastream.DataStreamSink;
import org.apache.flink.streaming.api.functions.sink.filesystem.RollingPolicy;
import org.apache.flink.streaming.api.functions.sink.filesystem.rollingpolicies.DefaultRollingPolicy;
import org.apache.flink.streaming.api.scala.DataStream;
import org.apache.flink.streaming.api.scala.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.scala.StreamExecutionEnvironment$;
import org.apache.flink.streaming.examples.wordcount.util.WordCountData;
import org.apache.flink.streaming.scala.examples.wordcount.WordCount;
import org.apache.flink.streaming.scala.examples.wordcount.WordCount$;
import org.apache.flink.streaming.scala.examples.wordcount.util.CLI;
import org.apache.flink.streaming.scala.examples.wordcount.util.CLI$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

public final class WordCount$ {
    public static WordCount$ MODULE$;

    static {
        new WordCount$();
    }

    public void main(String[] args) {
        DataStreamSink dataStreamSink;
        DataStream dataStream;
        CLI params = CLI$.MODULE$.fromArgs(args);
        StreamExecutionEnvironment env = StreamExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        env.setRuntimeMode(params.executionMode());
        env.getConfig().setGlobalJobParameters((ExecutionConfig.GlobalJobParameters)params);
        Option<Path[]> option = params.input();
        if (option instanceof Some) {
            Some some = (Some)option;
            Path[] input = (Path[])some.value();
            FileSource.FileSourceBuilder builder = FileSource.forRecordStreamFormat((StreamFormat)new TextLineInputFormat(), (Path[])input);
            params.discoveryInterval().foreach((Function1 & Serializable & scala.Serializable)duration -> (FileSource.FileSourceBuilder)builder.monitorContinuously(duration));
            dataStream = env.fromSource((Source)builder.build(), WatermarkStrategy.noWatermarks(), "file-input", (TypeInformation)BasicTypeInfo.getInfoFor(String.class));
        } else if (None$.MODULE$.equals(option)) {
            dataStream = env.fromElements((Seq)Predef$.MODULE$.wrapRefArray((Object[])WordCountData.WORDS), (TypeInformation)BasicTypeInfo.getInfoFor(String.class)).name("in-memory-input");
        } else {
            throw new MatchError(option);
        }
        DataStream text = dataStream;
        DataStream counts = text.flatMap((FlatMapFunction)new WordCount.Tokenizer(), (TypeInformation)new CaseClassTypeInfo<Tuple2<String, Object>>(){

            public /* synthetic */ TypeInformation[] protected$types(anon.2 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple2<String, Object>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<Tuple2<String, Object>> unused = new ScalaCaseClassSerializer<Tuple2<String, Object>>(this, fieldSerializers){

                    public Tuple2<String, Object> createInstance(Object[] fields) {
                        return new Tuple2((Object)((String)fields[0]), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[1])));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.streaming.scala.examples.wordcount.WordCount$$anon$2 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        }).name("tokenizer").keyBy((Function1 & Serializable & scala.Serializable)x$1 -> (String)x$1._1(), (TypeInformation)BasicTypeInfo.getInfoFor(String.class)).sum(1).name("counter");
        Option<Path> option2 = params.output();
        if (option2 instanceof Some) {
            Some some = (Some)option2;
            Path output = (Path)some.value();
            dataStreamSink = counts.sinkTo((Sink)FileSink.forRowFormat((Path)output, (Encoder)new SimpleStringEncoder()).withRollingPolicy((RollingPolicy)DefaultRollingPolicy.builder().withMaxPartSize(MemorySize.ofMebiBytes((long)1L)).withRolloverInterval(Duration.ofSeconds(10L)).build()).build()).name("file-sink");
        } else if (None$.MODULE$.equals(option2)) {
            dataStreamSink = counts.print().name("print-sink");
        } else {
            throw new MatchError(option2);
        }
        env.execute("WordCount");
    }

    private WordCount$() {
        MODULE$ = this;
    }
}

