/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.scala.examples.windowing;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.eventtime.WatermarkStrategy;
import org.apache.flink.api.common.serialization.Encoder;
import org.apache.flink.api.common.serialization.SimpleStringEncoder;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.connector.sink2.Sink;
import org.apache.flink.api.connector.source.Source;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.api.scala.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.connector.file.sink.FileSink;
import org.apache.flink.connector.file.src.FileSource;
import org.apache.flink.connector.file.src.reader.StreamFormat;
import org.apache.flink.connector.file.src.reader.TextLineInputFormat;
import org.apache.flink.core.fs.Path;
import org.apache.flink.streaming.api.datastream.DataStreamSink;
import org.apache.flink.streaming.api.functions.sink.filesystem.RollingPolicy;
import org.apache.flink.streaming.api.functions.sink.filesystem.rollingpolicies.DefaultRollingPolicy;
import org.apache.flink.streaming.api.functions.source.SourceFunction;
import org.apache.flink.streaming.api.functions.windowing.delta.DeltaFunction;
import org.apache.flink.streaming.api.scala.DataStream;
import org.apache.flink.streaming.api.scala.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.scala.StreamExecutionEnvironment$;
import org.apache.flink.streaming.api.windowing.assigners.GlobalWindows;
import org.apache.flink.streaming.api.windowing.assigners.WindowAssigner;
import org.apache.flink.streaming.api.windowing.evictors.Evictor;
import org.apache.flink.streaming.api.windowing.evictors.TimeEvictor;
import org.apache.flink.streaming.api.windowing.time.Time;
import org.apache.flink.streaming.api.windowing.triggers.DeltaTrigger;
import org.apache.flink.streaming.api.windowing.triggers.Trigger;
import org.apache.flink.streaming.scala.examples.windowing.TopSpeedWindowing;
import org.apache.flink.streaming.scala.examples.windowing.TopSpeedWindowing$;
import org.apache.flink.streaming.scala.examples.windowing.util.CarSource$;
import org.apache.flink.streaming.scala.examples.wordcount.util.CLI;
import org.apache.flink.streaming.scala.examples.wordcount.util.CLI$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

public final class TopSpeedWindowing$ {
    public static TopSpeedWindowing$ MODULE$;
    private final int numOfCars;
    private final int evictionSec;
    private final double triggerMeters;

    static {
        new TopSpeedWindowing$();
    }

    public int numOfCars() {
        return this.numOfCars;
    }

    public int evictionSec() {
        return this.evictionSec;
    }

    public double triggerMeters() {
        return this.triggerMeters;
    }

    public void main(String[] args) {
        DataStreamSink dataStreamSink;
        DataStream dataStream;
        CLI params = CLI$.MODULE$.fromArgs(args);
        StreamExecutionEnvironment env = StreamExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        env.setRuntimeMode(params.executionMode());
        env.getConfig().setGlobalJobParameters((ExecutionConfig.GlobalJobParameters)params);
        Option<Path[]> option = params.input();
        if (option instanceof Some) {
            Some some = (Some)option;
            Path[] input = (Path[])some.value();
            FileSource.FileSourceBuilder builder = FileSource.forRecordStreamFormat((StreamFormat)new TextLineInputFormat(), (Path[])input);
            params.discoveryInterval().foreach((Function1 & Serializable & scala.Serializable)duration -> (FileSource.FileSourceBuilder)builder.monitorContinuously(duration));
            dataStream = env.fromSource((Source)builder.build(), WatermarkStrategy.noWatermarks(), "file-input", (TypeInformation)BasicTypeInfo.getInfoFor(String.class)).map((Function1 & Serializable & scala.Serializable)line -> MODULE$.parseMap((String)line), (TypeInformation)new CaseClassTypeInfo<TopSpeedWindowing.CarEvent>(){

                public /* synthetic */ TypeInformation[] protected$types(anon.3 x$1) {
                    return x$1.types;
                }

                public TypeSerializer<TopSpeedWindowing.CarEvent> createSerializer(ExecutionConfig executionConfig) {
                    TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                    RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                        fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                    });
                    ScalaCaseClassSerializer<TopSpeedWindowing.CarEvent> unused = new ScalaCaseClassSerializer<TopSpeedWindowing.CarEvent>(this, fieldSerializers){

                        public TopSpeedWindowing.CarEvent createInstance(Object[] fields) {
                            return new TopSpeedWindowing.CarEvent(BoxesRunTime.unboxToInt((Object)fields[0]), BoxesRunTime.unboxToInt((Object)fields[1]), BoxesRunTime.unboxToDouble((Object)fields[2]), BoxesRunTime.unboxToLong((Object)fields[3]));
                        }
                    };
                    return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.streaming.scala.examples.windowing.TopSpeedWindowing$$anon$3 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
                }
            }).name("parse-input");
        } else if (None$.MODULE$.equals(option)) {
            dataStream = env.addSource((SourceFunction)CarSource$.MODULE$.apply(2), (TypeInformation)new CaseClassTypeInfo<TopSpeedWindowing.CarEvent>(){

                public /* synthetic */ TypeInformation[] protected$types(anon.4 x$1) {
                    return x$1.types;
                }

                public TypeSerializer<TopSpeedWindowing.CarEvent> createSerializer(ExecutionConfig executionConfig) {
                    TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                    RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                        fieldSerializers$2[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                    });
                    ScalaCaseClassSerializer<TopSpeedWindowing.CarEvent> unused = new ScalaCaseClassSerializer<TopSpeedWindowing.CarEvent>(this, fieldSerializers){

                        public TopSpeedWindowing.CarEvent createInstance(Object[] fields) {
                            return new TopSpeedWindowing.CarEvent(BoxesRunTime.unboxToInt((Object)fields[0]), BoxesRunTime.unboxToInt((Object)fields[1]), BoxesRunTime.unboxToDouble((Object)fields[2]), BoxesRunTime.unboxToLong((Object)fields[3]));
                        }
                    };
                    return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$2(org.apache.flink.streaming.scala.examples.windowing.TopSpeedWindowing$$anon$4 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
                }
            }).name("in-memory-input");
        } else {
            throw new MatchError(option);
        }
        DataStream cars = dataStream;
        DataStream topSpeeds = cars.assignAscendingTimestamps((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToLong((long)x$1.time())).keyBy((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.carId()), (TypeInformation)BasicTypeInfo.getInfoFor(Integer.TYPE)).window((WindowAssigner)GlobalWindows.create()).evictor((Evictor)TimeEvictor.of((Time)Time.of((long)(this.evictionSec() * 1000), (TimeUnit)TimeUnit.MILLISECONDS))).trigger((Trigger)DeltaTrigger.of((double)this.triggerMeters(), (DeltaFunction)new DeltaFunction<TopSpeedWindowing.CarEvent>(){

            public double getDelta(TopSpeedWindowing.CarEvent oldSp, TopSpeedWindowing.CarEvent newSp) {
                return newSp.distance() - oldSp.distance();
            }
        }, (TypeSerializer)cars.dataType().createSerializer(env.getConfig()))).maxBy("speed");
        Option<Path> option2 = params.output();
        if (option2 instanceof Some) {
            Some some = (Some)option2;
            Path output = (Path)some.value();
            dataStreamSink = topSpeeds.sinkTo((Sink)FileSink.forRowFormat((Path)output, (Encoder)new SimpleStringEncoder()).withRollingPolicy((RollingPolicy)DefaultRollingPolicy.builder().withMaxPartSize(MemorySize.ofMebiBytes((long)1L)).withRolloverInterval(Duration.ofSeconds(10L)).build()).build()).name("file-sink");
        } else if (None$.MODULE$.equals(option2)) {
            dataStreamSink = topSpeeds.print().name("print-sink");
        } else {
            throw new MatchError(option2);
        }
        env.execute("TopSpeedWindowing");
    }

    public TopSpeedWindowing.CarEvent parseMap(String line) {
        String[] record = line.substring(1, line.length() - 1).split(",");
        return new TopSpeedWindowing.CarEvent(new StringOps(Predef$.MODULE$.augmentString(record[0])).toInt(), new StringOps(Predef$.MODULE$.augmentString(record[1])).toInt(), new StringOps(Predef$.MODULE$.augmentString(record[2])).toDouble(), new StringOps(Predef$.MODULE$.augmentString(record[3])).toLong());
    }

    private TopSpeedWindowing$() {
        MODULE$ = this;
        this.numOfCars = 2;
        this.evictionSec = 10;
        this.triggerMeters = 50.0;
    }
}

