/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.scala.examples.socket;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.utils.ParameterTool;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.api.scala.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.streaming.api.scala.DataStream;
import org.apache.flink.streaming.api.scala.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.scala.StreamExecutionEnvironment$;
import org.apache.flink.streaming.api.windowing.assigners.TumblingProcessingTimeWindows;
import org.apache.flink.streaming.api.windowing.assigners.WindowAssigner;
import org.apache.flink.streaming.api.windowing.time.Time;
import org.apache.flink.streaming.scala.examples.socket.SocketWindowWordCount;
import org.apache.flink.streaming.scala.examples.socket.SocketWindowWordCount$;
import scala.Function1;
import scala.Predef$;
import scala.collection.mutable.ArrayOps;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

public final class SocketWindowWordCount$ {
    public static SocketWindowWordCount$ MODULE$;

    static {
        new SocketWindowWordCount$();
    }

    public void main(String[] args) {
        String hostname = "localhost";
        int port = 0;
        try {
            ParameterTool params = ParameterTool.fromArgs((String[])args);
            hostname = params.has("hostname") ? params.get("hostname") : "localhost";
            port = params.getInt("port");
        }
        catch (Exception e) {
            System.err.println("No port specified. Please run 'SocketWindowWordCount --hostname <hostname> --port <port>', where hostname (localhost by default) and port is the address of the text server");
            System.err.println("To start a simple text server, run 'netcat -l <port>' and type the input text into the command line");
            return;
        }
        StreamExecutionEnvironment env = StreamExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        DataStream text = env.socketTextStream(hostname, port, '\n', env.socketTextStream$default$4());
        DataStream windowCounts = text.flatMap((Function1 & Serializable & scala.Serializable)w -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])w.split("\\s"))), (TypeInformation)BasicTypeInfo.getInfoFor(String.class)).map((Function1 & Serializable & scala.Serializable)w -> new SocketWindowWordCount.WordWithCount((String)w, 1L), (TypeInformation)new CaseClassTypeInfo<SocketWindowWordCount.WordWithCount>(){

            public /* synthetic */ TypeInformation[] protected$types(anon.2 x$1) {
                return x$1.types;
            }

            public TypeSerializer<SocketWindowWordCount.WordWithCount> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<SocketWindowWordCount.WordWithCount> unused = new ScalaCaseClassSerializer<SocketWindowWordCount.WordWithCount>(this, fieldSerializers){

                    public SocketWindowWordCount.WordWithCount createInstance(Object[] fields) {
                        return new SocketWindowWordCount.WordWithCount((String)fields[0], BoxesRunTime.unboxToLong((Object)fields[1]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.streaming.scala.examples.socket.SocketWindowWordCount$$anon$2 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        }).keyBy((Function1 & Serializable & scala.Serializable)x$1 -> x$1.word(), (TypeInformation)BasicTypeInfo.getInfoFor(String.class)).window((WindowAssigner)TumblingProcessingTimeWindows.of((Time)Time.seconds((long)5L))).sum("count");
        windowCounts.print();
        env.execute("Socket Window WordCount");
    }

    private SocketWindowWordCount$() {
        MODULE$ = this;
    }
}

