/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.scala.examples.join;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.utils.ParameterTool;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.api.scala.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.streaming.api.scala.DataStream;
import org.apache.flink.streaming.api.scala.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.scala.StreamExecutionEnvironment$;
import org.apache.flink.streaming.api.windowing.assigners.TumblingEventTimeWindows;
import org.apache.flink.streaming.api.windowing.assigners.WindowAssigner;
import org.apache.flink.streaming.api.windowing.time.Time;
import org.apache.flink.streaming.scala.examples.join.WindowJoin;
import org.apache.flink.streaming.scala.examples.join.WindowJoin$;
import org.apache.flink.streaming.scala.examples.join.WindowJoinSampleData$;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

public final class WindowJoin$ {
    public static WindowJoin$ MODULE$;

    static {
        new WindowJoin$();
    }

    public void main(String[] args) {
        ParameterTool params = ParameterTool.fromArgs((String[])args);
        long windowSize = params.getLong("windowSize", 2000L);
        long rate = params.getLong("rate", 3L);
        Predef$.MODULE$.println((Object)new StringBuilder(29).append("Using windowSize=").append(windowSize).append(", data rate=").append(rate).toString());
        Predef$.MODULE$.println((Object)"To customize example, use: WindowJoin [--windowSize <window-size-in-millis>] [--rate <elements-per-second>]");
        StreamExecutionEnvironment env = StreamExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        env.getConfig().setGlobalJobParameters((ExecutionConfig.GlobalJobParameters)params);
        DataStream<WindowJoin.Grade> grades = WindowJoinSampleData$.MODULE$.getGradeSource(env, rate);
        DataStream<WindowJoin.Salary> salaries = WindowJoinSampleData$.MODULE$.getSalarySource(env, rate);
        DataStream<WindowJoin.Person> joined = this.joinStreams(grades, salaries, windowSize);
        joined.print().setParallelism(1);
        env.execute("Windowed Join Example");
    }

    public DataStream<WindowJoin.Person> joinStreams(DataStream<WindowJoin.Grade> grades, DataStream<WindowJoin.Salary> salaries, long windowSize) {
        return grades.join(salaries).where((Function1 & Serializable & scala.Serializable)x$1 -> x$1.name(), (TypeInformation)BasicTypeInfo.getInfoFor(String.class)).equalTo((Function1 & Serializable & scala.Serializable)x$2 -> x$2.name()).window((WindowAssigner)TumblingEventTimeWindows.of((Time)Time.milliseconds((long)windowSize))).apply((Function2 & Serializable & scala.Serializable)(g, s) -> new WindowJoin.Person(g.name(), g.grade(), s.salary()), (TypeInformation)new CaseClassTypeInfo<WindowJoin.Person>(){

            public /* synthetic */ TypeInformation[] protected$types(anon.2 x$1) {
                return x$1.types;
            }

            public TypeSerializer<WindowJoin.Person> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<WindowJoin.Person> unused = new ScalaCaseClassSerializer<WindowJoin.Person>(this, fieldSerializers){

                    public WindowJoin.Person createInstance(Object[] fields) {
                        return new WindowJoin.Person((String)fields[0], BoxesRunTime.unboxToInt((Object)fields[1]), BoxesRunTime.unboxToInt((Object)fields[2]));
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.streaming.scala.examples.join.WindowJoin$$anon$2 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        });
    }

    private WindowJoin$() {
        MODULE$ = this;
    }
}

