/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.scala.examples.async;

import java.util.concurrent.TimeUnit;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.utils.ParameterTool;
import org.apache.flink.streaming.api.functions.source.SourceFunction;
import org.apache.flink.streaming.api.scala.AsyncDataStream$;
import org.apache.flink.streaming.api.scala.DataStream;
import org.apache.flink.streaming.api.scala.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.scala.StreamExecutionEnvironment$;
import org.apache.flink.streaming.api.scala.async.AsyncFunction;
import org.apache.flink.streaming.examples.async.util.SimpleSource;
import org.apache.flink.streaming.scala.examples.async.AsyncIOExample;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.runtime.BoxesRunTime;

public final class AsyncIOExample$ {
    public static AsyncIOExample$ MODULE$;

    static {
        new AsyncIOExample$();
    }

    public void main(String[] args) {
        DataStream dataStream;
        ParameterTool params = ParameterTool.fromArgs((String[])args);
        String mode = null;
        long timeout = 0L;
        try {
            mode = params.get("waitMode", "ordered");
            timeout = params.getLong("timeout", 10000L);
        }
        catch (Exception e) {
            Predef$.MODULE$.println((Object)"To customize example, use: AsyncIOExample [--waitMode <ordered or unordered>]");
            throw e;
        }
        StreamExecutionEnvironment env = StreamExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        DataStream inputStream = env.addSource((SourceFunction)new SimpleSource(), (TypeInformation)BasicTypeInfo.getInfoFor(Integer.class)).map((Function1 & java.io.Serializable & Serializable)x$1 -> BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(x$1)), (TypeInformation)BasicTypeInfo.getInfoFor(Integer.TYPE));
        AsyncIOExample.SampleAsyncFunction function = new AsyncIOExample.SampleAsyncFunction();
        String string = mode.toUpperCase();
        if ("ORDERED".equals(string)) {
            dataStream = AsyncDataStream$.MODULE$.orderedWait(inputStream, (AsyncFunction)function, timeout, TimeUnit.MILLISECONDS, 20, (TypeInformation)BasicTypeInfo.getInfoFor(String.class));
        } else if ("UNORDERED".equals(string)) {
            dataStream = AsyncDataStream$.MODULE$.unorderedWait(inputStream, (AsyncFunction)function, timeout, TimeUnit.MILLISECONDS, 20, (TypeInformation)BasicTypeInfo.getInfoFor(String.class));
        } else {
            throw new IllegalStateException(new StringBuilder(14).append("Unknown mode: ").append(mode).toString());
        }
        DataStream result = dataStream;
        result.print();
        env.execute(new StringBuilder(18).append("Async IO Example: ").append(mode).toString());
    }

    private AsyncIOExample$() {
        MODULE$ = this;
    }
}

