/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.examples.statemachine;

import org.apache.flink.api.common.serialization.SerializationSchema;
import org.apache.flink.api.connector.sink2.Sink;
import org.apache.flink.api.java.utils.ParameterTool;
import org.apache.flink.connector.kafka.sink.KafkaRecordSerializationSchema;
import org.apache.flink.connector.kafka.sink.KafkaSink;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.functions.source.SourceFunction;
import org.apache.flink.streaming.examples.statemachine.generator.EventsGeneratorSource;
import org.apache.flink.streaming.examples.statemachine.kafka.EventDeSerializationSchema;

public class KafkaEventsGeneratorJob {
    public static void main(String[] args) throws Exception {
        ParameterTool params = ParameterTool.fromArgs((String[])args);
        double errorRate = params.getDouble("error-rate", 0.0);
        int sleep = params.getInt("sleep", 1);
        String kafkaTopic = params.get("kafka-topic");
        String brokers = params.get("brokers", "localhost:9092");
        System.out.printf("Generating events to Kafka with standalone source with error rate %f and sleep delay %s millis\n", errorRate, sleep);
        System.out.println();
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        env.addSource((SourceFunction)new EventsGeneratorSource(errorRate, sleep)).sinkTo((Sink)KafkaSink.builder().setBootstrapServers(brokers).setRecordSerializer(KafkaRecordSerializationSchema.builder().setValueSerializationSchema((SerializationSchema)new EventDeSerializationSchema()).setTopic(kafkaTopic).build()).build());
        env.execute("State machine example Kafka events generator job");
    }
}

