/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.examples.async.util;

import org.apache.flink.api.common.state.ListState;
import org.apache.flink.api.common.state.ListStateDescriptor;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.IntSerializer;
import org.apache.flink.runtime.state.FunctionInitializationContext;
import org.apache.flink.runtime.state.FunctionSnapshotContext;
import org.apache.flink.streaming.api.checkpoint.CheckpointedFunction;
import org.apache.flink.streaming.api.functions.source.SourceFunction;

public class SimpleSource
implements SourceFunction<Integer>,
CheckpointedFunction {
    private static final long serialVersionUID = 1L;
    private volatile boolean isRunning = true;
    private int start = 0;
    private ListState<Integer> state;

    public void initializeState(FunctionInitializationContext context) throws Exception {
        this.state = context.getOperatorStateStore().getListState(new ListStateDescriptor("state", (TypeSerializer)IntSerializer.INSTANCE));
        for (Integer i : (Iterable)this.state.get()) {
            this.start = i;
        }
    }

    public void snapshotState(FunctionSnapshotContext context) throws Exception {
        this.state.clear();
        this.state.add((Object)this.start);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(SourceFunction.SourceContext<Integer> ctx) throws Exception {
        while (this.isRunning) {
            Object object = ctx.getCheckpointLock();
            synchronized (object) {
                ctx.collect((Object)this.start);
                ++this.start;
                if (this.start == Integer.MAX_VALUE) {
                    this.start = 0;
                }
            }
            Thread.sleep(10L);
        }
    }

    public void cancel() {
        this.isRunning = false;
    }
}

