/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.scala.examples.windowing;

import java.beans.Transient;
import java.util.concurrent.TimeUnit;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.utils.ParameterTool;
import org.apache.flink.api.scala.typeutils.CaseClassSerializer;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.streaming.api.TimeCharacteristic;
import org.apache.flink.streaming.api.datastream.DataStreamSink;
import org.apache.flink.streaming.api.functions.source.SourceFunction;
import org.apache.flink.streaming.api.functions.windowing.delta.DeltaFunction;
import org.apache.flink.streaming.api.scala.DataStream;
import org.apache.flink.streaming.api.scala.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.scala.StreamExecutionEnvironment$;
import org.apache.flink.streaming.api.windowing.assigners.GlobalWindows;
import org.apache.flink.streaming.api.windowing.assigners.WindowAssigner;
import org.apache.flink.streaming.api.windowing.evictors.Evictor;
import org.apache.flink.streaming.api.windowing.evictors.TimeEvictor;
import org.apache.flink.streaming.api.windowing.time.Time;
import org.apache.flink.streaming.api.windowing.triggers.DeltaTrigger;
import org.apache.flink.streaming.api.windowing.triggers.Trigger;
import org.apache.flink.streaming.scala.examples.windowing.TopSpeedWindowing;
import org.apache.flink.streaming.scala.examples.windowing.TopSpeedWindowing$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple4;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.util.Random;

public final class TopSpeedWindowing$ {
    public static final TopSpeedWindowing$ MODULE$;
    private final int numOfCars;
    private final int evictionSec;
    private final double triggerMeters;

    static {
        new TopSpeedWindowing$();
    }

    public int numOfCars() {
        return this.numOfCars;
    }

    public int evictionSec() {
        return this.evictionSec;
    }

    public double triggerMeters() {
        return this.triggerMeters;
    }

    public void main(String[] args) {
        DataStreamSink dataStreamSink;
        DataStream dataStream;
        ParameterTool params = ParameterTool.fromArgs((String[])args);
        StreamExecutionEnvironment env = StreamExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        env.getConfig().setGlobalJobParameters((ExecutionConfig.GlobalJobParameters)params);
        env.setStreamTimeCharacteristic(TimeCharacteristic.EventTime);
        env.setParallelism(1);
        if (params.has("input")) {
            dataStream = env.readTextFile(params.get("input")).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Tuple4<Object, Object, Object, Object> apply(String x$1) {
                    return TopSpeedWindowing$.MODULE$.parseMap(x$1);
                }
            }, (TypeInformation)new CaseClassTypeInfo<Tuple4<Object, Object, Object, Object>>(){

                public TypeInformation<?>[] protected$types(anon.4 x$1) {
                    return x$1.types;
                }

                public TypeSerializer<Tuple4<Object, Object, Object, Object>> createSerializer(ExecutionConfig executionConfig) {
                    TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                    RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anon.4 $outer;
                        private final ExecutionConfig executionConfig$1;
                        private final TypeSerializer[] fieldSerializers$1;

                        public final void apply(int i) {
                            this.apply$mcVI$sp(i);
                        }

                        public void apply$mcVI$sp(int i) {
                            this.fieldSerializers$1[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$1);
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.executionConfig$1 = executionConfig$1;
                            this.fieldSerializers$1 = fieldSerializers$1;
                        }
                    });
                    return new CaseClassSerializer<Tuple4<Object, Object, Object, Object>>(this, fieldSerializers){

                        public Tuple4<Object, Object, Object, Object> createInstance(Object[] fields) {
                            return new Tuple4((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[0])), (Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)fields[1])), (Object)BoxesRunTime.boxToDouble((double)BoxesRunTime.unboxToDouble((Object)fields[2])), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)fields[3])));
                        }
                    };
                }
            }).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final TopSpeedWindowing.CarEvent apply(Tuple4<Object, Object, Object, Object> x) {
                    return new TopSpeedWindowing.CarEvent(BoxesRunTime.unboxToInt((Object)x._1()), BoxesRunTime.unboxToInt((Object)x._2()), BoxesRunTime.unboxToDouble((Object)x._3()), BoxesRunTime.unboxToLong((Object)x._4()));
                }
            }, (TypeInformation)new CaseClassTypeInfo<TopSpeedWindowing.CarEvent>(){

                public TypeInformation<?>[] protected$types(anon.5 x$1) {
                    return x$1.types;
                }

                public TypeSerializer<TopSpeedWindowing.CarEvent> createSerializer(ExecutionConfig executionConfig) {
                    TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                    RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anon.5 $outer;
                        private final ExecutionConfig executionConfig$2;
                        private final TypeSerializer[] fieldSerializers$2;

                        public final void apply(int i) {
                            this.apply$mcVI$sp(i);
                        }

                        public void apply$mcVI$sp(int i) {
                            this.fieldSerializers$2[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$2);
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.executionConfig$2 = executionConfig$2;
                            this.fieldSerializers$2 = fieldSerializers$2;
                        }
                    });
                    return new CaseClassSerializer<TopSpeedWindowing.CarEvent>(this, fieldSerializers){

                        public TopSpeedWindowing.CarEvent createInstance(Object[] fields) {
                            return new TopSpeedWindowing.CarEvent(BoxesRunTime.unboxToInt((Object)fields[0]), BoxesRunTime.unboxToInt((Object)fields[1]), BoxesRunTime.unboxToDouble((Object)fields[2]), BoxesRunTime.unboxToLong((Object)fields[3]));
                        }
                    };
                }
            });
        } else {
            Predef$.MODULE$.println((Object)"Executing TopSpeedWindowing example with default inputs data set.");
            Predef$.MODULE$.println((Object)"Use --input to specify file input.");
            dataStream = env.addSource((SourceFunction)new SourceFunction<TopSpeedWindowing.CarEvent>(){
                private final Integer[] speeds;
                private final double[] distances;
                @Transient
                private Random rand;
                private boolean isRunning;
                private volatile boolean bitmap$0;

                private Random rand$lzycompute() {
                    anon.7 var1_1 = this;
                    synchronized (var1_1) {
                        if (!this.bitmap$0) {
                            this.rand = new Random();
                            this.bitmap$0 = true;
                        }
                        return this.rand;
                    }
                }

                public Integer[] speeds() {
                    return this.speeds;
                }

                public double[] distances() {
                    return this.distances;
                }

                public Random rand() {
                    return this.bitmap$0 ? this.rand : this.rand$lzycompute();
                }

                public boolean isRunning() {
                    return this.isRunning;
                }

                public void isRunning_$eq(boolean x$1) {
                    this.isRunning = x$1;
                }

                public void run(SourceFunction.SourceContext<TopSpeedWindowing.CarEvent> ctx) {
                    while (this.isRunning()) {
                        Thread.sleep(100L);
                        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), TopSpeedWindowing$.MODULE$.numOfCars()).foreach$mVc$sp((Function1)new Serializable(this, ctx){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ anon.7 $outer;
                            private final SourceFunction.SourceContext ctx$1;

                            public final void apply(int carId) {
                                this.apply$mcVI$sp(carId);
                            }

                            public void apply$mcVI$sp(int carId) {
                                this.$outer.speeds()[carId] = this.$outer.rand().nextBoolean() ? Predef$.MODULE$.int2Integer(Math.min(100, Predef$.MODULE$.Integer2int(this.$outer.speeds()[carId]) + 5)) : Predef$.MODULE$.int2Integer(Math.max(0, Predef$.MODULE$.Integer2int(this.$outer.speeds()[carId]) - 5));
                                this.$outer.distances()[carId] = this.$outer.distances()[carId] + (double)Predef$.MODULE$.Integer2int(this.$outer.speeds()[carId]) / 3.6;
                                TopSpeedWindowing.CarEvent record = new TopSpeedWindowing.CarEvent(carId, Predef$.MODULE$.Integer2int(this.$outer.speeds()[carId]), this.$outer.distances()[carId], System.currentTimeMillis());
                                this.ctx$1.collect((Object)record);
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                                this.ctx$1 = ctx$1;
                            }
                        });
                    }
                }

                public void cancel() {
                    this.isRunning_$eq(false);
                }
                {
                    this.speeds = (Integer[])Array$.MODULE$.fill(TopSpeedWindowing$.MODULE$.numOfCars(), (Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Integer apply() {
                            return Predef$.MODULE$.int2Integer(50);
                        }
                    }, ClassTag$.MODULE$.apply(Integer.class));
                    this.distances = (double[])Array$.MODULE$.fill(TopSpeedWindowing$.MODULE$.numOfCars(), (Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final double apply() {
                            return this.apply$mcD$sp();
                        }

                        public double apply$mcD$sp() {
                            return 0.0;
                        }
                    }, ClassTag$.MODULE$.Double());
                    this.isRunning = true;
                }
            }, (TypeInformation)new CaseClassTypeInfo<TopSpeedWindowing.CarEvent>(){

                public TypeInformation<?>[] protected$types(anon.6 x$1) {
                    return x$1.types;
                }

                public TypeSerializer<TopSpeedWindowing.CarEvent> createSerializer(ExecutionConfig executionConfig) {
                    TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                    RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anon.6 $outer;
                        private final ExecutionConfig executionConfig$3;
                        private final TypeSerializer[] fieldSerializers$3;

                        public final void apply(int i) {
                            this.apply$mcVI$sp(i);
                        }

                        public void apply$mcVI$sp(int i) {
                            this.fieldSerializers$3[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$3);
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.executionConfig$3 = executionConfig$3;
                            this.fieldSerializers$3 = fieldSerializers$3;
                        }
                    });
                    return new CaseClassSerializer<TopSpeedWindowing.CarEvent>(this, fieldSerializers){

                        public TopSpeedWindowing.CarEvent createInstance(Object[] fields) {
                            return new TopSpeedWindowing.CarEvent(BoxesRunTime.unboxToInt((Object)fields[0]), BoxesRunTime.unboxToInt((Object)fields[1]), BoxesRunTime.unboxToDouble((Object)fields[2]), BoxesRunTime.unboxToLong((Object)fields[3]));
                        }
                    };
                }
            });
        }
        DataStream cars = dataStream;
        DataStream topSeed = cars.assignAscendingTimestamps((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final long apply(TopSpeedWindowing.CarEvent x$2) {
                return x$2.time();
            }
        }).keyBy("carId", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).window((WindowAssigner)GlobalWindows.create()).evictor((Evictor)TimeEvictor.of((Time)Time.of((long)(this.evictionSec() * 1000), (TimeUnit)TimeUnit.MILLISECONDS))).trigger((Trigger)DeltaTrigger.of((double)this.triggerMeters(), (DeltaFunction)new DeltaFunction<TopSpeedWindowing.CarEvent>(){

            public double getDelta(TopSpeedWindowing.CarEvent oldSp, TopSpeedWindowing.CarEvent newSp) {
                return newSp.distance() - oldSp.distance();
            }
        }, (TypeSerializer)cars.getType().createSerializer(env.getConfig()))).maxBy("speed");
        if (params.has("output")) {
            dataStreamSink = topSeed.writeAsText(params.get("output"));
        } else {
            Predef$.MODULE$.println((Object)"Printing result to stdout. Use --output to specify output path.");
            dataStreamSink = topSeed.print();
        }
        env.execute("TopSpeedWindowing");
    }

    public Tuple4<Object, Object, Object, Object> parseMap(String line) {
        String[] record = line.substring(1, line.length() - 1).split(",");
        return new Tuple4((Object)BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(record[0])).toInt()), (Object)BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(record[1])).toInt()), (Object)BoxesRunTime.boxToDouble((double)new StringOps(Predef$.MODULE$.augmentString(record[2])).toDouble()), (Object)BoxesRunTime.boxToLong((long)new StringOps(Predef$.MODULE$.augmentString(record[3])).toLong()));
    }

    private TopSpeedWindowing$() {
        MODULE$ = this;
        this.numOfCars = 2;
        this.evictionSec = 10;
        this.triggerMeters = 50.0;
    }
}

