/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.scala.examples.socket;

import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.utils.ParameterTool;
import org.apache.flink.api.scala.typeutils.CaseClassSerializer;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.streaming.api.scala.DataStream;
import org.apache.flink.streaming.api.scala.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.scala.StreamExecutionEnvironment$;
import org.apache.flink.streaming.api.windowing.time.Time;
import org.apache.flink.streaming.scala.examples.socket.SocketWindowWordCount;
import org.apache.flink.streaming.scala.examples.socket.SocketWindowWordCount$;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.mutable.ArrayOps;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

public final class SocketWindowWordCount$ {
    public static final SocketWindowWordCount$ MODULE$;

    static {
        new SocketWindowWordCount$();
    }

    public void main(String[] args) {
        int port;
        try {
            port = ParameterTool.fromArgs((String[])args).getInt("port");
        }
        catch (Exception exception) {
            System.err.println("No port specified. Please run 'WindowWordCount --port <port>', where port is the address of the text server");
            System.err.println("To start a simple text server, run 'netcat -l <port>' and type the input text into the command line");
            return;
        }
        StreamExecutionEnvironment env = StreamExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        DataStream text = env.socketTextStream("localhost", port, '\n', env.socketTextStream$default$4());
        DataStream windowCounts = text.flatMap((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final ArrayOps<String> apply(String w) {
                return Predef$.MODULE$.refArrayOps((Object[])w.split("\\s"));
            }
        }, (TypeInformation)BasicTypeInfo.getInfoFor(String.class)).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final SocketWindowWordCount.WordWithCount apply(String w) {
                return new SocketWindowWordCount.WordWithCount(w, 1L);
            }
        }, (TypeInformation)new CaseClassTypeInfo<SocketWindowWordCount.WordWithCount>(){

            public TypeInformation<?>[] protected$types(anon.2 x$1) {
                return x$1.types;
            }

            public TypeSerializer<SocketWindowWordCount.WordWithCount> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anon.2 $outer;
                    private final ExecutionConfig executionConfig$1;
                    private final TypeSerializer[] fieldSerializers$1;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$1[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$1);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.executionConfig$1 = executionConfig$1;
                        this.fieldSerializers$1 = fieldSerializers$1;
                    }
                });
                return new CaseClassSerializer<SocketWindowWordCount.WordWithCount>(this, fieldSerializers){

                    public SocketWindowWordCount.WordWithCount createInstance(Object[] fields) {
                        return new SocketWindowWordCount.WordWithCount((String)fields[0], BoxesRunTime.unboxToLong((Object)fields[1]));
                    }
                };
            }
        }).keyBy("word", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).timeWindow(Time.seconds((long)5L), Time.seconds((long)1L)).sum("count");
        windowCounts.print().setParallelism(1);
        env.execute("Socket Window WordCount");
    }

    private SocketWindowWordCount$() {
        MODULE$ = this;
    }
}

