/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.scala.examples.join;

import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.utils.ParameterTool;
import org.apache.flink.api.scala.typeutils.CaseClassSerializer;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.streaming.api.TimeCharacteristic;
import org.apache.flink.streaming.api.scala.DataStream;
import org.apache.flink.streaming.api.scala.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.scala.StreamExecutionEnvironment$;
import org.apache.flink.streaming.api.windowing.assigners.TumblingEventTimeWindows;
import org.apache.flink.streaming.api.windowing.assigners.WindowAssigner;
import org.apache.flink.streaming.api.windowing.time.Time;
import org.apache.flink.streaming.scala.examples.join.WindowJoin;
import org.apache.flink.streaming.scala.examples.join.WindowJoin$;
import org.apache.flink.streaming.scala.examples.join.WindowJoinSampleData$;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Serializable;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

public final class WindowJoin$ {
    public static final WindowJoin$ MODULE$;

    static {
        new WindowJoin$();
    }

    public void main(String[] args) {
        ParameterTool params = ParameterTool.fromArgs((String[])args);
        long windowSize = params.getLong("windowSize", 2000L);
        long rate = params.getLong("rate", 3L);
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Using windowSize=").append((Object)BoxesRunTime.boxToLong((long)windowSize)).append((Object)", data rate=").append((Object)BoxesRunTime.boxToLong((long)rate)).toString());
        Predef$.MODULE$.println((Object)"To customize example, use: WindowJoin [--windowSize <window-size-in-millis>] [--rate <elements-per-second>]");
        StreamExecutionEnvironment env = StreamExecutionEnvironment$.MODULE$.getExecutionEnvironment();
        env.setStreamTimeCharacteristic(TimeCharacteristic.IngestionTime);
        env.getConfig().setGlobalJobParameters((ExecutionConfig.GlobalJobParameters)params);
        DataStream<WindowJoin.Grade> grades = WindowJoinSampleData$.MODULE$.getGradeSource(env, rate);
        DataStream<WindowJoin.Salary> salaries = WindowJoinSampleData$.MODULE$.getSalarySource(env, rate);
        DataStream<WindowJoin.Person> joined = this.joinStreams(grades, salaries, windowSize);
        joined.print().setParallelism(1);
        env.execute("WindowJoin");
    }

    public DataStream<WindowJoin.Person> joinStreams(DataStream<WindowJoin.Grade> grades, DataStream<WindowJoin.Salary> salaries, long windowSize) {
        return grades.join(salaries).where((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(WindowJoin.Grade x$1) {
                return x$1.name();
            }
        }, (TypeInformation)BasicTypeInfo.getInfoFor(String.class)).equalTo((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(WindowJoin.Salary x$2) {
                return x$2.name();
            }
        }).window((WindowAssigner)TumblingEventTimeWindows.of((Time)Time.milliseconds((long)windowSize))).apply((Function2)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final WindowJoin.Person apply(WindowJoin.Grade g, WindowJoin.Salary s) {
                return new WindowJoin.Person(g.name(), g.grade(), s.salary());
            }
        }, (TypeInformation)new CaseClassTypeInfo<WindowJoin.Person>(){

            public TypeInformation<?>[] protected$types(anon.2 x$1) {
                return x$1.types;
            }

            public TypeSerializer<WindowJoin.Person> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)new Serializable(this, executionConfig, fieldSerializers){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anon.2 $outer;
                    private final ExecutionConfig executionConfig$1;
                    private final TypeSerializer[] fieldSerializers$1;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fieldSerializers$1[i] = this.$outer.protected$types(this.$outer)[i].createSerializer(this.executionConfig$1);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.executionConfig$1 = executionConfig$1;
                        this.fieldSerializers$1 = fieldSerializers$1;
                    }
                });
                return new CaseClassSerializer<WindowJoin.Person>(this, fieldSerializers){

                    public WindowJoin.Person createInstance(Object[] fields) {
                        return new WindowJoin.Person((String)fields[0], BoxesRunTime.unboxToInt((Object)fields[1]), BoxesRunTime.unboxToInt((Object)fields[2]));
                    }
                };
            }
        });
    }

    private WindowJoin$() {
        MODULE$ = this;
    }
}

