/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.examples.windowing;

import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.functions.FlatMapFunction;
import org.apache.flink.api.java.utils.ParameterTool;
import org.apache.flink.examples.java.wordcount.util.WordCountData;
import org.apache.flink.streaming.api.datastream.DataStreamSource;
import org.apache.flink.streaming.api.datastream.SingleOutputStreamOperator;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.examples.wordcount.WordCount;

public class WindowWordCount {
    public static void main(String[] args) throws Exception {
        DataStreamSource text;
        ParameterTool params = ParameterTool.fromArgs((String[])args);
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        if (params.has("input")) {
            text = env.readTextFile(params.get("input"));
        } else {
            System.out.println("Executing WindowWordCount example with default input data set.");
            System.out.println("Use --input to specify file input.");
            text = env.fromElements((Object[])WordCountData.WORDS);
        }
        env.getConfig().setGlobalJobParameters((ExecutionConfig.GlobalJobParameters)params);
        int windowSize = params.getInt("window", 250);
        int slideSize = params.getInt("slide", 150);
        SingleOutputStreamOperator counts = text.flatMap((FlatMapFunction)new WordCount.Tokenizer()).keyBy(new int[]{0}).countWindow((long)windowSize, (long)slideSize).sum(1);
        if (params.has("output")) {
            counts.writeAsText(params.get("output"));
        } else {
            System.out.println("Printing result to stdout. Use --output to specify output path.");
            counts.print();
        }
        env.execute("WindowWordCount");
    }
}

