/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.examples.twitter;

import java.util.StringTokenizer;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.functions.FlatMapFunction;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.utils.ParameterTool;
import org.apache.flink.streaming.api.datastream.DataStreamSource;
import org.apache.flink.streaming.api.datastream.SingleOutputStreamOperator;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.functions.source.SourceFunction;
import org.apache.flink.streaming.connectors.twitter.TwitterSource;
import org.apache.flink.streaming.examples.twitter.util.TwitterExampleData;
import org.apache.flink.util.Collector;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;

public class TwitterExample {
    public static void main(String[] args) throws Exception {
        DataStreamSource streamSource;
        ParameterTool params = ParameterTool.fromArgs((String[])args);
        System.out.println("Usage: TwitterExample [--output <path>] [--twitter-source.consumerKey <key> --twitter-source.consumerSecret <secret> --twitter-source.token <token> --twitter-source.tokenSecret <tokenSecret>]");
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        env.getConfig().setGlobalJobParameters((ExecutionConfig.GlobalJobParameters)params);
        env.setParallelism(params.getInt("parallelism", 1));
        if (params.has("twitter-source.consumerKey") && params.has("twitter-source.consumerSecret") && params.has("twitter-source.token") && params.has("twitter-source.tokenSecret")) {
            streamSource = env.addSource((SourceFunction)new TwitterSource(params.getProperties()));
        } else {
            System.out.println("Executing TwitterStream example with default props.");
            System.out.println("Use --twitter-source.consumerKey <key> --twitter-source.consumerSecret <secret> --twitter-source.token <token> --twitter-source.tokenSecret <tokenSecret> specify the authentication info.");
            streamSource = env.fromElements((Object[])TwitterExampleData.TEXTS);
        }
        SingleOutputStreamOperator tweets = streamSource.flatMap((FlatMapFunction)new SelectEnglishAndTokenizeFlatMap()).keyBy(new int[]{0}).sum(1);
        if (params.has("output")) {
            tweets.writeAsText(params.get("output"));
        } else {
            System.out.println("Printing result to stdout. Use --output to specify output path.");
            tweets.print();
        }
        env.execute("Twitter Streaming Example");
    }

    public static class SelectEnglishAndTokenizeFlatMap
    implements FlatMapFunction<String, Tuple2<String, Integer>> {
        private static final long serialVersionUID = 1L;
        private transient ObjectMapper jsonParser;

        public void flatMap(String value, Collector<Tuple2<String, Integer>> out) throws Exception {
            JsonNode jsonNode;
            if (this.jsonParser == null) {
                this.jsonParser = new ObjectMapper();
            }
            boolean isEnglish = (jsonNode = (JsonNode)this.jsonParser.readValue(value, JsonNode.class)).has("user") && jsonNode.get("user").has("lang") && jsonNode.get("user").get("lang").asText().equals("en");
            boolean hasText = jsonNode.has("text");
            if (isEnglish && hasText) {
                StringTokenizer tokenizer = new StringTokenizer(jsonNode.get("text").asText());
                while (tokenizer.hasMoreTokens()) {
                    String result = tokenizer.nextToken().replaceAll("\\s*", "").toLowerCase();
                    if (result.equals("")) continue;
                    out.collect((Object)new Tuple2((Object)result, (Object)1));
                }
            }
        }
    }
}

