/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.examples.kafka;

import org.apache.flink.api.common.restartstrategy.RestartStrategies;
import org.apache.flink.api.java.utils.ParameterTool;
import org.apache.flink.streaming.api.datastream.DataStreamSource;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.functions.sink.SinkFunction;
import org.apache.flink.streaming.api.functions.source.SourceFunction;
import org.apache.flink.streaming.connectors.kafka.FlinkKafkaProducer08;
import org.apache.flink.streaming.util.serialization.SerializationSchema;
import org.apache.flink.streaming.util.serialization.SimpleStringSchema;

public class WriteIntoKafka {
    public static void main(String[] args) throws Exception {
        ParameterTool parameterTool = ParameterTool.fromArgs((String[])args);
        if (parameterTool.getNumberOfParameters() < 2) {
            System.out.println("Missing parameters!");
            System.out.println("Usage: Kafka --topic <topic> --bootstrap.servers <kafka brokers>");
            return;
        }
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        env.getConfig().disableSysoutLogging();
        env.getConfig().setRestartStrategy(RestartStrategies.fixedDelayRestart((int)4, (long)10000L));
        DataStreamSource messageStream = env.addSource((SourceFunction)new SourceFunction<String>(){
            private static final long serialVersionUID = 6369260445318862378L;
            public boolean running = true;

            public void run(SourceFunction.SourceContext<String> ctx) throws Exception {
                long i = 0L;
                while (this.running) {
                    ctx.collect((Object)("Element - " + i++));
                    Thread.sleep(500L);
                }
            }

            public void cancel() {
                this.running = false;
            }
        });
        messageStream.addSink((SinkFunction)new FlinkKafkaProducer08(parameterTool.getRequired("topic"), (SerializationSchema)new SimpleStringSchema(), parameterTool.getProperties()));
        env.execute("Write into Kafka example");
    }
}

