/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.datastream.api.builtin;

import org.apache.flink.annotation.Experimental;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.datastream.api.extension.join.JoinFunction;
import org.apache.flink.datastream.api.extension.join.JoinType;
import org.apache.flink.datastream.api.extension.window.function.OneInputWindowStreamProcessFunction;
import org.apache.flink.datastream.api.extension.window.function.TwoInputNonBroadcastWindowStreamProcessFunction;
import org.apache.flink.datastream.api.extension.window.function.TwoOutputWindowStreamProcessFunction;
import org.apache.flink.datastream.api.extension.window.strategy.WindowStrategy;
import org.apache.flink.datastream.api.function.OneInputStreamProcessFunction;
import org.apache.flink.datastream.api.function.TwoInputNonBroadcastStreamProcessFunction;
import org.apache.flink.datastream.api.function.TwoOutputStreamProcessFunction;
import org.apache.flink.datastream.api.stream.KeyedPartitionStream;
import org.apache.flink.datastream.api.stream.NonKeyedPartitionStream;

@Experimental
public class BuiltinFuncs {
    static final Class<?> JOIN_FUNCS_INSTANCE;
    static final Class<?> WINDOW_FUNCS_INSTANCE;

    public static <IN1, IN2, OUT> TwoInputNonBroadcastStreamProcessFunction<IN1, IN2, OUT> join(JoinFunction<IN1, IN2, OUT> joinFunction) {
        return BuiltinFuncs.join(joinFunction, JoinType.INNER);
    }

    public static <IN1, IN2, OUT> TwoInputNonBroadcastStreamProcessFunction<IN1, IN2, OUT> join(JoinFunction<IN1, IN2, OUT> joinFunction, JoinType joinType) {
        try {
            return (TwoInputNonBroadcastStreamProcessFunction)JOIN_FUNCS_INSTANCE.getMethod("join", JoinFunction.class, JoinType.class).invoke(null, new Object[]{joinFunction, joinType});
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <KEY, T1, T2, OUT> NonKeyedPartitionStream<OUT> join(KeyedPartitionStream<KEY, T1> leftStream, KeyedPartitionStream<KEY, T2> rightStream, JoinFunction<T1, T2, OUT> joinFunction) {
        return BuiltinFuncs.join(leftStream, rightStream, joinFunction, JoinType.INNER);
    }

    public static <KEY, T1, T2, OUT> NonKeyedPartitionStream<OUT> join(KeyedPartitionStream<KEY, T1> leftStream, KeyedPartitionStream<KEY, T2> rightStream, JoinFunction<T1, T2, OUT> joinFunction, JoinType joinType) {
        return leftStream.connectAndProcess(rightStream, BuiltinFuncs.join(joinFunction, joinType));
    }

    public static <KEY, T1, T2, OUT> NonKeyedPartitionStream<OUT> join(NonKeyedPartitionStream<T1> leftStream, KeySelector<T1, KEY> leftKeySelector, NonKeyedPartitionStream<T2> rightStream, KeySelector<T2, KEY> rightKeySelector, JoinFunction<T1, T2, OUT> joinFunction) {
        return BuiltinFuncs.join(leftStream, leftKeySelector, rightStream, rightKeySelector, joinFunction, JoinType.INNER);
    }

    public static <KEY, T1, T2, OUT> NonKeyedPartitionStream<OUT> join(NonKeyedPartitionStream<T1> leftStream, KeySelector<T1, KEY> leftKeySelector, NonKeyedPartitionStream<T2> rightStream, KeySelector<T2, KEY> rightKeySelector, JoinFunction<T1, T2, OUT> joinFunction, JoinType joinType) {
        return BuiltinFuncs.join(leftStream.keyBy(leftKeySelector), rightStream.keyBy(rightKeySelector), joinFunction, joinType);
    }

    public static <IN, OUT> OneInputStreamProcessFunction<IN, OUT> window(WindowStrategy windowStrategy, OneInputWindowStreamProcessFunction<IN, OUT> windowProcessFunction) {
        try {
            return (OneInputStreamProcessFunction)WINDOW_FUNCS_INSTANCE.getMethod("window", WindowStrategy.class, OneInputWindowStreamProcessFunction.class).invoke(null, windowStrategy, windowProcessFunction);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <IN1, IN2, OUT> TwoInputNonBroadcastStreamProcessFunction<IN1, IN2, OUT> window(WindowStrategy windowStrategy, TwoInputNonBroadcastWindowStreamProcessFunction<IN1, IN2, OUT> windowProcessFunction) {
        try {
            return (TwoInputNonBroadcastStreamProcessFunction)WINDOW_FUNCS_INSTANCE.getMethod("window", WindowStrategy.class, TwoInputNonBroadcastWindowStreamProcessFunction.class).invoke(null, windowStrategy, windowProcessFunction);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <IN, OUT1, OUT2> TwoOutputStreamProcessFunction<IN, OUT1, OUT2> window(WindowStrategy windowStrategy, TwoOutputWindowStreamProcessFunction<IN, OUT1, OUT2> windowProcessFunction) {
        try {
            return (TwoOutputStreamProcessFunction)WINDOW_FUNCS_INSTANCE.getMethod("window", WindowStrategy.class, TwoOutputWindowStreamProcessFunction.class).invoke(null, windowStrategy, windowProcessFunction);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static {
        try {
            JOIN_FUNCS_INSTANCE = Class.forName("org.apache.flink.datastream.impl.builtin.BuiltinJoinFuncs");
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Please ensure that flink-datastream in your class path");
        }
        try {
            WINDOW_FUNCS_INSTANCE = Class.forName("org.apache.flink.datastream.impl.builtin.BuiltinWindowFuncs");
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Please ensure that flink-datastream in your class path");
        }
    }
}

