/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.csv;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.apache.commons.compress.utils.BoundedInputStream;
import org.apache.flink.api.common.io.FileInputFormat;
import org.apache.flink.core.fs.FileInputSplit;
import org.apache.flink.core.fs.Path;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.dataformat.csv.CsvSchema;
import org.apache.flink.util.Preconditions;

public abstract class AbstractCsvInputFormat<T>
extends FileInputFormat<T> {
    protected final CsvSchema csvSchema;
    protected transient InputStream csvInputStream;

    public AbstractCsvInputFormat(Path[] filePaths, CsvSchema csvSchema) {
        this.setFilePaths(filePaths);
        this.csvSchema = (CsvSchema)Preconditions.checkNotNull((Object)csvSchema);
    }

    public boolean supportsMultiPaths() {
        return true;
    }

    public void open(FileInputSplit split) throws IOException {
        super.open(split);
        this.csvInputStream = this.stream;
        long csvStart = this.splitStart;
        if (this.splitStart != 0L) {
            csvStart = this.findNextLineStartOffset();
        }
        if (this.splitLength != -1L) {
            this.stream.seek(this.splitStart + this.splitLength);
            long nextLineStartOffset = this.findNextLineStartOffset();
            this.stream.seek(csvStart);
            this.csvInputStream = new BoundedInputStream((InputStream)this.stream, nextLineStartOffset - csvStart);
        } else {
            this.stream.seek(csvStart);
        }
    }

    private long findNextLineStartOffset() throws IOException {
        byte b;
        boolean usesEscapeChar = this.csvSchema.usesEscapeChar();
        byte[] escapeBytes = Character.toString((char)this.csvSchema.getEscapeChar()).getBytes(StandardCharsets.UTF_8);
        long startPos = this.stream.getPos();
        while ((b = (byte)this.stream.read()) != -1) {
            if (b == 13 || b == 10) {
                long front;
                if (usesEscapeChar && this.stream.getPos() - startPos <= (long)escapeBytes.length && (front = this.stream.getPos() - (long)escapeBytes.length - 1L) > 0L) {
                    this.stream.seek(front);
                    byte[] readBytes = new byte[escapeBytes.length];
                    this.stream.read(readBytes);
                    this.stream.read();
                    if (Arrays.equals(escapeBytes, readBytes)) continue;
                }
                long pos = this.stream.getPos();
                if (b == 13 && (byte)this.stream.read() == 10) {
                    return this.stream.getPos();
                }
                return pos;
            }
            if (!usesEscapeChar || b != escapeBytes[0]) continue;
            boolean equal = true;
            for (int i = 1; i < escapeBytes.length; ++i) {
                if ((byte)this.stream.read() == escapeBytes[i]) continue;
                equal = false;
                break;
            }
            if (!equal) continue;
            this.stream.skip(1L);
        }
        return this.stream.getPos();
    }
}

