/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.file.src.util;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.flink.connector.file.src.util.RecordAndPosition;
import org.apache.flink.connector.file.src.util.SingletonResultIterator;
import org.junit.Assert;
import org.junit.Test;

public class SingletonResultIteratorTest {
    @Test
    public void testEmptyConstruction() {
        SingletonResultIterator iter = new SingletonResultIterator();
        Assert.assertNull((Object)iter.next());
    }

    @Test
    public void testGetElement() {
        Object element = new Object();
        long pos = 1422L;
        long skipCount = 17L;
        SingletonResultIterator iter = new SingletonResultIterator();
        iter.set(element, 1422L, 17L);
        RecordAndPosition record = iter.next();
        Assert.assertNotNull((Object)record);
        Assert.assertEquals((Object)element, (Object)record.getRecord());
        Assert.assertEquals((long)1422L, (long)record.getOffset());
        Assert.assertEquals((long)17L, (long)record.getRecordSkipCount());
    }

    @Test
    public void testExhausted() {
        SingletonResultIterator iter = new SingletonResultIterator();
        iter.set(new Object(), 1L, 2L);
        iter.next();
        Assert.assertNull((Object)iter.next());
    }

    @Test
    public void testNoRecycler() {
        SingletonResultIterator iter = new SingletonResultIterator();
        iter.releaseBatch();
    }

    @Test
    public void testRecycler() {
        AtomicBoolean recycled = new AtomicBoolean();
        SingletonResultIterator iter = new SingletonResultIterator(() -> recycled.set(true));
        iter.releaseBatch();
        Assert.assertTrue((boolean)recycled.get());
    }
}

