/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.file.src.util;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.flink.connector.file.src.util.ArrayResultIterator;
import org.apache.flink.connector.file.src.util.RecordAndPosition;
import org.junit.Assert;
import org.junit.Test;

public class ArrayResultIteratorTest {
    @Test
    public void testEmptyConstruction() {
        ArrayResultIterator iter = new ArrayResultIterator();
        Assert.assertNull((Object)iter.next());
    }

    @Test
    public void testGetElements() {
        Object[] elements = new String[]{"1", "2", "3", "4"};
        long initialPos = 1422L;
        long initialSkipCount = 17L;
        ArrayResultIterator iter = new ArrayResultIterator();
        iter.set(elements, elements.length, 1422L, 17L);
        for (int i = 0; i < elements.length; ++i) {
            RecordAndPosition recAndPos = iter.next();
            Assert.assertEquals((Object)elements[i], (Object)recAndPos.getRecord());
            Assert.assertEquals((long)1422L, (long)recAndPos.getOffset());
            Assert.assertEquals((long)(17L + (long)i + 1L), (long)recAndPos.getRecordSkipCount());
        }
    }

    @Test
    public void testExhausted() {
        ArrayResultIterator iter = new ArrayResultIterator();
        iter.set((Object[])new String[]{"1", "2"}, 2, 0L, 0L);
        iter.next();
        iter.next();
        Assert.assertNull((Object)iter.next());
    }

    @Test
    public void testArraySubRange() {
        ArrayResultIterator iter = new ArrayResultIterator();
        iter.set((Object[])new String[]{"1", "2", "3"}, 2, 0L, 0L);
        Assert.assertNotNull((Object)iter.next());
        Assert.assertNotNull((Object)iter.next());
        Assert.assertNull((Object)iter.next());
    }

    @Test
    public void testNoRecycler() {
        ArrayResultIterator iter = new ArrayResultIterator();
        iter.releaseBatch();
    }

    @Test
    public void testRecycler() {
        AtomicBoolean recycled = new AtomicBoolean();
        ArrayResultIterator iter = new ArrayResultIterator(() -> recycled.set(true));
        iter.releaseBatch();
        Assert.assertTrue((boolean)recycled.get());
    }
}

