/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.file.src.impl;

import java.io.File;
import java.util.Arrays;
import org.apache.flink.api.connector.source.SplitEnumeratorContext;
import org.apache.flink.connector.file.src.FileSourceSplit;
import org.apache.flink.connector.file.src.PendingSplitsCheckpoint;
import org.apache.flink.connector.file.src.assigners.FileSplitAssigner;
import org.apache.flink.connector.file.src.assigners.SimpleSplitAssigner;
import org.apache.flink.connector.file.src.impl.StaticFileSplitEnumerator;
import org.apache.flink.connector.testutils.source.reader.TestingSplitEnumeratorContext;
import org.apache.flink.core.fs.Path;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class StaticFileSplitEnumeratorTest {
    private static final File TMP_DIR = new File(System.getProperty("java.io.tmpdir"));
    private static long splitId = 1L;

    @Test
    public void testCheckpointNoSplitRequested() throws Exception {
        TestingSplitEnumeratorContext context = new TestingSplitEnumeratorContext(4);
        FileSourceSplit split = StaticFileSplitEnumeratorTest.createRandomSplit();
        StaticFileSplitEnumerator enumerator = StaticFileSplitEnumeratorTest.createEnumerator((SplitEnumeratorContext<FileSourceSplit>)context, split);
        PendingSplitsCheckpoint checkpoint = enumerator.snapshotState();
        Assert.assertThat((Object)checkpoint.getSplits(), (Matcher)Matchers.contains((Object[])new FileSourceSplit[]{split}));
    }

    @Test
    public void testSplitRequestForRegisteredReader() throws Exception {
        TestingSplitEnumeratorContext context = new TestingSplitEnumeratorContext(4);
        FileSourceSplit split = StaticFileSplitEnumeratorTest.createRandomSplit();
        StaticFileSplitEnumerator enumerator = StaticFileSplitEnumeratorTest.createEnumerator((SplitEnumeratorContext<FileSourceSplit>)context, split);
        context.registerReader(3, "somehost");
        enumerator.addReader(3);
        enumerator.handleSplitRequest(3, "somehost");
        Assert.assertThat((Object)enumerator.snapshotState().getSplits(), (Matcher)Matchers.empty());
        Assert.assertThat((Object)((TestingSplitEnumeratorContext.SplitAssignmentState)context.getSplitAssignments().get(3)).getAssignedSplits(), (Matcher)Matchers.contains((Object[])new FileSourceSplit[]{split}));
    }

    @Test
    public void testSplitRequestForNonRegisteredReader() throws Exception {
        TestingSplitEnumeratorContext context = new TestingSplitEnumeratorContext(4);
        FileSourceSplit split = StaticFileSplitEnumeratorTest.createRandomSplit();
        StaticFileSplitEnumerator enumerator = StaticFileSplitEnumeratorTest.createEnumerator((SplitEnumeratorContext<FileSourceSplit>)context, split);
        enumerator.handleSplitRequest(3, "somehost");
        Assert.assertFalse((boolean)context.getSplitAssignments().containsKey(3));
        Assert.assertThat((Object)enumerator.snapshotState().getSplits(), (Matcher)Matchers.contains((Object[])new FileSourceSplit[]{split}));
    }

    @Test
    public void testNoMoreSplits() throws Exception {
        TestingSplitEnumeratorContext context = new TestingSplitEnumeratorContext(4);
        FileSourceSplit split = StaticFileSplitEnumeratorTest.createRandomSplit();
        StaticFileSplitEnumerator enumerator = StaticFileSplitEnumeratorTest.createEnumerator((SplitEnumeratorContext<FileSourceSplit>)context, split);
        context.registerReader(1, "somehost");
        enumerator.addReader(1);
        enumerator.handleSplitRequest(1, "somehost");
        enumerator.handleSplitRequest(1, "somehost");
        Assert.assertThat((Object)((TestingSplitEnumeratorContext.SplitAssignmentState)context.getSplitAssignments().get(1)).getAssignedSplits(), (Matcher)Matchers.contains((Object[])new FileSourceSplit[]{split}));
        Assert.assertTrue((boolean)((TestingSplitEnumeratorContext.SplitAssignmentState)context.getSplitAssignments().get(1)).hasReceivedNoMoreSplitsSignal());
    }

    private static FileSourceSplit createRandomSplit() {
        return new FileSourceSplit(String.valueOf(splitId++), Path.fromLocalFile((File)new File(TMP_DIR, "foo")), 0L, 0L);
    }

    private static StaticFileSplitEnumerator createEnumerator(SplitEnumeratorContext<FileSourceSplit> context, FileSourceSplit ... splits) {
        return new StaticFileSplitEnumerator(context, (FileSplitAssigner)new SimpleSplitAssigner(Arrays.asList(splits)));
    }
}

