/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.file.src.impl;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import org.apache.flink.api.connector.source.SourceReaderContext;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.connector.file.src.FileSourceSplit;
import org.apache.flink.connector.file.src.impl.FileSourceReader;
import org.apache.flink.connector.file.src.impl.StreamFormatAdapter;
import org.apache.flink.connector.file.src.reader.BulkFormat;
import org.apache.flink.connector.file.src.reader.StreamFormat;
import org.apache.flink.connector.file.src.reader.TextLineFormat;
import org.apache.flink.connector.testutils.source.reader.TestingReaderContext;
import org.apache.flink.core.fs.Path;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class FileSourceReaderTest {
    @ClassRule
    public static final TemporaryFolder TMP_DIR = new TemporaryFolder();

    @Test
    public void testRequestSplitWhenNoSplitRestored() throws Exception {
        TestingReaderContext context = new TestingReaderContext();
        FileSourceReader<String, FileSourceSplit> reader = FileSourceReaderTest.createReader(context);
        reader.start();
        reader.close();
        Assert.assertEquals((long)1L, (long)context.getNumSplitRequests());
    }

    @Test
    public void testNoSplitRequestWhenSplitRestored() throws Exception {
        TestingReaderContext context = new TestingReaderContext();
        FileSourceReader<String, FileSourceSplit> reader = FileSourceReaderTest.createReader(context);
        reader.addSplits(Collections.singletonList(FileSourceReaderTest.createTestFileSplit()));
        reader.start();
        reader.close();
        Assert.assertEquals((long)0L, (long)context.getNumSplitRequests());
    }

    private static FileSourceReader<String, FileSourceSplit> createReader(TestingReaderContext context) {
        return new FileSourceReader((SourceReaderContext)context, (BulkFormat)new StreamFormatAdapter((StreamFormat)new TextLineFormat()), new Configuration());
    }

    private static FileSourceSplit createTestFileSplit() throws IOException {
        return new FileSourceSplit("test-id", Path.fromLocalFile((File)TMP_DIR.newFile()), 0L, 0L);
    }
}

