/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.file.src.impl;

import java.util.Collections;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.flink.connector.file.src.impl.FileRecords;
import org.apache.flink.connector.file.src.reader.BulkFormat;
import org.apache.flink.connector.file.src.util.RecordAndPosition;
import org.apache.flink.connector.file.src.util.SingletonResultIterator;
import org.junit.Assert;
import org.junit.Test;

public class FileRecordsTest {
    @Test
    public void testEmptySplits() {
        String split = "empty";
        FileRecords records = FileRecords.finishedSplit((String)"empty");
        Assert.assertEquals(Collections.singleton("empty"), (Object)records.finishedSplits());
    }

    @Test
    public void testMoveToFirstSplit() {
        String splitId = "splitId";
        FileRecords records = FileRecords.forRecords((String)"splitId", (BulkFormat.RecordIterator)new SingletonResultIterator());
        String firstSplitId = records.nextSplit();
        Assert.assertEquals((Object)"splitId", (Object)firstSplitId);
    }

    @Test
    public void testMoveToSecondSplit() {
        FileRecords records = FileRecords.forRecords((String)"splitId", (BulkFormat.RecordIterator)new SingletonResultIterator());
        records.nextSplit();
        String secondSplitId = records.nextSplit();
        Assert.assertNull((Object)secondSplitId);
    }

    @Test
    public void testRecordsFromFirstSplit() {
        SingletonResultIterator iter = new SingletonResultIterator();
        iter.set((Object)"test", 18L, 99L);
        FileRecords records = FileRecords.forRecords((String)"splitId", (BulkFormat.RecordIterator)iter);
        records.nextSplit();
        RecordAndPosition recAndPos = records.nextRecordFromSplit();
        Assert.assertEquals((Object)"test", (Object)recAndPos.getRecord());
        Assert.assertEquals((long)18L, (long)recAndPos.getOffset());
        Assert.assertEquals((long)99L, (long)recAndPos.getRecordSkipCount());
    }

    @Test(expected=IllegalStateException.class)
    public void testRecordsInitiallyIllegal() {
        FileRecords records = FileRecords.forRecords((String)"splitId", (BulkFormat.RecordIterator)new SingletonResultIterator());
        records.nextRecordFromSplit();
    }

    @Test(expected=IllegalStateException.class)
    public void testRecordsOnSecondSplitIllegal() {
        FileRecords records = FileRecords.forRecords((String)"splitId", (BulkFormat.RecordIterator)new SingletonResultIterator());
        records.nextSplit();
        records.nextSplit();
        records.nextRecordFromSplit();
    }

    @Test
    public void testRecycleExhaustedBatch() {
        AtomicBoolean recycled = new AtomicBoolean(false);
        SingletonResultIterator iter = new SingletonResultIterator(() -> recycled.set(true));
        iter.set(new Object(), 1L, 2L);
        FileRecords records = FileRecords.forRecords((String)"test split", (BulkFormat.RecordIterator)iter);
        records.nextSplit();
        records.nextRecordFromSplit();
        Assert.assertNull((Object)records.nextRecordFromSplit());
        Assert.assertNull((Object)records.nextSplit());
        records.recycle();
        Assert.assertTrue((boolean)recycled.get());
    }

    @Test
    public void testRecycleNonExhaustedBatch() {
        AtomicBoolean recycled = new AtomicBoolean(false);
        SingletonResultIterator iter = new SingletonResultIterator(() -> recycled.set(true));
        iter.set(new Object(), 1L, 2L);
        FileRecords records = FileRecords.forRecords((String)"test split", (BulkFormat.RecordIterator)iter);
        records.nextSplit();
        records.recycle();
        Assert.assertTrue((boolean)recycled.get());
    }
}

