/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.file.src.impl;

import java.io.IOException;
import javax.annotation.Nullable;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.connector.file.src.FileSourceSplit;
import org.apache.flink.connector.file.src.impl.AdapterTestBase;
import org.apache.flink.connector.file.src.impl.FileRecordFormatAdapter;
import org.apache.flink.connector.file.src.impl.TestIntReader;
import org.apache.flink.connector.file.src.reader.BulkFormat;
import org.apache.flink.connector.file.src.reader.FileRecordFormat;
import org.apache.flink.core.fs.FSDataInputStream;
import org.apache.flink.core.fs.FileStatus;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.junit.Assert;

public class FileRecordFormatAdapterTest
extends AdapterTestBase<FileRecordFormat<Integer>> {
    @Override
    protected FileRecordFormat<Integer> createCheckpointedFormat() {
        return new IntFileRecordFormat(true);
    }

    @Override
    protected FileRecordFormat<Integer> createNonCheckpointedFormat() {
        return new IntFileRecordFormat(false);
    }

    @Override
    protected FileRecordFormat<Integer> createFormatFailingInInstantiation() {
        return new FailingInstantiationFormat();
    }

    @Override
    protected BulkFormat<Integer, FileSourceSplit> wrapWithAdapter(FileRecordFormat<Integer> format) {
        return new FileRecordFormatAdapter(format);
    }

    @Override
    public void testClosesStreamIfReaderCreationFails() throws Exception {
    }

    private static final class FailingInstantiationFormat
    implements FileRecordFormat<Integer> {
        private FailingInstantiationFormat() {
        }

        public FileRecordFormat.Reader<Integer> createReader(Configuration config, Path filePath, long splitOffset, long splitLength) throws IOException {
            throw new UnsupportedOperationException();
        }

        public FileRecordFormat.Reader<Integer> restoreReader(Configuration config, Path filePath, long restoredOffset, long splitOffset, long splitLength) throws IOException {
            FSDataInputStream in = filePath.getFileSystem().open(filePath);
            return new FailingReader(in);
        }

        public boolean isSplittable() {
            return false;
        }

        public TypeInformation<Integer> getProducedType() {
            return Types.INT;
        }

        private static final class FailingReader
        implements FileRecordFormat.Reader<Integer> {
            private final FSDataInputStream stream;

            FailingReader(FSDataInputStream stream) {
                this.stream = stream;
            }

            @Nullable
            public Integer read() throws IOException {
                throw new IOException("test exception");
            }

            public void close() throws IOException {
                this.stream.close();
            }
        }
    }

    private static final class IntFileRecordFormat
    implements FileRecordFormat<Integer> {
        private final boolean checkpointed;

        IntFileRecordFormat(boolean checkpointed) {
            this.checkpointed = checkpointed;
        }

        public FileRecordFormat.Reader<Integer> createReader(Configuration config, Path filePath, long splitOffset, long splitLength) throws IOException {
            FileSystem fs = filePath.getFileSystem();
            FileStatus status = fs.getFileStatus(filePath);
            FSDataInputStream in = fs.open(filePath);
            long fileLen = status.getLen();
            long splitEnd = splitOffset + splitLength;
            Assert.assertEquals((String)"invalid file length", (long)0L, (long)(fileLen % 4L));
            long start = splitOffset == 0L ? 0L : splitOffset + 4L - splitOffset % 4L;
            long end = splitEnd == fileLen ? fileLen : splitEnd + 4L - splitEnd % 4L;
            in.seek(start);
            return new TestIntReader(in, end, this.checkpointed);
        }

        public FileRecordFormat.Reader<Integer> restoreReader(Configuration config, Path filePath, long restoredOffset, long splitOffset, long splitLength) throws IOException {
            FileSystem fs = filePath.getFileSystem();
            FileStatus status = fs.getFileStatus(filePath);
            FSDataInputStream in = fs.open(filePath);
            long fileLen = status.getLen();
            long splitEnd = splitOffset + splitLength;
            Assert.assertEquals((String)"invalid file length", (long)0L, (long)(fileLen % 4L));
            long end = splitEnd == fileLen ? fileLen : splitEnd + 4L - splitEnd % 4L;
            in.seek(restoredOffset);
            return new TestIntReader(in, end, this.checkpointed);
        }

        public boolean isSplittable() {
            return true;
        }

        public TypeInformation<Integer> getProducedType() {
            return Types.INT;
        }
    }
}

