/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.file.src.impl;

import java.io.File;
import java.util.Collections;
import org.apache.flink.api.connector.source.SplitEnumeratorContext;
import org.apache.flink.connector.file.src.FileSourceSplit;
import org.apache.flink.connector.file.src.assigners.FileSplitAssigner;
import org.apache.flink.connector.file.src.assigners.SimpleSplitAssigner;
import org.apache.flink.connector.file.src.enumerate.FileEnumerator;
import org.apache.flink.connector.file.src.impl.ContinuousFileSplitEnumerator;
import org.apache.flink.connector.file.src.testutils.TestingFileEnumerator;
import org.apache.flink.connector.testutils.source.reader.TestingSplitEnumeratorContext;
import org.apache.flink.core.fs.Path;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class ContinuousFileSplitEnumeratorTest {
    private static final File TMP_DIR = new File(System.getProperty("java.io.tmpdir"));
    private static long splitId = 1L;

    @Test
    public void testDiscoverSplitWhenNoReaderRegistered() throws Exception {
        TestingFileEnumerator fileEnumerator = new TestingFileEnumerator(new FileSourceSplit[0]);
        TestingSplitEnumeratorContext context = new TestingSplitEnumeratorContext(4);
        ContinuousFileSplitEnumerator enumerator = ContinuousFileSplitEnumeratorTest.createEnumerator(fileEnumerator, (SplitEnumeratorContext<FileSourceSplit>)context);
        FileSourceSplit split = ContinuousFileSplitEnumeratorTest.createRandomSplit();
        fileEnumerator.addSplits(split);
        context.triggerAllActions();
        Assert.assertThat((Object)enumerator.snapshotState().getSplits(), (Matcher)Matchers.contains((Object[])new FileSourceSplit[]{split}));
    }

    @Test
    public void testDiscoverWhenReaderRegistered() throws Exception {
        TestingFileEnumerator fileEnumerator = new TestingFileEnumerator(new FileSourceSplit[0]);
        TestingSplitEnumeratorContext context = new TestingSplitEnumeratorContext(4);
        ContinuousFileSplitEnumerator enumerator = ContinuousFileSplitEnumeratorTest.createEnumerator(fileEnumerator, (SplitEnumeratorContext<FileSourceSplit>)context);
        context.registerReader(2, "localhost");
        enumerator.addReader(2);
        enumerator.handleSplitRequest(2, "localhost");
        FileSourceSplit split = ContinuousFileSplitEnumeratorTest.createRandomSplit();
        fileEnumerator.addSplits(split);
        context.triggerAllActions();
        Assert.assertThat((Object)enumerator.snapshotState().getSplits(), (Matcher)Matchers.empty());
        Assert.assertThat((Object)((TestingSplitEnumeratorContext.SplitAssignmentState)context.getSplitAssignments().get(2)).getAssignedSplits(), (Matcher)Matchers.contains((Object[])new FileSourceSplit[]{split}));
    }

    @Test
    public void testRequestingReaderUnavailableWhenSplitDiscovered() throws Exception {
        TestingFileEnumerator fileEnumerator = new TestingFileEnumerator(new FileSourceSplit[0]);
        TestingSplitEnumeratorContext context = new TestingSplitEnumeratorContext(4);
        ContinuousFileSplitEnumerator enumerator = ContinuousFileSplitEnumeratorTest.createEnumerator(fileEnumerator, (SplitEnumeratorContext<FileSourceSplit>)context);
        context.registerReader(2, "localhost");
        enumerator.addReader(2);
        enumerator.handleSplitRequest(2, "localhost");
        context.registeredReaders().remove(2);
        FileSourceSplit split = ContinuousFileSplitEnumeratorTest.createRandomSplit();
        fileEnumerator.addSplits(split);
        context.triggerAllActions();
        Assert.assertFalse((boolean)context.getSplitAssignments().containsKey(2));
        Assert.assertThat((Object)enumerator.snapshotState().getSplits(), (Matcher)Matchers.contains((Object[])new FileSourceSplit[]{split}));
    }

    private static FileSourceSplit createRandomSplit() {
        return new FileSourceSplit(String.valueOf(splitId++), Path.fromLocalFile((File)new File(TMP_DIR, "foo")), 0L, 0L);
    }

    private static ContinuousFileSplitEnumerator createEnumerator(FileEnumerator fileEnumerator, SplitEnumeratorContext<FileSourceSplit> context) {
        ContinuousFileSplitEnumerator enumerator = new ContinuousFileSplitEnumerator(context, fileEnumerator, (FileSplitAssigner)new SimpleSplitAssigner(Collections.emptyList()), new Path[]{Path.fromLocalFile((File)TMP_DIR)}, Collections.emptySet(), 10L);
        enumerator.start();
        return enumerator;
    }
}

