/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.file.src.assigners;

import java.io.File;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Optional;
import java.util.Random;
import org.apache.flink.connector.file.src.FileSourceSplit;
import org.apache.flink.connector.file.src.assigners.LocalityAwareSplitAssigner;
import org.apache.flink.core.fs.Path;
import org.junit.Assert;
import org.junit.Test;

public class LocalityAwareSplitAssignerTest {
    private static final Path TEST_PATH = Path.fromLocalFile((File)new File(System.getProperty("java.io.tmpdir")));

    @Test
    public void testAssignmentWithNullHost() {
        Optional is;
        int numSplits = 50;
        String[][] hosts = new String[][]{{"localhost"}, new String[0]};
        HashSet<FileSourceSplit> splits = new HashSet<FileSourceSplit>();
        for (int i = 0; i < 50; ++i) {
            splits.add(LocalityAwareSplitAssignerTest.createSplit(i, hosts[i % hosts.length]));
        }
        LocalityAwareSplitAssigner ia = new LocalityAwareSplitAssigner(splits);
        while ((is = ia.getNext(null)).isPresent()) {
            Assert.assertTrue((boolean)splits.remove(is.get()));
        }
        Assert.assertTrue((boolean)splits.isEmpty());
        Assert.assertFalse((boolean)ia.getNext("").isPresent());
        Assert.assertEquals((long)50L, (long)ia.getNumberOfRemoteAssignments());
        Assert.assertEquals((long)0L, (long)ia.getNumberOfLocalAssignments());
    }

    @Test
    public void testAssignmentAllForSameHost() {
        Optional is;
        int numSplits = 50;
        HashSet<FileSourceSplit> splits = new HashSet<FileSourceSplit>();
        for (int i = 0; i < 50; ++i) {
            splits.add(LocalityAwareSplitAssignerTest.createSplit(i, "testhost"));
        }
        LocalityAwareSplitAssigner ia = new LocalityAwareSplitAssigner(splits);
        while ((is = ia.getNext("testhost")).isPresent()) {
            Assert.assertTrue((boolean)splits.remove(is.get()));
        }
        Assert.assertTrue((boolean)splits.isEmpty());
        Assert.assertFalse((boolean)ia.getNext("").isPresent());
        Assert.assertEquals((long)0L, (long)ia.getNumberOfRemoteAssignments());
        Assert.assertEquals((long)50L, (long)ia.getNumberOfLocalAssignments());
    }

    @Test
    public void testAssignmentAllForRemoteHost() {
        Optional is;
        String[] hosts = new String[]{"host1", "host1", "host1", "host2", "host2", "host3"};
        int numSplits = 10 * hosts.length;
        HashSet<FileSourceSplit> splits = new HashSet<FileSourceSplit>();
        for (int i = 0; i < numSplits; ++i) {
            splits.add(LocalityAwareSplitAssignerTest.createSplit(i, hosts[i % hosts.length]));
        }
        LocalityAwareSplitAssigner ia = new LocalityAwareSplitAssigner(splits);
        while ((is = ia.getNext("testhost")).isPresent()) {
            Assert.assertTrue((boolean)splits.remove(is.get()));
        }
        Assert.assertTrue((boolean)splits.isEmpty());
        Assert.assertFalse((boolean)ia.getNext("anotherHost").isPresent());
        Assert.assertEquals((long)numSplits, (long)ia.getNumberOfRemoteAssignments());
        Assert.assertEquals((long)0L, (long)ia.getNumberOfLocalAssignments());
    }

    @Test
    public void testAssignmentSomeForRemoteHost() {
        Optional is;
        int i;
        String[] hosts = new String[]{"host1", "host2", "host3"};
        int numLocalHost1Splits = 20;
        int numLocalHost2Splits = 10;
        int numRemoteSplits = 30;
        int numLocalSplits = 30;
        int splitCnt = 0;
        HashSet<FileSourceSplit> splits = new HashSet<FileSourceSplit>();
        for (i = 0; i < 20; ++i) {
            splits.add(LocalityAwareSplitAssignerTest.createSplit(splitCnt++, "host1"));
        }
        for (i = 0; i < 10; ++i) {
            splits.add(LocalityAwareSplitAssignerTest.createSplit(splitCnt++, "host2"));
        }
        for (i = 0; i < 30; ++i) {
            splits.add(LocalityAwareSplitAssignerTest.createSplit(splitCnt++, "remoteHost"));
        }
        LocalityAwareSplitAssigner ia = new LocalityAwareSplitAssigner(splits);
        int i2 = 0;
        while ((is = ia.getNext(hosts[i2++ % hosts.length])).isPresent()) {
            Assert.assertTrue((boolean)splits.remove(is.get()));
        }
        Assert.assertTrue((boolean)splits.isEmpty());
        Assert.assertFalse((boolean)ia.getNext("anotherHost").isPresent());
        Assert.assertEquals((long)30L, (long)ia.getNumberOfRemoteAssignments());
        Assert.assertEquals((long)30L, (long)ia.getNumberOfLocalAssignments());
    }

    @Test
    public void testAssignmentMultiLocalHost() {
        int i;
        Object[] localHosts = new String[]{"local1", "local2", "local3"};
        Object[] remoteHosts = new String[]{"remote1", "remote2", "remote3"};
        String[] requestingHosts = new String[]{"local3", "local2", "local1", "other"};
        int numThreeLocalSplits = 10;
        int numTwoLocalSplits = 10;
        int numOneLocalSplits = 10;
        int numLocalSplits = 30;
        int numRemoteSplits = 10;
        int numSplits = 40;
        Object[] threeLocalHosts = localHosts;
        Object[] twoLocalHosts = new String[]{localHosts[0], localHosts[1], remoteHosts[0]};
        Object[] oneLocalHost = new String[]{localHosts[0], remoteHosts[0], remoteHosts[1]};
        Object[] noLocalHost = remoteHosts;
        int splitCnt = 0;
        HashSet<FileSourceSplit> splits = new HashSet<FileSourceSplit>();
        for (i = 0; i < 10; ++i) {
            splits.add(LocalityAwareSplitAssignerTest.createSplit(splitCnt++, (String[])threeLocalHosts));
        }
        for (i = 0; i < 10; ++i) {
            splits.add(LocalityAwareSplitAssignerTest.createSplit(splitCnt++, (String[])twoLocalHosts));
        }
        for (i = 0; i < 10; ++i) {
            splits.add(LocalityAwareSplitAssignerTest.createSplit(splitCnt++, (String[])oneLocalHost));
        }
        for (i = 0; i < 10; ++i) {
            splits.add(LocalityAwareSplitAssignerTest.createSplit(splitCnt++, (String[])noLocalHost));
        }
        LocalityAwareSplitAssigner ia = new LocalityAwareSplitAssigner(splits);
        for (int i2 = 0; i2 < 40; ++i2) {
            String host = requestingHosts[i2 % requestingHosts.length];
            Optional ois = ia.getNext(host);
            Assert.assertTrue((boolean)ois.isPresent());
            FileSourceSplit is = (FileSourceSplit)ois.get();
            Assert.assertTrue((boolean)splits.remove(is));
            if (host.equals(localHosts[0])) {
                Assert.assertArrayEquals((Object[])is.hostnames(), (Object[])oneLocalHost);
                continue;
            }
            if (host.equals(localHosts[1])) {
                Assert.assertArrayEquals((Object[])is.hostnames(), (Object[])twoLocalHosts);
                continue;
            }
            if (host.equals(localHosts[2])) {
                Assert.assertArrayEquals((Object[])is.hostnames(), (Object[])threeLocalHosts);
                continue;
            }
            Assert.assertArrayEquals((Object[])is.hostnames(), (Object[])noLocalHost);
        }
        Assert.assertTrue((boolean)splits.isEmpty());
        Assert.assertFalse((boolean)ia.getNext("anotherHost").isPresent());
        Assert.assertEquals((long)10L, (long)ia.getNumberOfRemoteAssignments());
        Assert.assertEquals((long)30L, (long)ia.getNumberOfLocalAssignments());
    }

    @Test
    public void testAssignmentMixedLocalHost() {
        Optional is;
        String[] hosts = new String[]{"host1", "host1", "host1", "host2", "host2", "host3"};
        int numSplits = 10 * hosts.length;
        HashSet<FileSourceSplit> splits = new HashSet<FileSourceSplit>();
        for (int i = 0; i < numSplits; ++i) {
            splits.add(LocalityAwareSplitAssignerTest.createSplit(i, hosts[i % hosts.length]));
        }
        LocalityAwareSplitAssigner ia = new LocalityAwareSplitAssigner(splits);
        int i = 0;
        while ((is = ia.getNext(hosts[i++ % hosts.length])).isPresent()) {
            Assert.assertTrue((boolean)splits.remove(is.get()));
        }
        Assert.assertTrue((boolean)splits.isEmpty());
        Assert.assertFalse((boolean)ia.getNext("anotherHost").isPresent());
        Assert.assertEquals((long)0L, (long)ia.getNumberOfRemoteAssignments());
        Assert.assertEquals((long)numSplits, (long)ia.getNumberOfLocalAssignments());
    }

    @Test
    public void testAssignmentOfManySplitsRandomly() {
        int i;
        long seed = Calendar.getInstance().getTimeInMillis();
        int numSplits = 1000;
        String[] splitHosts = new String[256];
        String[] requestingHosts = new String[256];
        Random rand = new Random(seed);
        for (i = 0; i < splitHosts.length; ++i) {
            splitHosts[i] = "localHost" + i;
        }
        for (i = 0; i < requestingHosts.length; ++i) {
            requestingHosts[i] = i % 2 == 0 ? "localHost" + i : "remoteHost" + i;
        }
        String[] stringArray = new String[]{};
        HashSet<String> hosts = new HashSet<String>();
        HashSet<FileSourceSplit> splits = new HashSet<FileSourceSplit>();
        for (int i2 = 0; i2 < 1000; ++i2) {
            while (hosts.size() < 3) {
                hosts.add(splitHosts[rand.nextInt(splitHosts.length)]);
            }
            splits.add(LocalityAwareSplitAssignerTest.createSplit(i2, hosts.toArray(stringArray)));
            hosts.clear();
        }
        LocalityAwareSplitAssigner ia = new LocalityAwareSplitAssigner(splits);
        for (int i3 = 0; i3 < 1000; ++i3) {
            Optional split = ia.getNext(requestingHosts[rand.nextInt(requestingHosts.length)]);
            Assert.assertTrue((boolean)split.isPresent());
            Assert.assertTrue((boolean)splits.remove(split.get()));
        }
        Assert.assertTrue((boolean)splits.isEmpty());
        Assert.assertFalse((boolean)ia.getNext("testHost").isPresent());
    }

    private static FileSourceSplit createSplit(int id, String ... hosts) {
        return new FileSourceSplit(String.valueOf(id), TEST_PATH, 0L, 1024L, hosts);
    }
}

