/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.file.src;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import java.util.zip.GZIPOutputStream;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.eventtime.WatermarkStrategy;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.connector.source.Source;
import org.apache.flink.configuration.CheckpointingOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.connector.file.src.FileSource;
import org.apache.flink.connector.file.src.reader.StreamFormat;
import org.apache.flink.connector.file.src.reader.TextLineFormat;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.checkpoint.CheckpointIDCounter;
import org.apache.flink.runtime.checkpoint.CheckpointRecoveryFactory;
import org.apache.flink.runtime.checkpoint.CompletedCheckpointStore;
import org.apache.flink.runtime.checkpoint.StandaloneCheckpointIDCounter;
import org.apache.flink.runtime.highavailability.nonha.embedded.TestingEmbeddedHaServices;
import org.apache.flink.runtime.minicluster.MiniCluster;
import org.apache.flink.runtime.minicluster.RpcServiceSharing;
import org.apache.flink.runtime.minicluster.TestingMiniCluster;
import org.apache.flink.runtime.minicluster.TestingMiniClusterConfiguration;
import org.apache.flink.runtime.testingUtils.TestingUtils;
import org.apache.flink.runtime.testutils.RecoverableCompletedCheckpointStore;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.DataStreamSource;
import org.apache.flink.streaming.api.datastream.DataStreamUtils;
import org.apache.flink.streaming.api.operators.collect.ClientAndIterator;
import org.apache.flink.streaming.util.TestStreamEnvironment;
import org.apache.flink.util.TestLogger;
import org.apache.flink.util.function.FunctionWithException;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class FileSourceTextLinesITCase
extends TestLogger {
    private static final int PARALLELISM = 4;
    @ClassRule
    public static final TemporaryFolder TMP_FOLDER = new TemporaryFolder();
    private static TestingMiniCluster miniCluster;
    private static TestingEmbeddedHaServices highAvailabilityServices;
    private static CompletedCheckpointStore checkpointStore;
    private static final String[] FILE_PATHS;
    private static final String[] HIDDEN_JUNK_PATHS;
    private static final String[] LINES;
    private static final String[][] LINES_PER_FILE;

    @BeforeClass
    public static void setupMiniCluster() throws Exception {
        highAvailabilityServices = new HaServices(TestingUtils.defaultExecutor(), () -> checkpointStore, (CheckpointIDCounter)new StandaloneCheckpointIDCounter());
        Configuration configuration = FileSourceTextLinesITCase.createConfiguration();
        miniCluster = new TestingMiniCluster(new TestingMiniClusterConfiguration.Builder().setConfiguration(configuration).setNumTaskManagers(1).setNumSlotsPerTaskManager(4).setRpcServiceSharing(RpcServiceSharing.DEDICATED).build(), () -> highAvailabilityServices);
        miniCluster.start();
    }

    private static Configuration createConfiguration() throws IOException {
        Configuration configuration = new Configuration();
        String checkPointDir = Path.fromLocalFile((File)TMP_FOLDER.newFolder()).toUri().toString();
        configuration.set(CheckpointingOptions.CHECKPOINTS_DIRECTORY, (Object)checkPointDir);
        return configuration;
    }

    @Before
    public void setup() {
        checkpointStore = new RecoverableCompletedCheckpointStore();
    }

    @AfterClass
    public static void shutdownMiniCluster() throws Exception {
        if (miniCluster != null) {
            miniCluster.close();
        }
        if (highAvailabilityServices != null) {
            highAvailabilityServices.closeAndCleanupAllData();
            highAvailabilityServices = null;
        }
    }

    @Test
    public void testBoundedTextFileSource() throws Exception {
        this.testBoundedTextFileSource(FailoverType.NONE);
    }

    @Test
    public void testBoundedTextFileSourceWithTaskManagerFailover() throws Exception {
        this.testBoundedTextFileSource(FailoverType.TM);
    }

    @Test
    public void testBoundedTextFileSourceWithJobManagerFailover() throws Exception {
        this.testBoundedTextFileSource(FailoverType.JM);
    }

    private void testBoundedTextFileSource(FailoverType failoverType) throws Exception {
        File testDir = TMP_FOLDER.newFolder();
        FileSourceTextLinesITCase.writeAllFiles(testDir);
        FileSourceTextLinesITCase.writeHiddenJunkFiles(testDir);
        FileSource source = FileSource.forRecordStreamFormat((StreamFormat)new TextLineFormat(), (Path[])new Path[]{Path.fromLocalFile((File)testDir)}).build();
        TestStreamEnvironment env = new TestStreamEnvironment((MiniCluster)miniCluster, 4);
        env.setParallelism(4);
        DataStreamSource stream = env.fromSource((Source)source, WatermarkStrategy.noWatermarks(), "file-source");
        DataStream streamFailingInTheMiddleOfReading = RecordCounterToFail.wrapWithFailureAfter((DataStream)stream, FileSourceTextLinesITCase.LINES.length / 2);
        ClientAndIterator client = DataStreamUtils.collectWithClient((DataStream)streamFailingInTheMiddleOfReading, (String)"Bounded TextFiles Test");
        JobID jobId = client.client.getJobID();
        RecordCounterToFail.waitToFail();
        FileSourceTextLinesITCase.triggerFailover(failoverType, jobId, () -> RecordCounterToFail.continueProcessing());
        ArrayList<String> result = new ArrayList<String>();
        while (client.iterator.hasNext()) {
            result.add((String)client.iterator.next());
        }
        FileSourceTextLinesITCase.verifyResult(result);
    }

    @Test
    public void testContinuousTextFileSource() throws Exception {
        this.testContinuousTextFileSource(FailoverType.NONE);
    }

    @Test
    public void testContinuousTextFileSourceWithTaskManagerFailover() throws Exception {
        this.testContinuousTextFileSource(FailoverType.TM);
    }

    @Test
    public void testContinuousTextFileSourceWithJobManagerFailover() throws Exception {
        this.testContinuousTextFileSource(FailoverType.JM);
    }

    private void testContinuousTextFileSource(FailoverType type) throws Exception {
        File testDir = TMP_FOLDER.newFolder();
        FileSource source = ((FileSource.FileSourceBuilder)FileSource.forRecordStreamFormat((StreamFormat)new TextLineFormat(), (Path[])new Path[]{Path.fromLocalFile((File)testDir)}).monitorContinuously(Duration.ofMillis(5L))).build();
        TestStreamEnvironment env = new TestStreamEnvironment((MiniCluster)miniCluster, 4);
        env.setParallelism(4);
        env.enableCheckpointing(10L);
        DataStreamSource stream = env.fromSource((Source)source, WatermarkStrategy.noWatermarks(), "file-source");
        ClientAndIterator client = DataStreamUtils.collectWithClient((DataStream)stream, (String)"Continuous TextFiles Monitoring Test");
        JobID jobId = client.client.getJobID();
        int numLinesFirst = LINES_PER_FILE[0].length;
        int numLinesAfter = LINES.length - numLinesFirst;
        FileSourceTextLinesITCase.writeFile(testDir, 0);
        List result1 = DataStreamUtils.collectRecordsFromUnboundedStream((ClientAndIterator)client, (int)numLinesFirst);
        for (int i = 1; i < LINES_PER_FILE.length; ++i) {
            boolean failAfterHalfOfInput;
            Thread.sleep(10L);
            FileSourceTextLinesITCase.writeFile(testDir, i);
            boolean bl = failAfterHalfOfInput = i == LINES_PER_FILE.length / 2;
            if (!failAfterHalfOfInput) continue;
            FileSourceTextLinesITCase.triggerFailover(type, jobId, () -> {});
        }
        List result2 = DataStreamUtils.collectRecordsFromUnboundedStream((ClientAndIterator)client, (int)numLinesAfter);
        client.client.cancel().get();
        result1.addAll(result2);
        FileSourceTextLinesITCase.verifyResult(result1);
    }

    private static void triggerFailover(FailoverType type, JobID jobId, Runnable afterFailAction) throws Exception {
        switch (type) {
            case NONE: {
                afterFailAction.run();
                break;
            }
            case TM: {
                FileSourceTextLinesITCase.restartTaskManager(afterFailAction);
                break;
            }
            case JM: {
                FileSourceTextLinesITCase.triggerJobManagerFailover(jobId, afterFailAction);
            }
        }
    }

    private static void triggerJobManagerFailover(JobID jobId, Runnable afterFailAction) throws Exception {
        highAvailabilityServices.revokeJobMasterLeadership(jobId).get();
        afterFailAction.run();
        highAvailabilityServices.grantJobMasterLeadership(jobId).get();
    }

    private static void restartTaskManager(Runnable afterFailAction) throws Exception {
        miniCluster.terminateTaskExecutor(0).get();
        afterFailAction.run();
        miniCluster.startTaskExecutor();
    }

    private static void verifyResult(List<String> lines) {
        Object[] expected = Arrays.copyOf(LINES, LINES.length);
        Object[] actual = lines.toArray(new String[0]);
        Arrays.sort(expected);
        Arrays.sort(actual);
        Assert.assertThat((Object)actual, (Matcher)Matchers.equalTo((Object)expected));
    }

    private static String[][] splitLinesForFiles() {
        String[][] result = new String[FILE_PATHS.length][];
        int linesPerFile = LINES.length / FILE_PATHS.length;
        int linesForLastFile = LINES.length - (FILE_PATHS.length - 1) * linesPerFile;
        int pos = 0;
        for (int i = 0; i < FILE_PATHS.length - 1; ++i) {
            String[] lines = new String[linesPerFile];
            result[i] = lines;
            for (int k = 0; k < lines.length; ++k) {
                lines[k] = LINES[pos++];
            }
        }
        String[] lines = new String[linesForLastFile];
        result[result.length - 1] = lines;
        for (int k = 0; k < lines.length; ++k) {
            lines[k] = LINES[pos++];
        }
        return result;
    }

    private static void writeFile(File testDir, int num) throws IOException {
        File file = new File(testDir, FILE_PATHS[num]);
        FileSourceTextLinesITCase.writeFileAtomically(file, LINES_PER_FILE[num]);
    }

    private static void writeCompressedFile(File testDir, int num) throws IOException {
        File file = new File(testDir, FILE_PATHS[num] + ".gz");
        FileSourceTextLinesITCase.writeFileAtomically(file, LINES_PER_FILE[num], (FunctionWithException<OutputStream, OutputStream, IOException>)((FunctionWithException)GZIPOutputStream::new));
    }

    private static void writeAllFiles(File testDir) throws IOException {
        for (int i = 0; i < FILE_PATHS.length; ++i) {
            if (i % 2 == 0) {
                FileSourceTextLinesITCase.writeFile(testDir, i);
                continue;
            }
            FileSourceTextLinesITCase.writeCompressedFile(testDir, i);
        }
    }

    private static void writeHiddenJunkFiles(File testDir) throws IOException {
        String[] junkContents = new String[]{"This should not end up in the test result.", "Foo bar bazzl junk"};
        for (String junkPath : HIDDEN_JUNK_PATHS) {
            File file = new File(testDir, junkPath);
            FileSourceTextLinesITCase.writeFileAtomically(file, junkContents);
        }
    }

    private static void writeFileAtomically(File file, String[] lines) throws IOException {
        FileSourceTextLinesITCase.writeFileAtomically(file, lines, (FunctionWithException<OutputStream, OutputStream, IOException>)((FunctionWithException)v -> v));
    }

    private static void writeFileAtomically(File file, String[] lines, FunctionWithException<OutputStream, OutputStream, IOException> streamEncoderFactory) throws IOException {
        File stagingFile = new File(TMP_FOLDER.getRoot(), ".tmp-" + UUID.randomUUID().toString());
        try (FileOutputStream fileOut = new FileOutputStream(stagingFile);
             OutputStream out = (OutputStream)streamEncoderFactory.apply((Object)fileOut);
             OutputStreamWriter encoder = new OutputStreamWriter(out, StandardCharsets.UTF_8);
             PrintWriter writer = new PrintWriter(encoder);){
            for (String line : lines) {
                writer.println(line);
            }
        }
        File parent = file.getParentFile();
        Assert.assertTrue((parent.mkdirs() || parent.exists() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)stagingFile.renameTo(file));
    }

    static {
        FILE_PATHS = new String[]{"text.2", "nested1/text.1", "text.1", "text.3", "nested2/nested21/text", "nested1/text.2", "nested2/text"};
        HIDDEN_JUNK_PATHS = new String[]{"_something", ".junk", "nested1/.somefile", "othernested/_ignoredfile", "_nested/file", "nested1/.intermediate/somefile"};
        LINES = new String[]{"To be, or not to be,--that is the question:--", "Whether 'tis nobler in the mind to suffer", "The slings and arrows of outrageous fortune", "Or to take arms against a sea of troubles,", "And by opposing end them?--To die,--to sleep,--", "No more; and by a sleep to say we end", "The heartache, and the thousand natural shocks", "That flesh is heir to,--'tis a consummation", "Devoutly to be wish'd. To die,--to sleep;--", "To sleep! perchance to dream:--ay, there's the rub;", "For in that sleep of death what dreams may come,", "When we have shuffled off this mortal coil,", "Must give us pause: there's the respect", "That makes calamity of so long life;", "For who would bear the whips and scorns of time,", "The oppressor's wrong, the proud man's contumely,", "The pangs of despis'd love, the law's delay,", "The insolence of office, and the spurns", "That patient merit of the unworthy takes,", "When he himself might his quietus make", "With a bare bodkin? who would these fardels bear,", "To grunt and sweat under a weary life,", "But that the dread of something after death,--", "The undiscover'd country, from whose bourn", "No traveller returns,--puzzles the will,", "And makes us rather bear those ills we have", "Than fly to others that we know not of?", "Thus conscience does make cowards of us all;", "And thus the native hue of resolution", "Is sicklied o'er with the pale cast of thought;", "And enterprises of great pith and moment,", "With this regard, their currents turn awry,", "And lose the name of action.--Soft you now!", "The fair Ophelia!--Nymph, in thy orisons", "Be all my sins remember'd."};
        LINES_PER_FILE = FileSourceTextLinesITCase.splitLinesForFiles();
    }

    private static class RecordCounterToFail {
        private static AtomicInteger records;
        private static CompletableFuture<Void> fail;
        private static CompletableFuture<Void> continueProcessing;

        private RecordCounterToFail() {
        }

        private static <T> DataStream<T> wrapWithFailureAfter(DataStream<T> stream, int failAfter) {
            records = new AtomicInteger();
            fail = new CompletableFuture();
            continueProcessing = new CompletableFuture();
            return stream.map((MapFunction & Serializable)record -> {
                boolean notFailedYet;
                boolean halfOfInputIsRead = records.incrementAndGet() > failAfter;
                boolean bl = notFailedYet = !fail.isDone();
                if (notFailedYet && halfOfInputIsRead) {
                    fail.complete(null);
                    continueProcessing.get();
                }
                return record;
            });
        }

        private static void waitToFail() throws ExecutionException, InterruptedException {
            fail.get();
        }

        private static void continueProcessing() {
            continueProcessing.complete(null);
        }
    }

    private static class CheckpointRecoveryFactoryWithSettableStore
    implements CheckpointRecoveryFactory {
        private final Supplier<CompletedCheckpointStore> completedCheckpointStoreFactory;
        private final CheckpointIDCounter checkpointIDCounter;

        private CheckpointRecoveryFactoryWithSettableStore(Supplier<CompletedCheckpointStore> completedCheckpointStoreFactory, CheckpointIDCounter checkpointIDCounter) {
            this.completedCheckpointStoreFactory = completedCheckpointStoreFactory;
            this.checkpointIDCounter = checkpointIDCounter;
        }

        public CompletedCheckpointStore createCheckpointStore(JobID jobId, int maxNumberOfCheckpointsToRetain, ClassLoader userClassLoader) {
            return this.completedCheckpointStoreFactory.get();
        }

        public CheckpointIDCounter createCheckpointIDCounter(JobID jobId) {
            return this.checkpointIDCounter;
        }
    }

    private static class HaServices
    extends TestingEmbeddedHaServices {
        private final Supplier<CompletedCheckpointStore> completedCheckpointStoreFactory;
        private final CheckpointIDCounter checkpointIDCounter;

        private HaServices(Executor executor, Supplier<CompletedCheckpointStore> completedCheckpointStoreFactory, CheckpointIDCounter checkpointIDCounter) {
            super(executor);
            this.completedCheckpointStoreFactory = completedCheckpointStoreFactory;
            this.checkpointIDCounter = checkpointIDCounter;
        }

        public CheckpointRecoveryFactory getCheckpointRecoveryFactory() {
            return new CheckpointRecoveryFactoryWithSettableStore(this.completedCheckpointStoreFactory, this.checkpointIDCounter);
        }
    }

    private static enum FailoverType {
        NONE,
        TM,
        JM;

    }
}

