/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.file.src;

import java.util.Optional;
import org.apache.flink.connector.file.src.FileSourceSplit;
import org.apache.flink.connector.file.src.FileSourceSplitState;
import org.apache.flink.connector.file.src.util.CheckpointedPosition;
import org.apache.flink.core.fs.Path;
import org.junit.Assert;
import org.junit.Test;

public class FileSourceSplitStateTest {
    @Test
    public void testRoundTripWithoutModification() {
        FileSourceSplit split = FileSourceSplitStateTest.getTestSplit();
        FileSourceSplitState state = new FileSourceSplitState(split);
        FileSourceSplit resultSplit = state.toFileSourceSplit();
        Assert.assertEquals((Object)split.getReaderPosition(), (Object)resultSplit.getReaderPosition());
    }

    @Test
    public void testStateStartsWithSplitValues() {
        FileSourceSplit split = FileSourceSplitStateTest.getTestSplit(new CheckpointedPosition(123L, 456L));
        FileSourceSplitState state = new FileSourceSplitState(split);
        Assert.assertEquals((long)123L, (long)state.getOffset());
        Assert.assertEquals((long)456L, (long)state.getRecordsToSkipAfterOffset());
    }

    @Test
    public void testNewSplitTakesModifiedOffsetAndCount() {
        FileSourceSplit split = FileSourceSplitStateTest.getTestSplit();
        FileSourceSplitState state = new FileSourceSplitState(split);
        state.setPosition(1234L, 7566L);
        Optional position = state.toFileSourceSplit().getReaderPosition();
        Assert.assertTrue((boolean)position.isPresent());
        Assert.assertEquals((Object)new CheckpointedPosition(1234L, 7566L), position.get());
    }

    private static FileSourceSplit getTestSplit() {
        return FileSourceSplitStateTest.getTestSplit(null);
    }

    private static FileSourceSplit getTestSplit(CheckpointedPosition position) {
        return new FileSourceSplit("test-id", new Path("file:/some/random/path"), 17L, 121L, new String[]{"localhost"}, position);
    }
}

